package sra.isr.interfaces.progress;

import java.awt.*;
import javax.swing.*;
import sra.smalltalk.*;

/**
 * IsrProgressViewSwing class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       2000/03/16 (by Mitsuhiro Asada)
 * 	@updated:       N/A
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrProgressViewSwing.java,v 1.2 2000/04/07 04:28:52 m-asada Exp $
 */
public class IsrProgressViewSwing extends StViewJPanel implements IsrProgressView {
	protected JFrame popupDialog;
	protected boolean isPopupDialog;
	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		this.setPreferredSize(new Dimension(226, 60));
	}
	/**
	 * Answer a default model.
	 *
	 * @return sra.smalltalk.StModel
	 */
	protected StModel defaultModel() {
		return new IsrProgress();
	}
	/**
	 * Display the message using the Graphics.
	 *
	 * @param graphics java.awt.Graphics
	 */
	public void displayMessageOn_(Graphics graphics) {
		String messageString = this.getModel().message();

		// Change the font size.
		Font font = graphics.getFont();
		font = new Font(font.getName(), font.getStyle(), 16);
		graphics.setFont(font);

		//
		FontMetrics fontMetrics = graphics.getFontMetrics();
		int width = fontMetrics.stringWidth(messageString);
		int height = fontMetrics.getHeight();
		int base = fontMetrics.getAscent();
		Rectangle displayRectangle = new Rectangle(0, 0, width, height);
		Rectangle scaleRectangle = new Rectangle(0, 0, 200 + 1, displayRectangle.height);
		Rectangle bounds = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
		Rectangle clippingRectangle = new Rectangle(bounds.width, bounds.height / 3);
		int x, y;
		x = clippingRectangle.x + clippingRectangle.width / 2;
		x -= scaleRectangle.x + scaleRectangle.width / 2;
		y = clippingRectangle.y + clippingRectangle.height;
		y -= scaleRectangle.y + scaleRectangle.height;
		scaleRectangle.translate(x, y);
		x = scaleRectangle.x - displayRectangle.x;
		y = scaleRectangle.y + scaleRectangle.height;
		y -= displayRectangle.y + displayRectangle.height;
		displayRectangle.translate(x, y);
		graphics.setClip(clippingRectangle.x, clippingRectangle.y, clippingRectangle.width, clippingRectangle.height);
		graphics.clearRect(clippingRectangle.x, clippingRectangle.y, clippingRectangle.width, clippingRectangle.height);
		graphics.setColor(Color.black);
		graphics.drawString(messageString, displayRectangle.x, displayRectangle.y + base);
	}
	/**
	 * Display the receiver using the Graphics.
	 *
	 * @param graphics java.awt.Graphics
	 */
	public void displayOn_(Graphics graphics) {
		Dimension size = this.getSize();
		Image offScreenImage = this.createImage(size.width, size.height);
		Graphics offScreenGraphics = offScreenImage.getGraphics();
		try {
			this.displayMessageOn_(offScreenGraphics);
			this.displayScaleOn_(offScreenGraphics);
			this.displayValueOn_(offScreenGraphics);
		} finally {
			graphics.drawImage(offScreenImage, 0, 0, this);
			offScreenGraphics.dispose();
			offScreenImage.flush();
		}
	}
	/**
	 * Display the scale using the Graphics.
	 *
	 * @param graphics java.awt.Graphics
	 */
	public void displayScaleOn_(Graphics graphics) {
		Rectangle displayRectangle = new Rectangle(0, 0, 200 + 1, 10);
		Rectangle bounds = new Rectangle(0, 0, this.getSize().width, this.getSize().height);;
		Rectangle clippingRectangle = new Rectangle(0, bounds.height / 3 * 2, bounds.width, bounds.height / 3);
		int x = clippingRectangle.x + clippingRectangle.width / 2;
		x -= displayRectangle.x + displayRectangle.width / 2;
		int y = clippingRectangle.y - displayRectangle.y;
		displayRectangle.translate(x, y);
		graphics.setClip(clippingRectangle.x, clippingRectangle.y, clippingRectangle.width, clippingRectangle.height);
		graphics.clearRect(clippingRectangle.x, clippingRectangle.y, clippingRectangle.width, clippingRectangle.height);
		graphics.setColor(Color.black);
		x = displayRectangle.x;
		for (int n = 0; n <= 100; n++) {
			if (n % 5 == 0) {
				if (n % 10 == 0) {
					if (n % 50 == 0) {
						y = displayRectangle.y;
						graphics.drawLine(x, y, x, y + 10);
					} else {
						y = displayRectangle.y + 2;
						graphics.drawLine(x, y, x, y + 6);
					}
				} else {
					if (n % 25 == 0) {
						y = displayRectangle.y + 4;
						graphics.drawLine(x, y, x, y + 6);
					} else {
						y = displayRectangle.y + 4;
						graphics.drawLine(x, y, x, y + 4);
					}
				}
			} else {
				y = displayRectangle.y + 6;
				graphics.drawLine(x, y, x, y + 2);
			}
			x += 2;
		}
	}
	/**
	 * Display the value using the Graphics.
	 *
	 * @param graphics java.awt.Graphics
	 */
	public void displayValueOn_(Graphics graphics) {
		float progressValue = this.getModel().value();
		Rectangle gaugeRectangle = new Rectangle(0, 0, 6, 12);
		Rectangle displayRectangle = new Rectangle(0, 0, 200 + 1, 10);
		Rectangle bounds = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
		;
		Rectangle clippingRectangle = new Rectangle(0, bounds.height / 3, bounds.width, bounds.height / 3);
		int x, y;
		x = clippingRectangle.x + clippingRectangle.width / 2;
		x -= displayRectangle.x + displayRectangle.width / 2;
		y = clippingRectangle.y + clippingRectangle.height;
		y -= displayRectangle.y + displayRectangle.height;
		displayRectangle.translate(x, y);
		x = displayRectangle.x;
		x -= gaugeRectangle.x + gaugeRectangle.width / 2;
		y = displayRectangle.y + displayRectangle.height;
		y -= gaugeRectangle.y + gaugeRectangle.height;
		gaugeRectangle.translate(x, y);
		gaugeRectangle.translate((int) (progressValue * 200), -1);
		x = gaugeRectangle.x;
		y = gaugeRectangle.y;
		int width = gaugeRectangle.width;
		int height = gaugeRectangle.height;
		Polygon polygon = new Polygon();
		polygon.addPoint(x + width / 2, y);
		polygon.addPoint(x + width, y + height / 2);
		polygon.addPoint(x + width / 2, y + height);
		polygon.addPoint(x, y + height / 2);
		polygon.addPoint(x + width / 2, y);
		graphics.setClip(clippingRectangle.x, clippingRectangle.y, clippingRectangle.width, clippingRectangle.height);
		graphics.clearRect(clippingRectangle.x, clippingRectangle.y, clippingRectangle.width, clippingRectangle.height);
		graphics.setColor(Color.gray);
		graphics.fillPolygon(polygon);
		graphics.setColor(Color.black);
		graphics.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
	}
	/**
	 * model property accessing.
	 *
	 * @return <StModel subclass>
	 */
	public IsrProgress getModel() {
		return (IsrProgress) this.model();
	}
	/**
	 * 
	 * @return boolean
	 */
	public boolean isPopupDialog() {
		return isPopupDialog;
	}
	/**
	 * 
	 * @param aBoolean boolean
	 */
	protected void isPopupDialog_(boolean aBoolean) {
		isPopupDialog = aBoolean;
	}
	/**
	 * 
	 * @param aBoolean boolean
	 */
	public void setPopupDialog(boolean aBoolean) {
		isPopupDialog = aBoolean;
	}
	/**
	 * Update the receiver according to the change notification from the model.
	 * @param evt sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		StSymbol aspectSymbol = evt.getAspect();
		if (aspectSymbol == $("start")) {
			if (this.isPopupDialog()) {
				popupDialog = new JFrame("Progress");
				popupDialog.getContentPane().setLayout(new BorderLayout());
				popupDialog.getContentPane().add("Center", this);
				popupDialog.setSize(this.getSize());
				popupDialog.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
				popupDialog.pack();
				popupDialog.show();
				try {
					Thread.sleep(1);
				} catch (Exception e) {
				}
			}
		}
		if (aspectSymbol == $("end")) {
			if (this.isPopupDialog()) {
				popupDialog.dispose();
				popupDialog = null;
				this.model().removeDependent_(this);
			}
		}
		if (aspectSymbol == $("value")) {
			Graphics graphics = this.getGraphics();
			try {
				this.displayOn_(graphics);
			} finally {
				graphics.dispose();
			}
		}
		if (aspectSymbol == $("message")) {
			Graphics graphics = this.getGraphics();
			try {
				this.displayOn_(graphics);
			} finally {
				graphics.dispose();
			}
		}
	}
}