package sra.isr.interfaces.progress;

import sra.smalltalk.*;
import sra.isr.system.support.*;

/**
 * IsrProgressTestExamples class
 * 
 * 	@author:        nisinaka
 * 	@created:       1998/11/18 (by nisinaka)
 * 	@updated:       2000/02/16 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrProgressTestExamples.java,v 1.4 2000/04/07 04:24:19 m-asada Exp $
 */
public class IsrProgressTestExamples extends IsrTestExamples {
	/**
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		final int size = 100;
		IsrProgress aProgress = new IsrProgress();
		aProgress.do_(new StBlockClosure() {
			public Object value_(Object anObject) {
				IsrProgress progress = (IsrProgress) anObject;
				for (int count = 1; count <= size; count++) {
					float value = (float) count / size;
					progress.message_(String.valueOf(value));
					progress.value_(value);
				}
				return null;
			}
		});
		return true;
	}
	/**
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		final int size = 100;
		IsrProgress aProgress = new IsrProgress();
		aProgress.open();
		aProgress.do_(new StBlockClosure() {
			public Object value_(Object anObject) {
				IsrProgress progress = (IsrProgress) anObject;
				for (int count = 1; count <= size; count++) {
					float value = (float) count / size;
					progress.message_(String.valueOf(value));
					progress.value_(value);
				}
				return null;
			}
		});
		return true;
	}
	/**
	 * Execute all examples.
	 *
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		new IsrProgressTestExamples();
	}
}