package sra.isr.interfaces.progress;

import java.awt.*;
import sra.smalltalk.*;

/**
 * IsrProgress class
 * 
 * 	@author:        nisinaka
 * 	@created:       1998/11/06 (by nisinaka)
 * 	@updated:       1999/08/05 (by nisinaka)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrProgress.java,v 1.5 2000/04/07 04:24:19 m-asada Exp $
 */
public class IsrProgress extends StApplicationModel {
	/**
	 * The progress value.
	 */
	protected float progressValue = 0;

	/**
	 * The progress message.
	 */
	protected String progressMessage = new String();

	/**
	 * The stop condition.
	 */
	protected boolean stopCondition;

	/**
	 * The rasing flag.
	 */
	protected boolean raisingFlag = false;
	/**
	 * Answer a default view.
	 * @return sra.smalltalk.StView
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new IsrProgressViewAwt();
		} else {
			return this.CreateView("sra.isr.interfaces.progress.IsrProgressViewSwing");
		}
	}
	/**
	 * Evaluate the BlockClosure.
	 *
	 * @return java.lang.Object
	 * @param aBlock sra.smalltalk.StBlockClosure
	 */
	public Object do_(StBlockClosure aBlock) {
		if (this.myDependents() == null || this.myDependents().isEmpty()) {
			IsrProgressView aView = (IsrProgressView) this.defaultView();
			aView.setPopupDialog(true);
			aView.model_(this);
		}
		Object result = null;
		//
		this.changed_($("start"));
		raisingFlag = true;
		try {
			result = this.run_(aBlock);
		} finally {
			this.changed_($("end"));
			raisingFlag = false;
		}
		return result;
	}
	/**
	 * Answer the progress message.
	 *
	 * @return java.lang.String
	 */
	public String message() {
		return progressMessage;
	}
	/**
	 * Set the progress message and update the receiver.
	 *
	 * @param aString java.lang.String
	 */
	public void message_(String aString) {
		String oldString = progressMessage;
		progressMessage = aString;
		if (!progressMessage.equals(oldString)) {
			this.changed_($("message"));
		}
	}
	/**
	 * Answer the current raising flag.
	 *
	 * @return boolean
	 */
	protected final boolean raisingFlag() {
		return raisingFlag;
	}
	/**
	 * Evaluate the block while in progress.
	 *
	 * @return java.lang.Object
	 * @param aBlock sra.smalltalk.StBlockClosure
	 */
	public Object run_(StBlockClosure aBlock) {
		Object result = null;
		if (aBlock.numArgs() == 0) {
			result = aBlock.value();
		} else {
			result = aBlock.value_(this);
		}
		return result;
	}
	/**
	 * Answer the progress value.
	 *
	 * @return float
	 */
	public float value() {
		return progressValue;
	}
	/**
	 * Set the progress value and update the receiver.
	 *
	 * @param normalizedNumber float
	 */
	public void value_(float normalizedNumber) {
		if (0 <= normalizedNumber && normalizedNumber <= 1) {
			float oldValue = progressValue;
			progressValue = normalizedNumber;
			if (progressValue != oldValue) {
				this.changed_($("value"));
			}
		}
	}
}