package sra.isr.geometry.basic;

import sra.smalltalk.*;
import sra.isr.geometry.abstracts.*;

/**
 * IsrPoint class
 * 
 * 	@author:        nisinaka
 * 	@created:       1998/09/29 (by nisinaka)
 * 	@updated:       2000/02/16 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrPoint.java,v 1.3 2000/04/07 04:24:15 m-asada Exp $
 */
public abstract class IsrPoint extends IsrGeometry {
	/**
	 * Answer the absolute Point.
	 *
	 * @return sra.jun.geometry.basic.IsrPoint
	 */
	public abstract IsrPoint abs();
	/**
	 * Answer the receiver as an array of double.
	 *
	 * @return double[]
	 */
	public abstract double[] asArray();
	/**
	 * Answer the number representing the ordering of the receiver in
	 * the generality hierarchy.
	 *
	 * @return int
	 */
	public abstract int generality();
	// Hash Function

	/**
	 * Computes a hash code for this object.
	 */
	public int hashCode() {
		throw SmalltalkException.SubclassResponsibility();
	}
	/**
	 * Answer the length from the origin.
	 *
	 * @return double
	 */
	public double length() {
		return this.rho();
	}
	/**
	 * Answer the rho as of a polar coordinate.
	 *
	 * @return int
	 */
	public abstract double rho();
}