package sra.isr.system.support;

import java.awt.*;
import java.awt.event.*;
import java.lang.reflect.*;
import java.util.Hashtable;
import sra.smalltalk.*;
import sra.isr.image.searcher.*;
import sra.isr.image.browser.*;
import sra.isr.interfaces.display.*;

/**
 * IsrLauncher class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       2000/02/23 (by Mitsuhiro Asada)
 * 	@updated:       N/A
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrLauncher.java,v 1.5 2000/04/07 04:24:20 m-asada Exp $
 */
public class IsrLauncher extends IsrDisplayModel {
	static private Object swingAnchor;
	static protected boolean _closeToExit;
	//
	protected StMenuModel menuModel;
	/**
	 *
	 */
	public IsrLauncher() {
		super();
		this.visual_(IsrSystem.LogoImage());
		this.open();
	}
	/**
	 * Create a menu for Test.
	 *
	 * @return sra.smalltalk.StMenu
	 */
	protected StMenu _allTestMenu() {
		Hashtable testPackageMenus = new Hashtable();
		StMenu testMenu = new StMenu("Test");
		Class[] classes = TestExamplesClasses();
		for (int i = 0; i < classes.length; i++) {
			String className = classes[i].getName();
			String packageName = className.substring(0, className.lastIndexOf('.'));
			StMenu packageMenu = (StMenu) testPackageMenus.get(packageName);
			if (packageMenu == null) {
				packageMenu = new StMenu(packageName);
				testMenu.add(packageMenu);
				testPackageMenus.put(packageName, packageMenu);
			}
			packageMenu.add(this._testMenuFor(classes[i]));
		}
		return testMenu;
	}
	/**
	 * Create a submenu for the specified class.
	 *
	 * @return sra.smalltalk.StMenu
	 * @param aClass java.lang.Class
	 */
	protected StMenu _testMenuFor(Class aClass) {
		String methodNames[] = IsrTestExamples.GetStaticMethodNamesFor(aClass);
		String className = aClass.getName();
		StMenu aMenu = new StMenu(className.substring(className.lastIndexOf('.') + 1));
		StMenuItem anItem = new StMenuItem("All");
		anItem.setActionCommand(className + "#All");
		anItem.addActionListener(this);
		aMenu.add(anItem);
		aMenu.addSeparator();
		for (int i = 0; i < methodNames.length; i++) {
			String methodName = (String) methodNames[i];
			anItem = new StMenuItem(methodName);
			anItem.setActionCommand(className + "#" + methodName);
			anItem.addActionListener(this);
			aMenu.add(anItem);
		}
		return aMenu;
	}
	/**
	 * Invoked when a menu item has been selected. 
	 *
	 * @param ev java.awt.event.ActionEvent 
	 */
	public void actionPerformed(ActionEvent ev) {
		String command = ev.getActionCommand();
		if (command.equals("All")) {
			Class[] classes = TestExamplesClasses();
			for (int i = 0; i < classes.length; i++) {
				IsrTestExamples.ExecuteMethods(classes[i]);
			}
		} else {
			int index = command.indexOf("#");
			if (index < 0) {
				this.executeMethod(this, command);
			} else {
				String className = command.substring(0, index);
				String methodName = command.substring(index + 1, command.length());
				try {
					Class aClass = Class.forName(className);
					if (methodName.equals("All")) {
						IsrTestExamples.ExecuteMethods(aClass);
					} else {
						this.executeMethod(aClass, methodName);
					}
				} catch (Exception e) {
					throw new SmalltalkException(e);
				}
			}
		}
	}
	/**
	 * Create a default menu bar of the JunLauncher.
	 *
	 * @return sra.smalltalk.StMenuModel
	 */
	protected StMenu defaultHelpMenu() {
		StMenu helpMenu = new StMenu("Help");
		helpMenu.add(createMenuItem("About...", "openAbout"));
		helpMenu.addSeparator();
		StMenu viewMenu = new StMenu("Default View Mode");
		StButtonGroup viewGroup = new StButtonGroup();
		StRadioButtonMenuItem awt = createRadioButtonMenuItem("Awt", "viewAwt", viewGroup);
		awt.setSelected(true);
		viewMenu.add(awt);
		StRadioButtonMenuItem swing = createRadioButtonMenuItem("Swing and Awt", "viewSwing", viewGroup);
		swing.setEnabled(StApplicationModel.IsSwingInstalled());
		viewMenu.add(swing);
		helpMenu.add(viewMenu);
		//
		return helpMenu;
	}
	/**
	 * Create a default menu bar of the JunLauncher.
	 *
	 * @return sra.smalltalk.StMenuModel
	 */
	protected StMenuModel defaultMenu() {
		StMenuItem anItem;
		StMenuModel rootMenu = new StMenuModel();
		//
		StMenu toolsMenu = new StMenu("Tools");
		toolsMenu.add(createMenuItem("Image Searcher", "imageSearcher"));
		toolsMenu.add(createMenuItem("Image Browser", "imageBrowser"));
		rootMenu.add(toolsMenu);
		//
		StMenu examplesMenu = new StMenu("Examples");
		examplesMenu.add(this._allTestMenu());
		rootMenu.add(examplesMenu);
		//
		rootMenu.add(this.defaultHelpMenu());
		//
		return rootMenu;
	}
	/**
	 * Answer a default view.
	 * @return sra.smalltalk.StView
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new IsrLauncherViewAwt();
		} else {
			return CreateView("sra.isr.system.support.IsrLauncherViewSwing");
		}
	}
	/**
	 * Execute all methods specified with the method name.
	 *
	 * @param methodName java.lang.String
	 */
	public Object executeMethod(Class aClass, String methodName) {
		Object answer;
		Frame myFrames[] = this.builder().frames();
		Cursor savedCursors[] = new Cursor[myFrames.length];
		for (int i = 0; i < myFrames.length; i++) {
			savedCursors[i] = myFrames[i].getCursor();
			myFrames[i].setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		}
		try {
			answer = StObject._Perform(aClass, methodName);
		} finally {
			for (int i = 0; i < myFrames.length; i++) {
				myFrames[i].setCursor(savedCursors[i]);
			}
		}
		return answer;
	}
	/**
	 * Execute all methods specified with the method name.
	 *
	 * @param methodName java.lang.String
	 */
	public Object executeMethod(StObject anObject, String methodName) {
		Object answer;
		Frame myFrames[] = this.builder().frames();
		Cursor savedCursors[] = new Cursor[myFrames.length];
		for (int i = 0; i < myFrames.length; i++) {
			savedCursors[i] = myFrames[i].getCursor();
			myFrames[i].setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		}
		try {
			answer = anObject.perform_(methodName);
		} finally {
			for (int i = 0; i < myFrames.length; i++) {
				myFrames[i].setCursor(savedCursors[i]);
			}
		}
		return answer;
	}
	/**
	 * Open a ImageBrowser from User.
	 */
	public void imageBrowser() {
		IsrImageBrowser imageBrowser = IsrImageBrowser.FromUser();
		if (imageBrowser == null) {
			return;
		}
		imageBrowser.open();
	}
	/**
	 * Open a ImageSearcher from User.
	 */
	public void imageSearcher() {
		IsrImageSearcher imageSearcher = IsrImageSearcher.FromUser();
		if (imageSearcher == null) {
			return;
		}
		imageSearcher.open();
	}
	/**
	 * Open IsrLauncher.
	 * @param args java.lang.String[]
	 */
	public static void main(String args[]) {
		final String className = "javax.swing.JPopupMenu";
		final String methodName = "setDefaultLightWeightPopupEnabled";
		final Class[] parameterTypes = new Class[] {Boolean.TYPE};
		final Object[] parameters = new Object[] {Boolean.FALSE};
		try {
			Class aClass = Class.forName(className);
			Method aMethod = aClass.getMethod(methodName, parameterTypes);
			aMethod.invoke(aClass, parameters);
			swingAnchor = aClass;
		} catch (Exception e) {
			// Swing not found. Using AWT only.
		}
		//
		_closeToExit = true;
		//
		new IsrLauncher();
	}
	/**
	 * Answer a menu model.
	 * @return sra.smalltalk.StMenuModel
	 */
	public StMenuModel menuModel() {
		if (menuModel == null) {
			menuModel = defaultMenu();
		}
		return menuModel;
	}
	/**
	 * Open a about dialog.
	 */
	public void openAbout() {
		IsrDisplayModel aModel = new IsrDisplayModel();
		aModel.visual_(IsrSystem.LogoImage());
		IsrDisplayViewAwt aView = new IsrDisplayViewAwt();
		aView.model_(aModel);
		aView.adjustSize();
		//
		Panel aCenter = new Panel(new BorderLayout());
		String s = "Isr4Java" + IsrSystem.Version();
		Label ver = new Label(s);
		ver.setFont(new Font("dialog", Font.BOLD, 12));
		aCenter.add("North", ver);
		aCenter.add("Center", aView);
		Panel proj = new Panel(new BorderLayout());
		proj.add("East", new Label("SRA Isr4Java Project"));
		aCenter.add("South", proj);
		//
		Panel aPanel = new Panel(new BorderLayout());
		aPanel.add("Center", aCenter);
		Canvas dummy1 = new Canvas();
		dummy1.setSize(20, 1);
		aPanel.add("West", dummy1);
		Canvas dummy2 = new Canvas();
		dummy2.setSize(20, 1);
		aPanel.add("East", dummy2);
		//
		Frame aFrame = new Frame("Java");
		aFrame.setBackground(Color.white);
		aFrame.add(aPanel);
		aFrame.pack();
		aFrame.setResizable(false);
		aFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		//
		Rectangle bounds = aFrame.getBounds();
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Point centerPoint = new Point(screenSize.width / 2, screenSize.height / 2);
		int originX = Math.max(0, Math.min(centerPoint.x - bounds.width / 2, screenSize.width - bounds.width));
		int originY = Math.max(0, Math.min(centerPoint.y - bounds.height / 2, screenSize.height - bounds.height));
		aFrame.setBounds(originX, originY, bounds.width, bounds.height);
		aFrame.show();
	}
	/**
	 * Answer the array of all TestExamples classes.
	 *
	 * @return java.lang.Class[]
	 */
	public static Class[] TestExamplesClasses() {
		final Class[] testExamplesClasses = {
			sra.isr.image.browser.IsrImageBrowserTestExamples.class,
			sra.isr.image.objects.IsrImageObjectTestExamples.class,
			sra.isr.image.objects.IsrImageFolderTestExamples.class,
			sra.isr.image.searcher.IsrImageSearcherTestExamples.class,
			sra.isr.image.support.IsrImageProcessorTestExamples.class,
			sra.isr.interfaces.area.IsrAreaTestExamples.class,
			sra.isr.interfaces.button.IsrButtonModelTestExamples.class,
			sra.isr.interfaces.colors.IsrColorChoiceTestExamples.class,
			sra.isr.interfaces.display.IsrDisplayModelTestExamples.class,
			sra.isr.interfaces.freehand.IsrFreehandTestExamples.class,
			sra.isr.interfaces.gauge.IsrGaugeTestExamples.class,
			sra.isr.interfaces.nineColors.Isr9ColorsTestExamples.class,
			sra.isr.interfaces.progress.IsrProgressTestExamples.class,
			sra.isr.interfaces.spot.IsrSpotTestExamples.class
		};
		return testExamplesClasses;
	}
	/**
	 * 
	 */
	public void viewAwt() {
		StApplicationModel.SetDefaultViewMode(StApplicationModel.VIEW_AWT);
	}
	/**
	 * 
	 */
	public void viewSwing() {
		if (!StApplicationModel.SetDefaultViewMode(StApplicationModel.VIEW_SWING)) {
			StDialog.Warn_("Can't find a swing package, the view mode is changed to AWT.");
		}
	}
	/**
	 * 
	 */
	public void viewSwingOnly() {
		StApplicationModel.SetDefaultViewMode(StApplicationModel.VIEW_SWING_ONLY);
	}
	/**
	 * Invoked when a window is in the process of being closed.
	 *
	 * @param e java.awt.event.WindowEvent 
	 */
	public void windowClosing(WindowEvent e) {
		if (_closeToExit) {
			Window aWindow = e.getWindow();
			Point location = aWindow.getLocationOnScreen();
			Dimension size = aWindow.getSize();
			location = new Point(location.x + size.width, location.y);
			if (StDialog.Confirm_("Really quit?", false, location) == true) {
				System.exit(0);
			} else {
				aWindow.setVisible(true);
			}
		} else {
			super.windowClosing(e);
		}
	}
	/**
	 * Answer a window title.
	 * @return java.lang.String
	 */
	protected String windowTitle() {
		return "Isr Launcher";
	}
}