package sra.isr.system.support;

import sra.smalltalk.*;

/**
 * IsrJLauncher class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       2000/03/10 (by Mitsuhiro Asada)
 * 	@updated:       N/A
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrJLauncher.java,v 1.2 2000/04/07 04:28:52 m-asada Exp $
 */
public class IsrJLauncher extends IsrLauncher {
	/**
	 * Create a default menu bar of the JunLauncher.
	 *
	 * @return sra.smalltalk.StMenuModel
	 */
	protected StMenu defaultHelpMenu() {
		StMenu helpMenu = new StMenu("Help");
		helpMenu.add(createMenuItem("About...", "openAbout"));
		helpMenu.addSeparator();
		StMenu viewMenu = new StMenu("Default View Mode");
		StButtonGroup viewGroup = new StButtonGroup();
		viewMenu.add(createRadioButtonMenuItem("Awt", "viewAwt", viewGroup));
		viewMenu.add(createRadioButtonMenuItem("Swing Only", "viewSwingOnly", viewGroup));
		((StRadioButtonMenuItem) viewMenu.getItem("Swing Only")).setSelected(true);
		helpMenu.add(viewMenu);
		//
		return helpMenu;
	}
	/**
	 * Open IsrJLauncher.
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		StApplicationModel.SetDefaultViewMode(StApplicationModel.VIEW_SWING_ONLY);
		//
		_closeToExit = true;
		//
		new IsrJLauncher();
	}
}
