package sra.isr.image.streams;

import java.awt.*;
import java.io.*;
import sra.smalltalk.*;

/**
 * IsrImageStream class
 * 
 * 	@author:        Hirotsugu Kondo
 * 	@created:       1999/1/20 (by Hirotsugu Kondo)
 * 	@updated:       N/A
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrImageStream.java,v 1.4 2000/04/07 04:24:17 m-asada Exp $
 */
public abstract class IsrImageStream extends StObject {
	protected InputStream imageStream;
	protected int position = 0;
	/**
	 * 
	 * @param stream java.io.InputStream
	 */
	protected boolean hasMagicNumber_(byte[] aByteArray) {
		int size = aByteArray.length;
		int read = 0;
		boolean flag = true;
		for (int i = 0; i < size; i++) {
			read = this.next();
			if (read == -1) {
				return false;
			};
			flag = flag & (read == aByteArray[i]);
		};
		return flag;
	}
	/**
	 * 
	 * 
	 */
	public int next() {
		int nextValue = -1;
		try {
			nextValue = this.imageStream.read();
			this.position = this.position + 1;
		} catch (Exception e) {
		};
		return nextValue;
	}
	/**
	 * 
	 * @return StImage
	 */
	public abstract StImage nextImage();
	/**
	 * 
	 * 
	 */
	public long nextLong() {
		int byte1 = this.next();
		int byte2 = this.next();
		int byte3 = this.next();
		int byte4 = this.next();
		return (byte1 << 24) + (byte2 << 16) + (byte3 << 8) + byte4;
	}
	/**
	 * 
	 * 
	 */
	public int nextWord() {
		int byte1 = this.next();
		int byte2 = this.next();
		return (byte1 << 8) + byte2;
	}
	/**
	 * 
	 * @param stream java.io.InputStream
	 */
	protected void on_(InputStream stream) {
		this.imageStream = stream;
	}
}
