package sra.isr.image.searcher;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import sra.smalltalk.*;
import sra.isr.system.support.*;
import sra.isr.interfaces.button.*;

/**
 * IsrImageSearcherViewSwing class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       2000/03/13 (by Mitsuhiro Asada)
 * 	@updated:       N/A
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrImageSearcherViewSwing.java,v 1.3 2000/04/07 04:28:50 m-asada Exp $
 */
public class IsrImageSearcherViewSwing extends StViewJPanel implements IsrImageSearcherView {
	protected StModel model;
	protected IsrButtonViewSwing menuButtonView;
	protected IsrButtonViewSwing iconAreaButtonView;
	protected IsrButtonViewSwing iconAreaSwitchView;
	protected IsrButtonViewSwing nineColorsButtonView;
	protected IsrButtonViewSwing nineColorsSwitchView;
	protected IsrButtonViewSwing typicalColorButtonView;
	protected IsrButtonViewSwing typicalColorSwitchView;
	protected IsrButtonViewSwing averageGrayButtonView;
	protected IsrButtonViewSwing averageGraySwitchView;
	protected IsrButtonViewSwing centerSpectraButtonView;
	protected IsrButtonViewSwing centerSpectraSwitchView;
	protected IsrButtonViewSwing freehandImageButtonView;
	protected IsrButtonViewSwing freehandImageSwitchView;
	protected IsrButtonViewSwing cutOffButtonView;
	protected IsrButtonViewSwing imageSearchButtonView;
	//
	protected IsrImageSearcherController controller;
	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		JPanel topPanel, leftPanel, centerPanel, downPanel;
		this.setLayout(new BorderLayout());
		this.setPreferredSize(new Dimension(170, 160));

		// top panel
		topPanel = new JPanel(new BorderLayout());
		//
		menuButtonView = new IsrButtonViewSwing() {
			protected IsrButtonController defaultController() {
				return new IsrButtonController() {
					public void mousePressed(MouseEvent e) {
						IsrButtonViewSwing view = (IsrButtonViewSwing) this.getView();
						IsrButtonModel model = this.getModel();
						if (!view.getBounds().contains(e.getPoint())) {
							return;
						}
						StBlockClosure action = model.action();
						if (action != null) {
							switch (action.numArgs()) {
								case 0 :
									action.value();
									break;
								case 1 :
									action.value_(model);
									break;
								case 2 :
									action.value_value_(model, e);
									break;
							}
						}
						e.consume();
					}
					public void mouseReleased(MouseEvent e) {
					}
					public void mouseEntered(MouseEvent e) {
					}
					public void mouseExited(MouseEvent e) {
					}
				};
			}
		};
		menuButtonView.setPreferredSize(new Dimension(180, 20));
		topPanel.add(menuButtonView);

		// left panel
		leftPanel = new JPanel(new GridLayout(6, 1));
		//
		typicalColorSwitchView = new IsrButtonViewSwing();
		typicalColorSwitchView.setPreferredSize(new Dimension(20, 20));
		leftPanel.add(typicalColorSwitchView);
		//
		averageGraySwitchView = new IsrButtonViewSwing();
		averageGraySwitchView.setPreferredSize(new Dimension(20, 20));
		leftPanel.add(averageGraySwitchView);
		//
		nineColorsSwitchView = new IsrButtonViewSwing();
		nineColorsSwitchView.setPreferredSize(new Dimension(20, 20));
		leftPanel.add(nineColorsSwitchView);
		//
		iconAreaSwitchView = new IsrButtonViewSwing();
		iconAreaSwitchView.setPreferredSize(new Dimension(20, 20));
		leftPanel.add(iconAreaSwitchView);
		//
		centerSpectraSwitchView = new IsrButtonViewSwing();
		centerSpectraSwitchView.setPreferredSize(new Dimension(20, 20));
		leftPanel.add(centerSpectraSwitchView);
		//
		freehandImageSwitchView = new IsrButtonViewSwing();
		freehandImageSwitchView.setPreferredSize(new Dimension(20, 20));
		leftPanel.add(freehandImageSwitchView);

		// center panel
		centerPanel = new JPanel(new GridLayout(6, 1));
		//
		typicalColorButtonView = new IsrButtonViewSwing();
		typicalColorButtonView.setPreferredSize(new Dimension(160, 20));
		centerPanel.add(typicalColorButtonView);
		//
		averageGrayButtonView = new IsrButtonViewSwing();
		averageGrayButtonView.setPreferredSize(new Dimension(160, 20));
		centerPanel.add(averageGrayButtonView);
		//
		nineColorsButtonView = new IsrButtonViewSwing();
		nineColorsButtonView.setPreferredSize(new Dimension(160, 20));
		centerPanel.add(nineColorsButtonView);
		//
		iconAreaButtonView = new IsrButtonViewSwing();
		iconAreaButtonView.setPreferredSize(new Dimension(160, 20));
		centerPanel.add(iconAreaButtonView);
		//
		centerSpectraButtonView = new IsrButtonViewSwing();
		centerSpectraButtonView.setPreferredSize(new Dimension(160, 20));
		centerPanel.add(centerSpectraButtonView);
		//
		freehandImageButtonView = new IsrButtonViewSwing();
		freehandImageButtonView.setPreferredSize(new Dimension(160, 20));
		centerPanel.add(freehandImageButtonView);

		// down panel
		downPanel = new JPanel(new GridLayout(1, 2));
		//
		cutOffButtonView = new IsrButtonViewSwing();
		cutOffButtonView.setPreferredSize(new Dimension(90, 20));
		downPanel.add(cutOffButtonView);
		//
		imageSearchButtonView = new IsrButtonViewSwing();
		imageSearchButtonView.setPreferredSize(new Dimension(90, 20));
		downPanel.add(imageSearchButtonView);
		this.add(topPanel, "North");
		this.add(leftPanel, "West");
		this.add(centerPanel, "Center");
		this.add(downPanel, "South");

		// controller
		controller = defaultController();
		controller.view_(this);
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return sra.smalltalk.StController
	 */
	protected IsrImageSearcherController defaultController() {
		return new IsrImageSearcherController();
	}
	/**
	 * Answer a default model.
	 *
	 * @return sra.smalltalk.StModel
	 */
	protected StModel defaultModel() {
		return new IsrImageSearcher();
	}
	/**
	 * Answer a Model.
	 *
	 * @return sra.isr.image.searcher.IsrImageSearcher
	 */
	public IsrImageSearcher getModel() {
		return (IsrImageSearcher) this.model();
	}
	/**
	 * Rebuild this component.
	 * @param oldModel sra.smalltalk.StModel
	 * @param newModel sra.smalltalk.StModel
	 */
	protected void rebuildComponent(StModel oldModel, StModel newModel) {
		IsrImageSearcher model = (IsrImageSearcher) this.model();

		// top panel
		menuButtonView.model_(model.menuButton());

		// left panel
		typicalColorSwitchView.model_(model.typicalColorSwitch());
		averageGraySwitchView.model_(model.averageGraySwitch());
		nineColorsSwitchView.model_(model.nineColorsSwitch());
		iconAreaSwitchView.model_(model.iconAreaSwitch());
		centerSpectraSwitchView.model_(model.centerSpectraSwitch());
		freehandImageSwitchView.model_(model.freehandImageSwitch());

		//center panel
		typicalColorButtonView.model_(model.typicalColorButton());
		averageGrayButtonView.model_(model.averageGrayButton());
		nineColorsButtonView.model_(model.nineColorsButton());
		iconAreaButtonView.model_(model.iconAreaButton());
		centerSpectraButtonView.model_(model.centerSpectraButton());
		freehandImageButtonView.model_(model.freehandImageButton());

		// down panel
		cutOffButtonView.model_(model.cutOffButton());
		imageSearchButtonView.model_(model.imageSearchButton());
	}
	/**
	 * model property accessing.
	 *
	 * @param aModel sra.isr.image.searcher.IsrImageSearcher
	 */
	public void setModel(IsrImageSearcher aModel) {
		this.model_(aModel);
	}
}