package sra.isr.image.searcher;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import sra.smalltalk.*;
import sra.isr.system.support.*;
import sra.isr.interfaces.button.*;

/**
 * IsrImageSearcherViewAwt class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       1999/12/21 (by Mitsuhiro Asada)
 * 	@updated:       2000/02/16 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrImageSearcherViewAwt.java,v 1.6 2000/04/07 04:24:16 m-asada Exp $
 */
public class IsrImageSearcherViewAwt extends StViewPanel implements IsrImageSearcherView {
	protected StModel model;
	protected IsrButtonViewAwt menuButtonView;
	protected IsrButtonViewAwt iconAreaButtonView;
	protected IsrButtonViewAwt iconAreaSwitchView;
	protected IsrButtonViewAwt nineColorsButtonView;
	protected IsrButtonViewAwt nineColorsSwitchView;
	protected IsrButtonViewAwt typicalColorButtonView;
	protected IsrButtonViewAwt typicalColorSwitchView;
	protected IsrButtonViewAwt averageGrayButtonView;
	protected IsrButtonViewAwt averageGraySwitchView;
	protected IsrButtonViewAwt centerSpectraButtonView;
	protected IsrButtonViewAwt centerSpectraSwitchView;
	protected IsrButtonViewAwt freehandImageButtonView;
	protected IsrButtonViewAwt freehandImageSwitchView;
	protected IsrButtonViewAwt cutOffButtonView;
	protected IsrButtonViewAwt imageSearchButtonView;
	//
	protected IsrImageSearcherController controller;
	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		Panel topPanel, leftPanel, centerPanel, downPanel;
		this.setLayout(new BorderLayout());
		this.setSize(170, 160);

		// top panel
		topPanel = new Panel(new BorderLayout());
		//
		menuButtonView = new IsrButtonViewAwt() {
			protected IsrButtonController defaultController() {
				return new IsrButtonController() {
					public void mousePressed(MouseEvent e) {
						IsrButtonViewAwt view = (IsrButtonViewAwt) this.getView();
						IsrButtonModel model = this.getModel();
						if (!view.getBounds().contains(e.getPoint())) {
							return;
						}
						StBlockClosure action = model.action();
						if (action != null) {
							switch (action.numArgs()) {
								case 0 :
									action.value();
									break;
								case 1 :
									action.value_(model);
									break;
								case 2 :
									action.value_value_(model, e);
									break;
							}
						}
						e.consume();
					}
					public void mouseReleased(MouseEvent e) {
					}
					public void mouseEntered(MouseEvent e) {
					}
					public void mouseExited(MouseEvent e) {
					}
				};
			}
		};
		menuButtonView.setSize(180, 20);
		topPanel.add(menuButtonView);

		// left panel
		leftPanel = new Panel(new GridLayout(6, 1));
		//
		typicalColorSwitchView = new IsrButtonViewAwt();
		typicalColorSwitchView.setSize(20, 20);
		leftPanel.add(typicalColorSwitchView);
		//
		averageGraySwitchView = new IsrButtonViewAwt();
		averageGraySwitchView.setSize(20, 20);
		leftPanel.add(averageGraySwitchView);
		//
		nineColorsSwitchView = new IsrButtonViewAwt();
		nineColorsSwitchView.setSize(20, 20);
		leftPanel.add(nineColorsSwitchView);
		//
		iconAreaSwitchView = new IsrButtonViewAwt();
		iconAreaSwitchView.setSize(20, 20);
		leftPanel.add(iconAreaSwitchView);
		//
		centerSpectraSwitchView = new IsrButtonViewAwt();
		centerSpectraSwitchView.setSize(20, 20);
		leftPanel.add(centerSpectraSwitchView);
		//
		freehandImageSwitchView = new IsrButtonViewAwt();
		freehandImageSwitchView.setSize(20, 20);
		leftPanel.add(freehandImageSwitchView);

		// center panel
		centerPanel = new Panel(new GridLayout(6, 1));
		//
		typicalColorButtonView = new IsrButtonViewAwt();
		typicalColorButtonView.setSize(160, 20);
		centerPanel.add(typicalColorButtonView);
		//
		averageGrayButtonView = new IsrButtonViewAwt();
		averageGrayButtonView.setSize(160, 20);
		centerPanel.add(averageGrayButtonView);
		//
		nineColorsButtonView = new IsrButtonViewAwt();
		nineColorsButtonView.setSize(160, 20);
		centerPanel.add(nineColorsButtonView);
		//
		iconAreaButtonView = new IsrButtonViewAwt();
		iconAreaButtonView.setSize(160, 20);
		centerPanel.add(iconAreaButtonView);
		//
		centerSpectraButtonView = new IsrButtonViewAwt();
		centerSpectraButtonView.setSize(160, 20);
		centerPanel.add(centerSpectraButtonView);
		//
		freehandImageButtonView = new IsrButtonViewAwt();
		freehandImageButtonView.setSize(160, 20);
		centerPanel.add(freehandImageButtonView);

		// down panel
		downPanel = new Panel(new GridLayout(1, 2));
		//
		cutOffButtonView = new IsrButtonViewAwt();
		cutOffButtonView.setSize(90, 20);
		downPanel.add(cutOffButtonView);
		//
		imageSearchButtonView = new IsrButtonViewAwt();
		imageSearchButtonView.setSize(90, 20);
		downPanel.add(imageSearchButtonView);
		this.add(topPanel, "North");
		this.add(leftPanel, "West");
		this.add(centerPanel, "Center");
		this.add(downPanel, "South");

		// controller
		controller = defaultController();
		controller.view_(this);
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return sra.smalltalk.StController
	 */
	protected IsrImageSearcherController defaultController() {
		return new IsrImageSearcherController();
	}
	/**
	 * Answer a default model.
	 *
	 * @return sra.smalltalk.StModel
	 */
	protected StModel defaultModel() {
		return new IsrImageSearcher();
	}
	/**
	 * Answer a Model.
	 *
	 * @return sra.isr.image.searcher.IsrImageSearcher
	 */
	public IsrImageSearcher getModel() {
		return (IsrImageSearcher) this.model();
	}
	/**
	 * Rebuild this component.
	 * @param oldModel sra.smalltalk.StModel
	 * @param newModel sra.smalltalk.StModel
	 */
	protected void rebuildComponent(StModel oldModel, StModel newModel) {
		IsrImageSearcher model = (IsrImageSearcher) this.model();

		// top panel
		menuButtonView.model_(model.menuButton());

		// left panel
		typicalColorSwitchView.model_(model.typicalColorSwitch());
		averageGraySwitchView.model_(model.averageGraySwitch());
		nineColorsSwitchView.model_(model.nineColorsSwitch());
		iconAreaSwitchView.model_(model.iconAreaSwitch());
		centerSpectraSwitchView.model_(model.centerSpectraSwitch());
		freehandImageSwitchView.model_(model.freehandImageSwitch());

		//center panel
		typicalColorButtonView.model_(model.typicalColorButton());
		averageGrayButtonView.model_(model.averageGrayButton());
		nineColorsButtonView.model_(model.nineColorsButton());
		iconAreaButtonView.model_(model.iconAreaButton());
		centerSpectraButtonView.model_(model.centerSpectraButton());
		freehandImageButtonView.model_(model.freehandImageButton());

		// down panel
		cutOffButtonView.model_(model.cutOffButton());
		imageSearchButtonView.model_(model.imageSearchButton());
	}
	/**
	 * model property accessing.
	 *
	 * @param aModel sra.isr.image.searcher.IsrImageSearcher
	 */
	public void setModel(IsrImageSearcher aModel) {
		this.model_(aModel);
	}
}
