package sra.isr.image.objects;

import java.awt.*;
import java.util.*;
import java.io.*;
import sra.isr.system.support.*;
import sra.smalltalk.*;

/**
 * IsrImageObjectTestExamples class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       1999/12/27 (by Mitsuhiro Asada)
 * 	@updated:       2000/03/01 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrImageObjectTestExamples.java,v 1.11 2000/04/07 04:24:16 m-asada Exp $
 */
public class IsrImageObjectTestExamples extends IsrTestExamples {
	/**
	 * 
	 */
	public static boolean Example1() {
		IsrImageObject imageObject = IsrImageObject.FileName_imageFolder_("Img0001.jpg", IsrImageFolder.DirectoryName_("temp"));
		imageObject.originalImage()._display();
		System.out.println(imageObject.centerSpectra());
		System.out.println(imageObject.averageColor().toString());
		System.out.println(imageObject.averageGray().toString());
		System.out.println(imageObject.typicalColor().toString());
		System.out.println(imageObject.typicalGray().toString());
		System.out.println(imageObject.iconArea());
		Color[] nineColors = imageObject.nineColors();
		for (int i = 0; i < nineColors.length; i++) {
			System.out.println(i + " " + nineColors[i].toString());
		}
		imageObject.iconImage()._display();
		imageObject.grayImage()._display();
		imageObject.imageCenterSpectra()._display();
		imageObject.xSpectrum()._display();
		imageObject.ySpectrum()._display();
		imageObject.imageAverageColor()._display();
		imageObject.imageAverageGray()._display();
		imageObject.imageTypicalColor()._display();
		imageObject.imageTypicalGray()._display();
		imageObject.imageNineColors()._display();
		imageObject.imageTracePolylines()._display();
		imageObject.thinImage()._display();
		imageObject.imageAttributes()._display();
		return true;
	}
	/**
	 * 
	 */
	public static boolean Example2() {
		IsrImageObject imageObject = IsrImageObject.FileName_imageFolder_("Img0001.jpg", IsrImageFolder.DirectoryName_("temp"));
		imageObject.makeCaches();
		imageObject.setImageFolder_(null);
		//
		ObjectOutputStream out = null;
		try {
			out = new ObjectOutputStream(new FileOutputStream("temp\\foo.isr"));
			out.writeObject(imageObject);
		} catch (Exception e) {
			SmalltalkException.Error("Write error");
		} finally {
			try {
				if (out != null) {
					out.flush();
					out.close();
				}
			} catch (IOException e) {
			}
		}
		return true;
	}
	/**
	 * 
	 */
	public static boolean Example3() {
		IsrImageObject imageObject = null;
		//
		ObjectInputStream in = null;
		try {
			in = new ObjectInputStream(new FileInputStream("temp\\foo.isr"));
			imageObject = (IsrImageObject) in.readObject();
		} catch (Exception e) {
			SmalltalkException.Error("Read error");
		} finally {
			try {
				if (in != null) {
					in.close();
				}
			} catch (IOException e) {
			}
		}
		imageObject.imageAttributes()._display();
		return true;
	}
	/**
	 * Execute all examples.
	 * @param args java.lang.String[]
	 */
	public static void main(java.lang.String[] args) {
		new IsrImageObjectTestExamples();
	}
}
