package sra.isr.image.objects;

import java.util.*;
import sra.smalltalk.*;
import sra.isr.system.support.*;

/**
 * IsrImageFolderTestExamples class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       1999/12/27 (by Mitsuhiro Asada)
 * 	@updated:       2000/02/24 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrImageFolderTestExamples.java,v 1.11 2000/04/07 04:24:16 m-asada Exp $
 */
public class IsrImageFolderTestExamples extends IsrTestExamples {
	/**
	 * 
	 */
	public static boolean Example1() {
		IsrImageFolder imageFolder = IsrImageFolder.FromUser();
		System.out.println(imageFolder.directoryName());
		return true;
	}
	/**
	 * 
	 */
	public static boolean Example2() {
		IsrImageFolder imageFolder = IsrImageFolder.DirectoryName_("temp");
		System.out.println(imageFolder.directoryName());
		return true;
	}
	/**
	 * 
	 */
	public static boolean Example3() {
		Vector result = IsrImageFolder.Separate_dividers_("\tFF\nff QQ\tqq\f", IsrImageFolder.Dividers());
		Enumeration enum = result.elements();
		while (enum.hasMoreElements()) {
			String string = (String) enum.nextElement();
			System.out.print(string + " ");
		}
		return true;
	}
	/**
	 * 
	 */
	public static boolean Example4() {
		System.out.println(IsrImageFolder.StringMatch_and_("Image Searcher", "Im?g*[S-T]e??che*"));
		return true;
	}
	/**
	 * Execute all examples.
	 * @param args java.lang.String[]
	 */
	public static void main(java.lang.String[] args) {
		new IsrImageFolderTestExamples();
	}
}
