package sra.isr.image.objects;

import java.awt.*;
import java.io.*;
import java.util.*;
import sra.smalltalk.*;
import sra.isr.interfaces.progress.*;

/**
 * IsrImageFolder class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       1999/12/21 (by Mitsuhiro Asada)
 * 	@updated:       2000/04/04 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrImageFolder.java,v 1.23 2000/04/07 04:24:16 m-asada Exp $
 */
public class IsrImageFolder extends StObject {
	protected String directoryName;
	protected IsrImageObject[] imageObjects;
	protected static String selection;
	/**
	 * Answer my folder filename.
	 * 
	 * @return java.io.File
	 */
	public File asFilename() {
		return new File(this.directoryName());
	}
	/**
	 * Answer my filename with aString.
	 * 
	 * @return java.io.File
	 * @param aString java.lang.String
	 */
	public File asFilenameWith_(String aString) {
		try {
			StringWriter aWriter = new StringWriter();
			aWriter.write(this.directoryName());
			aWriter.write(File.separator);
			aWriter.write(aString);
			aWriter.flush();
			return new File(aWriter.toString());
		} catch (Exception e) {
			throw new SmalltalkException(e);
		}
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * (Smalltalk version only)
	 * 
	 * @return java.lang.Object
	 * @param asserBlock sra.smalltalk.StBlockClosure
	 * @param doBlock sra.smalltalk.StBlockClosure
	 * @param ensureBlock sra.smalltalk.StBlockClosure
	 */
	private Object assert_do_ensure_(StBlockClosure asserBlock, StBlockClosure doBlock, StBlockClosure ensureBlock) {
		/* asserBlock.value();
		Object result = null;
		try {
			result = doBlock.value();
		} finally {
			ensureBlock.value();
		}
		return result; */
		return null;
	}
	/**
	 * Answer default catalog name.
	 * 
	 * @return java.lang.String
	 */
	public String defaultCatalog() {
		return "JCatalog.idx";
	}
	/**
	 * Answer my directory name.
	 * 
	 * @return java.lang.String
	 */
	public String directoryName() {
		return this.directoryName;
	}
	/**
	 * Create new instance with directory.
	 * 
	 * @return sra.isr.image.objects.IsrImageFolder
	 * @param aString java.lang.String
	 */
	public static IsrImageFolder DirectoryName_(String aString) {
		IsrImageFolder self = new IsrImageFolder();
		self.setDirectoryName_(aString);
		return self;
	}
	/**
	 * Utility methods
	 * 
	 * @return java.lang.String
	 */
	public static String Dividers() {
		char data[] = {' ', '\t', '\n', '\f'};
		String string = new String(data);
		return string;
	}
	/**
	 * Error : Can not reading catalog file.
	 */
	public void errorCanNotRead() {
		SmalltalkException.Error("can't read the catalog");
	}
	/**
	 * Error : Can not reading catalog file.
	 */
	public void errorCanNotWrite() {
		SmalltalkException.Error("can't write the catalog");
	}
	/**
	 * Clean up my image objects.
	 */
	public void flushImageObjects() {
		File catalog = new File(this.asFilename().toString(), this.defaultCatalog());
		if (catalog.exists()) {
			catalog.delete();
		}
		imageObjects = null;
	}
	/**
	 * Create new instance with user parameter.
	 * 
	 * @return sra.isr.image.object.IsrImageFolder or null;
	 */
	public static IsrImageFolder FromUser() {
		String string;
		if (selection != null) {
			string = selection;
		} else {
			string = "images";
		}
		string = StDialog.Request_("Enter directory name of JPG images, then Ok", string);
		if (string == null) {
			return null;
		}
		File filename = new File(string);
		if (!filename.exists()) {
			StDialog.Warn_(string + " does not exist.");
			return null;
		}
		if (!filename.isDirectory()) {
			StDialog.Warn_(string + " is not directory.");
			return null;
		}
		selection = string;
		IsrImageFolder imageFolder = IsrImageFolder.DirectoryName_(string);
		return imageFolder;
	}
	/**
	 * Has magic number on catalog stream.
	 *
	 * @return boolean
	 * @param aStream java.io.IntputStream
	 */
	private boolean hasMagicNumber_stream_(byte[] aByteArray, InputStream aStream) throws Exception {
		byte[] aByte = new byte[aByteArray.length];
		if (aStream.read(aByte) != -1) {
			return (new String(aByte).equals(new String(aByteArray)));
		}
		return false;
	}
	/**
	 * Answer my image objects.
	 * 
	 * @return sra.isr.image.objects.IsrImageObject[]
	 */
	public IsrImageObject[] imageObjects() {
		if (this.imageObjects == null) {
			this.updateImageObjects();
		}
		return this.imageObjects;
	}
	/**
	 * Reading catalog header on catalog stream.
	 *
	 * @return boolean
	 * @param aStream java.io.IntputStream
	 */
	public boolean readHeader_(InputStream aStream) throws Exception {
		boolean result = this.hasMagicNumber_stream_("JCatalog".getBytes(), aStream);
		if (result == true) {
			return true;
		} else {
			this.errorCanNotRead();
			return false;
		}
	}
	/**
	 * Reading image objects on catalog stream.
	 *
	 * @param aStream java.io.InputStream
	 * @return java.util.Vector
	 */
	public Vector readImageObjects_(InputStream aStream) throws Exception {
		final Vector collection = new Vector();
		try {
			final IsrImageFolder self = this;
			final InputStream stream = aStream;
			(new IsrProgress()).do_(new StBlockClosure() {
				public Object value_(Object obj) {
					IsrProgress progress = (IsrProgress) obj;
					progress.message_("reading catalog ... ");
					ObjectInputStream inStream = null;
					try {
						inStream = new ObjectInputStream(stream);
						if (self.readHeader_(inStream) != true) {
							return null;
						}
						int size = inStream.readInt();
						int count = 1;
						for (int i = 0; i < size; i++) {
							progress.value_(((float) count) / size);
							IsrImageObject imageObject = (IsrImageObject) inStream.readObject();
							collection.addElement(imageObject);
							count = count + 1;
						}
					} catch (Exception e) {
						SmalltalkException.Error("reading error:" + e);
					} finally {
						try {
							if (inStream != null) {
								inStream.close();
								inStream = null;
							}
						} catch (IOException e) {
						}
					}
					return null;
				}
			});
		} catch (Exception e) {
		}
		return collection;
	}
	/**
	 * Utility methods
	 * 
	 * @return java.util.Vector
	 * @param separateCollection java.lang.String
	 * @param dividerCollection java.lang.String
	 */
	public static Vector Separate_dividers_(String separateCollection, String dividerCollection) {
		Vector indexCollection = new Vector();
		indexCollection.addElement(new Integer(0));
		int index = 1;
		for (int i = 0; i < separateCollection.length(); i++) {
			char each = separateCollection.charAt(i);
			if (dividerCollection.indexOf(each) != -1) {
				indexCollection.addElement(new Integer(index));
			}
			index = index + 1;
		}
		indexCollection.addElement(new Integer(separateCollection.length() + 1));
		Vector intervalCollection = new Vector();
		for (int i = 0; i < indexCollection.size() - 1; i++) {
			int s = ((Integer) indexCollection.elementAt(i)).intValue();
			int e = ((Integer) indexCollection.elementAt(i + 1)).intValue();
			intervalCollection.addElement(new StInterval(s, e - 1));
		};
		Vector result = new Vector();
		for (int i = 0; i < intervalCollection.size(); i++) {
			StInterval interval = (StInterval) intervalCollection.elementAt(i);
			if (interval.size() > 0) {
				result.addElement(separateCollection.substring((int) interval.first(), (int) interval.last()));
			}
		}
		return result;
	}
	/**
	 * Set my image directory.
	 *
	 * @return sra.isr.image.objects.IsrImageFolder or null
	 * @param aString java.lang.String
	 */
	private IsrImageFolder setDirectoryName_(String aString) {
		String string = aString.toString();
		if ((string.length() > 1) && (string.charAt(string.length() - 1) == File.separatorChar)) {
			string = string.substring(0, string.length() - 1);
		}
		File filename = new File(string);
		if (!filename.isDirectory()) {
			return null;
		}
		if ((File.pathSeparator == ":") && (!filename.isAbsolute()) && (string.charAt(0) != File.separatorChar)) {
			string = File.separator + string;
		}
		this.directoryName = string;
		return this;
	}
	/**
	 * Utility methods
	 * 
	 * @return boolean
	 * @param string java.lang.String
	 * @param pattern java.lang.String
	 */
	public static boolean StringMatch_and_(String string, String pattern) {
		String s1 = string + '\000';
		String s2 = pattern + '\000';
		return StringMatch_sIndex_and_pIndex_(s1, 0, s2, 0);
	}
	/**
	 * Utility methods
	 * 
	 * @return boolean
	 * @param string java.lang.String
	 * @param sindex int
	 * @param pattern java.lang.String
	 * @param pindex int
	 */
	public static boolean StringMatch_sIndex_and_pIndex_(String string, int sindex, String pattern, int pindex) {
		boolean ok;
		int lc;
		int si = sindex;
		int pi = pindex;
		char scc = string.charAt(si);
		si = si + 1;
		char c = pattern.charAt(pi);
		pi = pi + 1;
		if (c == '[') {
			ok = false;
			lc = 255;
			c = pattern.charAt(pi);
			pi = pi + 1;
			while (c != '\000') {
				if (c == ']') {
					if (ok == true) {
						return StringMatch_sIndex_and_pIndex_(string, si, pattern, pi);
					} else {
						return false;
					}
				} else {
					if (c == '-') {
						if ((lc <= scc) && (scc <= pattern.charAt(pi))) {
							ok = true;
						}
						pi = pi + 1;
					} else {
						lc = c;
						if (scc == c) {
							ok = true;
						}
					}
				}
				c = pattern.charAt(pi);
				pi = pi + 1;
			}
		}
		if (c == '?') {
			if (scc != '\000') {
				return StringMatch_sIndex_and_pIndex_(string, si, pattern, pi);
			} else {
				return false;
			}
		}
		if (c == '*') {
			if (pattern.charAt(pi) == '\000') {
				return true;
			}
			si = si - 1;
			while (string.charAt(si) != '\000') {
				if (StringMatch_sIndex_and_pIndex_(string, si, pattern, pi) == true) {
					return true;
				}
				si = si + 1;
			}
			return false;
		}
		if (c == '\000') {
			return (scc == '\000');
		}
		if (c != scc) {
			return false;
		}
		if (scc != '\000') {
			return StringMatch_sIndex_and_pIndex_(string, si, pattern, pi);
		} else {
			return false;
		}
	}
	/**
	 * Update this image objects.
	 * 
	 * @return sra.isr.image.objects.IsrImageObject[] or null
	 */
	public IsrImageObject[] updateImageObjects() {
		this.updateImageObjectsAux();
		return this.imageObjects;
	}
	/**
	 * Update this image objects.
	 * 
	 * @return sra.isr.image.objects.IsrImageObject[] or null
	 */
	public IsrImageObject[] updateImageObjectsAux() {
		Hashtable previous = null;
		Enumeration enum = null;
		final IsrImageFolder self = this;
		String[] contents = this.asFilename().list();
		Vector files = new Vector(contents.length);
		for (int i = 0; i < contents.length; i++) {
			String each = contents[i];
			if (each.toLowerCase().endsWith(".jpg")) {
				files.addElement(each);
			}
		}
		Hashtable current = new Hashtable(files.size());
		Object[] array = new Object[files.size()];
		files.copyInto(array);
		for (int i = 0; i < array.length; i++) {
			File filename = this.asFilenameWith_((String) array[i]);
			long date = filename.lastModified();
			String fileString = (String) array[i];
			Vector vector = new Vector(2);
			vector.addElement(new Long(date));
			vector.addElement(null);
			current.put(fileString, vector);
		}
		String catalogDir = this.asFilename().toString() + File.separator;
		File catalog = new File(catalogDir, this.defaultCatalog());
		if (catalog.exists()) {
			Vector readCollection = null;
			try {
				FileInputStream inStream = null;
				try {
					inStream = new FileInputStream(catalog);
					readCollection = this.readImageObjects_(inStream);
				} catch (Exception e) {
				} finally {
					try {
						if (inStream != null) {
							inStream.close();
							inStream = null;
						}
					} catch (IOException e) {
					}
				}
				if (readCollection.size() >= 1) {
					previous = new Hashtable(readCollection.size());
					enum = readCollection.elements();
					while (enum.hasMoreElements()) {
						IsrImageObject each = (IsrImageObject) enum.nextElement();
						Vector vector = new Vector(2);
						vector.addElement(new Long(each.modifiedDate()));
						vector.addElement(each);
						previous.put(each.fileName(), vector);
					}
				} else {
					previous = new Hashtable();
				}
			} catch (Exception e) {
				previous = new Hashtable();
			}
		} else {
			previous = new Hashtable();
		}
		final Hashtable intersection = new Hashtable();
		final StValueHolder writing = new StValueHolder(new Boolean(false));
		enum = previous.keys();
		while (enum.hasMoreElements()) {
			String key = (String) enum.nextElement();
			Vector value = (Vector) previous.get(key);
			if (current.containsKey(key) && (((Vector) current.get(key)).firstElement().equals(value.firstElement()))) {
				intersection.put(key, value);
			} else {
				writing.value_(new Boolean(true));
			}
		};
		final Vector collection = new Vector(current.size());
		final StSortedCollection associations = new StSortedCollection(new StBlockClosure() {
			public Object value_value_(Object object1, Object object2) {
				String key1 = (String) ((StAssociation) object1).key();
				String key2 = (String) ((StAssociation) object2).key();
				return new Boolean(key1.compareTo(key2) <= 0);
			}
		});
		enum = current.keys();
		while (enum.hasMoreElements()) {
			String key = (String) enum.nextElement();
			Vector value = (Vector) current.get(key);
			StAssociation assoc = new StAssociation(key, value);
			associations.add_(assoc);
		}
		final int size = associations.size();
		(new IsrProgress()).do_(new StBlockClosure() {
			public Object value_(Object obj) {
				IsrProgress progress = (IsrProgress) obj;
				IsrImageObject object = null;
				int count = 1;
				progress.message_("check catalog...");
				Object[] array = associations._asArray();
				for (int j = 0; j < array.length; j++) {
					StAssociation assoc = (StAssociation) array[j];
					if (intersection.containsKey((String) assoc.key())) {
						object = (IsrImageObject) ((Vector) (intersection.get(assoc.key()))).lastElement();
						object.setImageFolder_(self);
					} else {
						object = IsrImageObject.FileName_imageFolder_((String) assoc.key(), self);
						writing.value_(new Boolean(true));
					}
					progress.message_("check catalog ... " + object.fileName());
					object.makeCaches();
					progress.value_(((float) count) / size);
					collection.addElement(object);
					count = count + 1;
				}
				return null;
			}
		});
		Object[] images = new Object[collection.size()];
		collection.copyInto(images);
		imageObjects = new IsrImageObject[images.length];
		for (int i = 0; i < imageObjects.length; i++) {
			imageObjects[i] = (IsrImageObject) images[i];
		}
		if (((Boolean) writing.value()).booleanValue() == true) {
			FileOutputStream outStream = null;
			try {
				outStream = new FileOutputStream(catalog);
				this.writeImageObjects_(outStream);
			} catch (Exception e) {
			} finally {
				try {
					if (outStream != null) {
						outStream.flush();
						outStream.close();
						outStream = null;
					}
				} catch (IOException e) {
				}
			}
		}
		return imageObjects;
	}
	/**
	 * Writing catalog header on catalog stream.
	 *
	 * @param aStream java.io.OutputStream
	 */
	public void writeHeader_(OutputStream aStream) throws Exception {
		aStream.write("JCatalog".getBytes());
	}
	/**
	 * Writing image objects on catalog stream.
	 *
	 * @param aStream java.io.OutputStream
	 */
	public void writeImageObjects_(OutputStream aStream) throws Exception {
		try {
			final IsrImageFolder self = this;
			final OutputStream stream = aStream;
			(new IsrProgress()).do_(new StBlockClosure() {
				public Object value_(Object obj) {
					IsrProgress progress = (IsrProgress) obj;
					progress.message_("writing catalog ... ");
					ObjectOutputStream outStream = null;
					try {
						outStream = new ObjectOutputStream(stream);
						self.writeHeader_(outStream);
						int size = imageObjects.length;
						outStream.writeInt(size);
						int count = 1;
						for (int i = 0; i < size; i++) {
							IsrImageObject each = self.imageObjects[i];
							progress.value_(((float) count) / size);
							IsrImageObject clone = (IsrImageObject) each.copy();
							clone.makeCaches();
							clone.setImageFolder_(null);
							outStream.writeObject(clone);
							count = count + 1;
						}
					} catch (Exception e) {
						SmalltalkException.Error("writing error:" + e);
					} finally {
						try {
							if (outStream != null) {
								outStream.flush();
								outStream.close();
								outStream = null;
							}
						} catch (Exception e) {
						}
					}
					return null;
				}
			});
		} catch (Exception e) {
		}
		return;
	}
}
