package sra.isr.image.browser;

import java.awt.*;
import java.util.*;
import sra.smalltalk.*;
import sra.isr.system.support.*;
import sra.isr.image.objects.*;
import sra.isr.image.support.*;

/**
 * IsrImageBrowserViewAwt class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       2000/01/17 (by Mitsuhiro Asada)
 * 	@updated:       2000/02/21 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrImageBrowserViewAwt.java,v 1.4 2000/04/07 04:24:16 m-asada Exp $
 */
public class IsrImageBrowserViewAwt extends StViewCanvas implements IsrImageBrowserView {
	protected IsrImageBrowserController controller;
	//
	protected PopupMenu popupMenu;
	protected Image offScreenImage;
	protected Graphics offScreenGraphics;
	protected Dimension offScreenSize;
	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		// controller
		controller = this.defaultController();
		controller.view_(this);
	}
	/**
	 * Answer images extent.
	 * 
	 * @return java.awt.Point
	 */
	public Point cellExtent() {
		int size = IsrImageObject.DefaultSize();
		return (new Point(size + 2, size + 2));
	}
	/**
	 * Answer images columns.
	 * 
	 * @return int
	 */
	public int columns() {
		int colunms = Math.max((this.displayExtent().width / this.cellExtent().x), 1);
		return colunms;
	}
	/**
	 * Answer a default controller.
	 *
	 * @return sra.isr.image.browser.IsrImageBrowserController
	 */
	protected IsrImageBrowserController defaultController() {
		return new IsrImageBrowserController();
	}
	/**
	 * Answer a default model.
	 *
	 * @return sra.smalltalk.StModel
	 */
	protected StModel defaultModel() {
		return new IsrImageBrowser();
	}
	/**
	 * Answer this display extent.
	 * 
	 * @return java.awt.Dimension
	 */
	public Dimension displayExtent() {
		ScrollPane scrollPane = (ScrollPane) this.getParent();
		return scrollPane.getViewportSize();
	}
	/**
	 * Paint image.
	 *
	 * @param anInteger int
	 * @param graphicsContext java.awt.Graphics
	 * @param aRectangle java.awt.Rectangle
	 */
	public void displayImageAt_on_clip_(int anInteger, Graphics graphicsContext, Rectangle aRectangle) {
		StImage image = (this.images()[anInteger]).iconImage();
		Rectangle box = (this.images()[anInteger]).iconArea();
		Point offset = new Point(((aRectangle.width / 2) - (image.width() / 2)), ((aRectangle.height / 2) - (image.height() / 2)));
		Point origin = new Point(aRectangle.x + offset.x, aRectangle.y + offset.y);
		MediaTracker mt = new MediaTracker(this);
		mt.addImage(image.image(), 0);
		graphicsContext.drawImage(image.image(), origin.x, origin.y, this);
		box = new Rectangle(box.x + origin.x, box.y + origin.y, box.width - 1, box.height - 1);
		graphicsContext.setColor(Color.black);
		graphicsContext.drawRect(box.x, box.y, box.width, box.height);
		if (this.indexFlag() == true) {
			origin = new Point(aRectangle.x + 1, aRectangle.y + 1);
			String text = Integer.toString(anInteger);
			FontMetrics fontMetrics = graphicsContext.getFontMetrics();
			int height = fontMetrics.getAscent();
			origin.translate(0, height);
			graphicsContext.setColor(Color.white);
			Point[] points = IsrImageProcessor.EightPoints();
			for (int i = 0; i < points.length; i++) {
				graphicsContext.drawString(text, origin.x + points[i].x, origin.y + points[i].y);
			}
			graphicsContext.setColor(Color.black);
			graphicsContext.drawString(text, origin.x, origin.y);
		}
	}
	/**
	 * Paint this images.
	 *
	 * @param aGraphics java.awt.Graphics
	 */
	public void displayOn_(Graphics aGraphics) {
		Dimension size = this.getSize();
		if (!size.equals(offScreenSize)) {
			offScreenImage = this.createImage(size.width, size.height);
			offScreenGraphics = offScreenImage.getGraphics();
			final IsrImageBrowserViewAwt self = this;
			this.loop_(new StBlockClosure() {
				public Object value_value_(Object obj1, Object obj2) {
					Rectangle box = (Rectangle) obj1;
					int index = ((Integer) obj2).intValue();
					self.displayOn_imageAt_clippingBox_(self.offScreenGraphics, index, box);
					return null;
				}
			});
			offScreenSize = size;
		}
		aGraphics.drawImage(offScreenImage, 0, 0, this);
	}
	/**
	 * Paint image border.
	 *
	 * @param graphicsContext java.awt.Graphics
	 * @param index int
	 * @param box java.awt.Rectangle
	 */
	public void displayOn_imageAt_clippingBox_(Graphics graphicsContext, int index, Rectangle box) {
		if (this.selectedIndexes().contains(new Integer(index))) {
			graphicsContext.setColor(Color.red);
			graphicsContext.fillRect(box.x, box.y, box.width, box.height);
		} else {
			graphicsContext.setColor(StColorValue.VeryLightGray);
			graphicsContext.fillRect(box.x, box.y, box.width, box.height);
		}
		if (index < this.imagesSize()) {
			this.displayImageAt_on_clip_(index, graphicsContext, box);
		}
	}
	/**
	 * Clean up this object
	 */
	protected void finalize() throws Throwable {
		if (offScreenGraphics != null) {
			offScreenGraphics.dispose();
			offScreenGraphics = null;
		}
		if (offScreenImage != null) {
			offScreenImage.flush();
			offScreenImage = null;
		}
	}
	/**
	 * Answer a Model.
	 *
	 * @return sra.isr.interfaces.area.IsrImageBrowser
	 */
	public IsrImageBrowser getModel() {
		return (IsrImageBrowser) this.model();
	}
	/**
	 * Answer model images.
	 * 
	 * @return sra.isr.image.objects.IsrImageObject[]
	 */
	public IsrImageObject[] images() {
		return this.getModel().imageObjects();
	}
	/**
	 * Answer images size.
	 * (Smalltalk version methods 'size')
	 * 
	 * @return int
	 */
	public int imagesSize() {
		return this.images().length;
	}
	/**
	 * Answer model index flag.
	 * 
	 * @return boolean
	 */
	public boolean indexFlag() {
		return this.getModel().indexFlag();
	}
	/**
	 * Answer images columns.
	 * 
	 * @param aBlock sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 */
	private Object loop_(StBlockClosure aBlock) {
		Rectangle cell = new Rectangle(0, 0, this.cellExtent().x, this.cellExtent().y);
		int index = 0;
		for (int row = 0; row < this.rows(); row++) {
			for (int column = 0; column < this.columns(); column++) {
				Object result = aBlock.value_value_(cell, new Integer(index));
				if (result != null) {
					return result;
				}
				cell.translate(cell.width, 0);
				index = index + 1;
			}
			cell.translate(0 - (cell.width * this.columns()), cell.height);
		}
		return null;
	}
	/**
	 * Get Panel preferred size.
	 * 
	 * @return java.awt.Dimension
	 */
	public Dimension preferredSize() {
		return new Dimension(this.columns() * this.cellExtent().x, this.rows() * this.cellExtent().y);
	}
	/**
	 * Rebuild this component.
	 * @param oldModel sra.smalltalk.StModel
	 * @param newModel sra.smalltalk.StModel
	 */
	protected void rebuildComponent(StModel oldModel, StModel newModel) {
		if (popupMenu != null) {
			this.remove(popupMenu);
		}
		StMenuModel menuModel = ((IsrImageBrowser) newModel).defaultMenu();
		if (menuModel != null) {
			StMenu editMenu = (StMenu) menuModel.getItem("ImageBrowserMenu");
			popupMenu = StMenuViewForAwt.CreatePopupMenu(editMenu);
			this.add(popupMenu);
		}
	}
	/**
	 * Answer images rows.
	 * 
	 * @return int
	 */
	public int rows() {
		int columns = this.columns();
		int rows = this.imagesSize() / columns;
		if ((this.imagesSize() % columns) != 0) {
			rows = rows + 1;
		}
		return rows;
	}
	/**
	 * Answer model selected indexes.
	 *
	 * @return java.util.Vector
	 */
	public Vector selectedIndexes() {
		return this.getModel().selectedIndexes();
	}
	/**
	 * model property accessing.
	 *
	 * @param aModel sra.isr.interfaces.area.IsrImageBrowser
	 */
	public void setModel(IsrImageBrowser aModel) {
		this.model_(aModel);
	}
	/**
	 * Open the menu at the specified point.
	 *
	 * @param aPoint Point
	 */
	public void showPopupMenu(Point aPoint) {
		if (popupMenu != null) {
			IsrImageBrowser browser = this.getModel();
			if (browser.selectedIndexes().size() == 0) {
				popupMenu.getItem(2).setEnabled(false);
				popupMenu.getItem(3).setEnabled(false);
			} else {
				popupMenu.getItem(2).setEnabled(true);
				popupMenu.getItem(3).setEnabled(true);
			}
			popupMenu.show(this, aPoint.x, aPoint.y);
		}
	}
	/**
	 * Update the receiver according to the change notification from the model.
	 *
	 * @param evt sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		if (!this.isShowing())
			return;
		if (evt.getAspect() == $("selectedIndexes")) {
			final Vector indexCollection = (Vector) evt.getParameter();
			final IsrImageBrowserViewAwt self = this;
			offScreenGraphics.clipRect(0, 0, this.getBounds().width, this.getBounds().height);
			this.loop_(new StBlockClosure() {
				public Object value_value_(Object obj1, Object obj2) {
					Rectangle box = (Rectangle) obj1;
					Integer index = (Integer) obj2;
					if (indexCollection.contains(index)) {
						self.displayOn_imageAt_clippingBox_(self.offScreenGraphics, index.intValue(), box);
					}
					return null;
				}
			});
			this.getGraphics().drawImage(offScreenImage, 0, 0, this);
			return;
		}
		if (evt.getAspect() == $("imageObjects")) {
			((ScrollPane) this.getParent()).setScrollPosition(0, 0);
			offScreenSize = null;
			this.repaint();
			return;
		}
		offScreenSize = null;
		this.repaint();
	}
	/**
	 * Answer image object on aPoint.
	 *
	 * @return sra.isr.image.objects.IsrImageObject
	 * @param aPoint java.awt.Point
	 */
	public IsrImageObject whichImage_(Point aPoint) {
		int index = this.whichIndex_(aPoint);
		if (index == -1) {
			return null;
		}
		return this.images()[index];
	}
	/**
	 * Answer image index number on aPoint.
	 *
	 * @return int
	 * @param aPoint java.awt.Point
	 */
	public int whichIndex_(Point aPoint) {
		final IsrImageBrowserViewAwt self = this;
		final Point point = aPoint;
		Object result = this.loop_(new StBlockClosure() {
			public Object value_value_(Object obj1, Object obj2) {
				Rectangle box = (Rectangle) obj1;
				int index = ((Integer) obj2).intValue();
				if (box.contains(point)) {
					if (index < self.imagesSize()) {
						return new StValueHolder(index);
					} else {
						return new StValueHolder(-1);
					}
				}
				return null;
			}
		});
		if (result != null) {
			return ((StValueHolder) result)._intValue();
		}
		return -1;
	}
}
