package sra.isr.image.browser;

import java.awt.*;
import java.awt.event.*;
import sra.smalltalk.*;

/**
 * IsrImageBrowserView class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       2000/02/21 (by Mitsuhiro Asada)
 * 	@updated:       2000/03/13 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrImageBrowserView.java,v 1.13 2000/04/07 04:24:15 m-asada Exp $
 */
public interface IsrImageBrowserView extends StView {
	/**
	 * Paint image.
	 *
	 * @param anInteger int
	 * @param graphicsContext java.awt.Graphics
	 * @param aRectangle java.awt.Rectangle
	 */
	public void displayImageAt_on_clip_(int anInteger, Graphics graphicsContext, Rectangle aRectangle);
	/**
	 * Paint image border.
	 *
	 * @param graphicsContext java.awt.Graphics
	 * @param index int
	 * @param box java.awt.Rectangle
	 */
	public void displayOn_imageAt_clippingBox_(Graphics graphicsContext, int index, Rectangle box);
	/**
	 * Answer a Model.
	 *
	 * @return sra.isr.interfaces.area.IsrImageBrowser
	 */
	public IsrImageBrowser getModel();
	/**
	 * model property accessing.
	 *
	 * @param aModel sra.isr.interfaces.area.IsrImageBrowser
	 */
	public void setModel(IsrImageBrowser aModel);
	/**
	 * Open the menu at the specified point.
	 *
	 * @param aPoint Point
	 */
	public void showPopupMenu(Point aPoint);
	/**
	 * Answer image index number on aPoint.
	 *
	 * @return int
	 * @param aPoint java.awt.Point
	 */
	public int whichIndex_(Point aPoint);
}
