package sra.isr.image.browser;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import sra.smalltalk.*;
import sra.isr.system.support.*;

/**
 * IsrImageBrowserController class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       2000/01/17 (by Mitsuhiro Asada)
 * 	@updated:       2000/02/21 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrImageBrowserController.java,v 1.11 2000/04/07 04:24:15 m-asada Exp $
 */
public class IsrImageBrowserController extends StController implements MouseListener {
	/**
	 * add listeners.
	 * @param aView sra.mvctest.StView
	 */
	protected void buildListener(StView newView) {
		Component aView = (Component) newView;
		aView.addMouseListener(this);
	}
	/**
	 * Answer a model.
	 *
	 * @return sra.isr.image.browser.IsrImageBrowser
	 */
	protected final IsrImageBrowser getModel() {
		return (IsrImageBrowser) this.model();
	}
	/**
	 * Answer this view.
	 *
	 * @return sra.isr.image.browser.IsrImageBrowserView interface
	 */
	protected IsrImageBrowserView getView() {
		return (IsrImageBrowserView) this.view();
	}
	/**
	 * Invoked when the mouse has been clicked on a component.
	 *
	 * @param event java.awt.event.MouseEvent
	 */
	public void mouseClicked(MouseEvent event) {
		if (this.isMenuButtonPressed_(event)) {
			return;
		}
		if (event.getClickCount() == 1) {
			this.selectActivity_(event);
		} else
			if (event.getClickCount() == 2) {
				this.mouseDoubleClicked(event);
			}
	}
	/**
	 * Invoked when a mouse button has been pressed. 
	 *
	 * @param event java.awt.event.MouseEvent
	 */
	public void mouseDoubleClicked(MouseEvent event) {
		if (event.isControlDown()) {
			if (event.isShiftDown()) {
				this.getModel().showNewImageAttributes();
			} else {
				this.getModel().showImageAttributes();
			}
		} else {
			if (event.isShiftDown()) {
				this.getModel().showNewOriginalImages();
			} else {
				this.getModel().showOriginalImages();
			}
		}
	}
	/**
	 * Invoked when a mouse button has been pressed. 
	 *
	 * @param event java.awt.event.MouseEvent
	 */
	public void mousePressed(MouseEvent event) {
		// popup menu
		if (event.isMetaDown()) {
			IsrImageBrowserView view = this.getView();
			view.showPopupMenu(event.getPoint());
		}
	}
	/**
	 * Select imageObject. 
	 *
	 * @param event java.awt.event.MouseEvent
	 */
	public void selectActivity_(MouseEvent event) {
		if (this.isMenuButtonPressed_(event)) {
			return;
		}
		IsrImageBrowserView view = this.getView();
		Point point = event.getPoint();
		int index = view.whichIndex_(point);
		if (index == -1) {
			return;
		}
		IsrImageBrowser browser = this.getModel();
		Vector oldSelection = (Vector) browser.selectedIndexes().clone();
		boolean bool = event.isShiftDown();
		if (bool) {
			if (browser.selectedIndexes().contains(new Integer(index))) {
				browser.removeSelectedIndex_(index);
			} else {
				browser.addSelectedIndex_(index);
			}
		} else {
			if (!browser.selectedIndexes().contains(new Integer(index))) {
				browser.clearSelectedIndexes();
				browser.addSelectedIndex_(index);
			}
		}
		Vector newSelection = browser.selectedIndexes();
		Vector xor = browser.xorIndexes_with_(newSelection, oldSelection);
		browser.changed_with_($("selectedIndexes"), xor);
	}
}
