package sra.isr.image.browser;

import java.awt.*;
import java.util.*;
import javax.swing.*;
import sra.smalltalk.*;
import sra.isr.system.support.*;

/**
 * IsrImageBrowserApplicationViewSwing class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       2000/03/13 (by Mitsuhiro Asada)
 * 	@updated:       N/A
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrImageBrowserApplicationViewSwing.java,v 1.2 2000/04/07 04:28:50 m-asada Exp $
 */
public class IsrImageBrowserApplicationViewSwing extends StViewJPanel implements IsrImageBrowserApplicationView {
	protected IsrImageBrowserViewSwing imageBrowserView;
	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		this.setLayout(new BorderLayout());
		//
		imageBrowserView = new IsrImageBrowserViewSwing();
		imageBrowserView.model_(this.getModel());
		//scrollPane
		JScrollPane scrollPane = new JScrollPane(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		scrollPane.setPreferredSize(new Dimension(335, 230));
		scrollPane.setViewportView(imageBrowserView);
		//
		this.add(scrollPane, "Center");
	}
	/**
	 * Answer a default model.
	 *
	 * @return sra.smalltalk.StModel
	 */
	protected StModel defaultModel() {
		return new IsrImageBrowser();
	}
	/**
	 * Answer a Model.
	 *
	 * @return sra.isr.interfaces.area.IsrImageBrowser
	 */
	public IsrImageBrowser getModel() {
		return (IsrImageBrowser) this.model();
	}
	/**
	 * Rebuild this component.
	 *
	 * @param oldModel sra.smalltalk.StModel
	 * @param newModel sra.smalltalk.StModel
	 */
	protected void rebuildComponent(StModel oldModel, StModel newModel) {
		IsrImageBrowser model = (IsrImageBrowser) this.model();
		imageBrowserView.model_(model);
	}
	/**
	 * model property accessing.
	 *
	 * @param aModel sra.isr.interfaces.area.IsrImageBrowser
	 */
	public void setModel(IsrImageBrowser aModel) {
		this.model_(aModel);
	}
}
