package sra.isr.image.browser;

import java.awt.*;
import java.util.*;
import sra.smalltalk.*;
import sra.isr.system.support.*;

/**
 * IsrImageBrowserApplicationViewAwt class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       2000/01/17 (by Mitsuhiro Asada)
 * 	@updated:       2000/02/21 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrImageBrowserApplicationViewAwt.java,v 1.2 2000/04/07 04:24:15 m-asada Exp $
 */
public class IsrImageBrowserApplicationViewAwt extends StViewPanel implements IsrImageBrowserApplicationView {
	protected IsrImageBrowserViewAwt imageBrowserView;
	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		this.setLayout(new BorderLayout());
		//scrollPane
		ScrollPane scrollPane = new ScrollPane(ScrollPane.SCROLLBARS_AS_NEEDED);
		scrollPane.setSize(335, 230);
		//
		imageBrowserView = new IsrImageBrowserViewAwt();
		imageBrowserView.model_(this.getModel());
		scrollPane.add(imageBrowserView);
		//
		this.add(scrollPane, "Center");
	}
	/**
	 * Answer a default model.
	 *
	 * @return sra.smalltalk.StModel
	 */
	protected StModel defaultModel() {
		return new IsrImageBrowser();
	}
	/**
	 * Answer a Model.
	 *
	 * @return sra.isr.interfaces.area.IsrImageBrowser
	 */
	public IsrImageBrowser getModel() {
		return (IsrImageBrowser) this.model();
	}
	/**
	 * Rebuild this component.
	 *
	 * @param oldModel sra.smalltalk.StModel
	 * @param newModel sra.smalltalk.StModel
	 */
	protected void rebuildComponent(StModel oldModel, StModel newModel) {
		IsrImageBrowser model = (IsrImageBrowser) this.model();
		imageBrowserView.model_(model);
	}
	/**
	 * model property accessing.
	 *
	 * @param aModel sra.isr.interfaces.area.IsrImageBrowser
	 */
	public void setModel(IsrImageBrowser aModel) {
		this.model_(aModel);
	}
}