package sra.isr.image.browser;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import sra.smalltalk.*;
import sra.isr.system.support.*;
import sra.isr.image.objects.*;
import sra.isr.interfaces.display.*;

/**
 * IsrImageBrowser class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       2000/01/17 (by Mitsuhiro Asada)
 * 	@updated:       2000/02/21 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrImageBrowser.java,v 1.17 2000/04/07 04:24:15 m-asada Exp $
 */
public class IsrImageBrowser extends StApplicationModel {
	protected IsrImageObject[] imageObjects;
	protected Vector selectedIndexes;
	protected boolean indexFlag;
	protected boolean slaveFlag;
	protected IsrDisplayModel displayModelForOriginal;
	protected IsrDisplayModel displayModelForAttributes;
	/**
	 * Add selected index.
	 * 
	 * @param anInteger int
	 */
	public void addSelectedIndex_(int anInteger) {
		Integer number = new Integer(anInteger);
		if (!this.selectedIndexes().contains(number)) {
			this.selectedIndexes.addElement(number);
		}
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * (Smalltalk version only)
	 * 
	 * @return java.lang.Object
	 * @param asserBlock sra.smalltalk.StBlockClosure
	 * @param doBlock sra.smalltalk.StBlockClosure
	 * @param ensureBlock sra.smalltalk.StBlockClosure
	 */
	private Object assert_do_ensure_(StBlockClosure asserBlock, StBlockClosure doBlock, StBlockClosure ensureBlock) {
		/* asserBlock.value();
		Object result = null;
		try {
			result = doBlock.value();
		} finally {
			ensureBlock.value();
		}
		return result; */
		return null;
	}
	/**
	 * Clean up indexes.
	 * 
	 * @return java.uitl.Vector
	 */
	public Vector clearSelectedIndexes() {
		selectedIndexes = new Vector();
		return selectedIndexes;
	}
	/**
	 * Create a default popup menu of the Isr9ColorsModel.
	 *
	 * @return sra.smalltalk.StMenuModel
	 */
	protected StMenuModel defaultMenu() {
		StMenuModel rootMenu = new StMenuModel();
		//
		StMenu editMenu = new StMenu("ImageBrowserMenu");
		editMenu.add(this.createMenuItem("open", "openImageBrowser"));
		editMenu.addSeparator();
		editMenu.add(this.createMenuItem("original", "showOriginalImages"));
		editMenu.add(this.createMenuItem("attributes", "showImageAttributes"));
		editMenu.addSeparator();
		editMenu.add(this.createMenuItem("select all", "selectAll"));
		editMenu.add(this.createMenuItem("select indexes", "selectIndexes"));
		editMenu.add(this.createMenuItem("index on/off", "indexOnOff"));
		//editMenu.addSeparator();
		//editMenu.add(this.createMenuItem("save selections", "saveSelections"));
		//editMenu.add(this.createMenuItem("html selections", "htmlSelections"));
		rootMenu.add(editMenu);
		//
		return rootMenu;
	}
	/**
	 * Answer a default view.
	 * 
	 * @return sra.smalltalk.StView
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new IsrImageBrowserApplicationViewAwt();
		} else {
			return this.CreateView("sra.isr.image.browser.IsrImageBrowserApplicationViewSwing");
		}
	}
	/**
	 * Construsctor with directory name.
	 * 
	 * @return sra.isr.image.browser.IsrImageBrowser
	 * @param aString java.lang.String
	 */
	public static IsrImageBrowser DirectoryName_(String aString) {
		return ImageFolder_(IsrImageFolder.DirectoryName_(aString));
	}
	/**
	 * Answer my displayModelForAttributes.
	 * 
	 * @return sra.jun.goodies.display.JunDisplayModel
	 */
	public IsrDisplayModel displayModelForAttributes() {
		if (displayModelForAttributes == null) {
			displayModelForAttributes = IsrDisplayModel.Visual_("");
		}
		return displayModelForAttributes;
	}
	/**
	 * Answer my displayModelForOriginal.
	 * 
	 * @return sra.jun.goodies.display.JunDisplayModel
	 */
	public IsrDisplayModel displayModelForOriginal() {
		if (displayModelForOriginal == null) {
			displayModelForOriginal = IsrDisplayModel.Visual_("");
		}
		return displayModelForOriginal;
	}
	/**
	 * Create new instance with user parameter.
	 * 
	 * @return sra.isr.image.browser.IsrImageBrowser or null
	 */
	public static IsrImageBrowser FromUser() {
		IsrImageFolder imageFolder = IsrImageFolder.FromUser();
		if (imageFolder == null) {
			return null;
		}
		IsrImageBrowser imageBrowser = ImageFolder_(imageFolder);
		return imageBrowser;
	}
	/**
	 * Construsctor with imageFolder
	 * 
	 * @return sra.isr.image.browser.IsrImageBrowser
	 * @param imageFolder sra.isr.image.objects.IsrImageFolder
	 */
	public static IsrImageBrowser ImageFolder_(IsrImageFolder imageFolder) {
		return ImageObjects_(imageFolder.imageObjects());
	}
	/**
	 * Answer my imageObjects.
	 * 
	 * @return sra.isr.image.objects.IsrImageObject[]
	 */
	public IsrImageObject[] imageObjects() {
		return imageObjects;
	}
	/**
	 * Construsctor with imageObjects
	 * 
	 * @return sra.isr.image.browser.IsrImageBrowser
	 * @param collectionOfImageObjects sra.isr.image.objects.IsrImageObject[]
	 */
	public static IsrImageBrowser ImageObjects_(IsrImageObject[] collectionOfImageObjects) {
		IsrImageBrowser model = new IsrImageBrowser();
		model.imageObjects_(collectionOfImageObjects);
		return model;
	}
	/**
	 * Set my imageObjects.
	 * 
	 * @param collectionOfImageObjects sra.isr.image.objects.IsrImageObject[]
	 */
	public void imageObjects_(IsrImageObject[] collectionOfImageObjects) {
		if (imageObjects != collectionOfImageObjects) {
			this.setImageObjects_(collectionOfImageObjects);
			this.clearSelectedIndexes();
			this.changed_($("imageObjects"));
		}
	}
	/**
	 * Answer my index flag.
	 * 
	 * @return boolean
	 */
	public boolean indexFlag() {
		return (indexFlag == true);
	}
	/**
	 * Set my index flag.
	 * 
	 * @return boolean
	 */
	public void indexFlag_(boolean aBoolean) {
		indexFlag = (aBoolean == true);
	}
	/**
	 * image index on/off.
	 */
	public void indexOnOff() {
		this.indexFlag_(!this.indexFlag());
		this.changed();
	}
	/**
	 * Open new image browser.
	 */
	public void openImageBrowser() {
		IsrImageBrowser imageBrowser = this.FromUser();
		if (imageBrowser == null) {
			return;
		}
		imageBrowser.open();
	}
	/**
	 * Remove selected index from selectedIndexes.
	 * 
	 * @param anInteger int
	 */
	public void removeSelectedIndex_(int anInteger) {
		Integer number = new Integer(anInteger);
		if (this.selectedIndexes().contains(number)) {
			this.selectedIndexes.removeElement(number);
		}
	}
	/**
	 * Select all images.
	 */
	public void selectAll() {
		Vector oldIndexes = (Vector) this.selectedIndexes.clone();
		this.selectedIndexes_(new Vector());
		for (int index = 0; index < this.imageObjects().length; index++) {
			this.selectedIndexes().addElement(new Integer(index));
		}
		Vector newIndexes = this.selectedIndexes();
		Vector xor = this.xorIndexes_with_(newIndexes, oldIndexes);
		this.changed_with_($("selectedIndexes"), xor);
	}
	/**
	 * Answer my selected imageObjects.
	 * 
	 * @return sra.isr.image.objects.IsrImageObject[]
	 */
	public IsrImageObject[] selectedImages() {
		Vector selectedImages = new Vector();
		if (this.selectedIndexes().size() == 0) {
			return new IsrImageObject[0];
		}
		StBlockClosure sortBlock = new StBlockClosure() {
			public Object value_value_(Object obj1, Object obj2) {
				return new Boolean(((Integer) obj1).intValue() <= ((Integer) obj2).intValue());
			}
		};
		StSortedCollection sortedCollection = new StSortedCollection(sortBlock, this.selectedIndexes());
		Object[] collection = sortedCollection._asArray();
		for (int i = 0; i < collection.length; i++) {
			selectedImages.addElement(this.imageObjects()[ ((Integer) collection[i]).intValue()]);
		}
		IsrImageObject[] results = new IsrImageObject[selectedImages.size()];
		selectedImages.copyInto((Object[]) results);
		return results;
	}
	/**
	 * Answer seleted indexes.
	 * 
	 * @return java.util.Vector
	 */
	public Vector selectedIndexes() {
		if (selectedIndexes == null) {
			this.clearSelectedIndexes();
		}
		return selectedIndexes;
	}
	/**
	 * Set seleted indexes.
	 * 
	 * @return java.util.Vector
	 */
	public void selectedIndexes_(Vector indexes) {
		selectedIndexes = indexes;
	}
	/**
	 * Select all images.
	 */
	public void selectIndexes() {
		String string = StDialog.Request_("Enter indexes, then accept. Wild cards (*?[-]) are allowrd", "");
		if (string == null || string.length() == 0) {
			return;
		}
		Vector tokens = IsrImageFolder.Separate_dividers_(string, IsrImageFolder.Dividers());
		Vector oldIndexes = (Vector) this.selectedIndexes.clone();
		Vector indexes = new Vector();
		for (int index = 0; index < this.imageObjects().length; index++) {
			Enumeration enum = tokens.elements();
			while (enum.hasMoreElements()) {
				String token = (String) enum.nextElement();
				if (IsrImageFolder.StringMatch_and_(String.valueOf(index), token)) {
					indexes.addElement(new Integer(index));
				}
			}
		}
		this.selectedIndexes_(indexes);
		Vector newIndexes = this.selectedIndexes();
		Vector xor = this.xorIndexes_with_(newIndexes, oldIndexes);
		this.changed_with_($("selectedIndexes"), xor);
	}
	/**
	 * Set my imageObjects.
	 * 
	 * @param collectionOfImageObjects sra.isr.image.objects.IsrImageObject[]
	 */
	private void setImageObjects_(IsrImageObject[] collectionOfImageObjects) {
		imageObjects = collectionOfImageObjects;
	}
	/**
	 * Open selected imageObjects's attributes image.
	 */
	public void showImageAttributes() {
		Frame window = null;
		IsrImageObject[] images = this.selectedImages();
		if (images.length == 0) {
			return;
		}
		IsrImageObject first = images[0];
		IsrDisplayModel model = this.displayModelForAttributes();
		String label = first.fileName().toString();
		Frame[] frames = model.builder().frames();
		for (int i = 0; i < frames.length; i++) {
			model.visual_(first.imageAttributes().image());
			window = frames[i];
			window.setTitle(label);
			if (window.isShowing()) {
				window.toFront();
			} else {
				window.show();
			}
		}
		if (frames.length == 0) {
			model.visual_(first.imageAttributes().image());
			window = model.open();
			window.setTitle(label);
		}
		if (images.length > 1) {
			for (int i = 1; i < images.length; i++) {
				IsrImageObject each = images[i];
				label = each.fileName().toString();
				model.visual_(each.imageAttributes().image());
				window.setTitle(label);
			}
		}
	}
	/**
	 * Open selected imageObjects's attributes image.
	 */
	public void showNewImageAttributes() {
		IsrImageObject[] images = this.selectedImages();
		if (images.length == 0) {
			return;
		}
		for (int i = 0; i < images.length; i++) {
			IsrImageObject each = images[i];
			String label = each.fileName().toString();
			IsrDisplayModel.OpenVisual_label_(each.imageAttributes().image(), label);
		}
	}
	/**
	 * Open selected imageObjects's original image.
	 */
	public void showNewOriginalImages() {
		IsrImageObject[] images = this.selectedImages();
		if (images.length == 0) {
			return;
		}
		for (int i = 0; i < images.length; i++) {
			IsrImageObject each = images[i];
			String label = each.fileName().toString();
			IsrDisplayModel.OpenVisual_label_(each.originalImage().image(), label);
		}
	}
	/**
	 * Open selected imageObjects's original image.
	 */
	public void showOriginalImages() {
		Frame window = null;
		IsrImageObject[] images = this.selectedImages();
		if (images.length == 0) {
			return;
		}
		IsrImageObject first = images[0];
		IsrDisplayModel model = this.displayModelForOriginal();
		String label = first.fileName().toString();
		Frame[] frames = model.builder().frames();
		for (int i = 0; i < frames.length; i++) {
			model.visual_(first.originalImage().image());
			window = frames[i];
			window.setTitle(label);
			if (window.isShowing()) {
				window.toFront();
			} else {
				window.show();
			}
		}
		if (frames.length == 0) {
			model.visual_(first.originalImage().image());
			window = model.open();
			window.setTitle(label);
		}
		if (images.length > 1) {
			for (int i = 1; i < images.length; i++) {
				IsrImageObject each = images[i];
				label = each.fileName().toString();
				model.visual_(each.originalImage().image());
				window.setTitle(label);
			}
		}
	}
	/**
	 * Answer my slave flag.
	 * 
	 * @return boolean
	 */
	public boolean slaveFlag() {
		return (slaveFlag == true);
	}
	/**
	 * Set my slave flag.
	 * 
	 * @return boolean
	 */
	public void slaveFlag_(boolean aBoolean) {
		slaveFlag = (aBoolean == true);
	}
	/**
	 * Invoked when a window is in the process of being closed.
	 * The close operation can be overridden at this point.
	 */
	public void windowClosing(java.awt.event.WindowEvent e) {
		if (this.slaveFlag()) {
			StApplicationModel[] models = new StApplicationModel[2];
			models[0] = this.displayModelForOriginal();
			models[1] = this.displayModelForAttributes();
			for (int i = 0; i < models.length; i++) {
				StApplicationModel model = models[i];
				Frame[] frames = model.builder().frames();
				for (int j = 0; j < frames.length; j++) {
					frames[j].setVisible(false);
				}
			}
			super.windowClosing(e);
		} else {
			Window aWindow = e.getWindow();
			Point location = aWindow.getLocationOnScreen();
			Dimension size = aWindow.getSize();
			location = new Point(location.x + size.width, location.y);
			if (StDialog.Confirm_("Really close?", false, location) == true) {
				StApplicationModel[] models = new StApplicationModel[2];
				models[0] = this.displayModelForOriginal();
				models[1] = this.displayModelForAttributes();
				for (int i = 0; i < models.length; i++) {
					StApplicationModel model = models[i];
					Frame[] frames = model.builder().frames();
					for (int j = 0; j < frames.length; j++) {
						frames[j].setVisible(false);
					}
				}
				super.windowClosing(e);
			}
		}
	}
	/**
	 * Answer a window title.
	 * @return java.lang.String
	 */
	protected String windowTitle() {
		return "Image Browser";
	}
	/**
	 * Set seleted indexes.
	 * 
	 * @return java.util.Vector
	 * @param newCollection java.util.Vector
	 * @param oldCollection java.util.Vector
	 */
	public Vector xorIndexes_with_(Vector newCollection, Vector oldCollection) {
		Integer each;
		Vector intersect = new Vector();
		Enumeration enum = oldCollection.elements();
		while (enum.hasMoreElements()) {
			each = (Integer) enum.nextElement();
			if (newCollection.contains(each)) {
				intersect.addElement(each);
			}
		}
		enum = newCollection.elements();
		while (enum.hasMoreElements()) {
			each = (Integer) enum.nextElement();
			oldCollection.addElement(each);
		}
		Vector xor = new Vector();
		enum = oldCollection.elements();
		while (enum.hasMoreElements()) {
			each = (Integer) enum.nextElement();
			if (!intersect.contains(each)) {
				xor.addElement(each);
			}
		}
		return xor;
	}
}
