package sra.isr.image.objects;

import sra.smalltalk.*;

/**
 * IsrImageAuxiliary class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       2000/01/21 (by Mitsuhiro Asada)
 * 	@updated:       2000/02/16 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrImageAuxiliary.java,v 1.4 2000/04/07 04:24:16 m-asada Exp $
 */
public class IsrImageAuxiliary extends IsrImageObject {
	protected StImage originalImage;
	/**
	 * Answer my original image.
	 * 
	 * @return sra.smalltalk.StImage
	 */
	public StImage originalImage() {
		return originalImage;
	}
	/**
	 * Create new instance with origina image.
	 * 
	 * @return sra.isr.image.objects.IsrImageAuxiliary
	 * @param anImage sra.smalltalk.StImage
	 */
	public static IsrImageAuxiliary OriginalImage_(StImage anImage) {
		IsrImageAuxiliary self = new IsrImageAuxiliary();
		self.originalImage_(anImage);
		return self;
	}
	/**
	 * Set original image.
	 * 
	 * @param anImage sra.smalltalk.StImage
	 */
	public void originalImage_(StImage anImage) {
		originalImage = anImage;
	}
}
