package sra.isr.geometry.abstracts;

import sra.smalltalk.*;
import sra.isr.geometry.basic.*;

/**
 * IsrGeometry class
 * 
 * 	@author:        nisinaka
 * 	@created:       1998/09/29 (by nisinaka)
 * 	@updated:       2000/02/16 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrGeometry.java,v 1.3 2000/04/07 04:24:15 m-asada Exp $
 */
abstract public class IsrGeometry extends StObject {
	public final static double ACCURACY = 1.0e-12d;
	/**
	 * Answer the accuracy of geometries.
	 *
	 * @return double
	 */
	public final static double Accuracy() {
		return ACCURACY;
	}
	/**
	 * Convert to a glocal geometry.
	 *
	 * @return sra.jun.geometry.abstracts.JunGeometry
	 */
	public IsrGeometry asGlobalGeometry() {
		return this;
	}
	/**
	 * Answer the distance from specified Point.
	 *
	 * @return double
	 * @param aPoint sra.jun.geometry.basic.Jun2dPoint
	 */
	public double distanceFromPoint_(Isr2dPoint aPoint) {
		throw SmalltalkException.SubclassResponsibility();
	}
	/**
	 * Answer true if the receiver is a 2d geometry element.
	 *
	 * @return boolean
	 */
	public boolean is2d() {
		return false;
	}
	/**
	 * Answer true if the receiver is a 3d geometry element.
	 *
	 * @return boolean
	 */
	public boolean is3d() {
		return false;
	}
	/**
	 * Answer true if the receiver is a curve.
	 *
	 * @return boolean
	 */
	public boolean isCurve() {
		return false;
	}
	/**
	 * Answer true if the receiver is a geometry.
	 *
	 * @return boolean
	 */
	public boolean isGeometry() {
		return true;
	}
	/**
	 * Answer true if the receiver is a global geometry.
	 *
	 * @return boolean
	 */
	public boolean isGlocalGeometry() {
		return true;
	}
	/**
	 * Answer true if the receiver is a surface.
	 *
	 * @return boolean
	 */
	public boolean isSurface() {
		return false;
	}
	/**
	 * Answer true if the receiver is a topology.
	 *
	 * @return boolean
	 */
	public boolean isTopology() {
		return false;
	}
}
