package sra.isr.interfaces.gauge;

import java.awt.*;
import java.util.*;
import sra.smalltalk.*;
import sra.isr.system.support.*;
import sra.isr.geometry.basic.*;

/**
 * IsrGaugeViewSwing class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       2000/03/13 (by Mitsuhiro Asada)
 * 	@updated:       N/A
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrGaugeViewSwing.java,v 1.2 2000/04/07 04:28:52 m-asada Exp $
 */
public class IsrGaugeViewSwing extends StViewJPanel implements IsrGaugeView {
	protected IsrGaugeController controller;
	protected StSymbol getSelector;
	protected StSymbol putSelector;
	protected double minValue;
	protected double maxValue;
	protected int divideValue;
	protected double roundValue;
	protected Vector scalesLayout;
	protected static Color _ForegroundColor = StColorValue.Black;
	protected static Color _SelectionForegroundColor = SystemColor.controlLtHighlight;
	protected static Color _SelectionBackgroundColor = SystemColor.textHighlight;
	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		this.setPreferredSize(new Dimension(100, 180));
		// controller
		controller = this.defaultController();
		controller.view_(this);
	}
	/**
	 * Answer a default model.
	 *
	 * @return sra.smalltalk.StModel
	 */
	protected IsrGaugeController defaultController() {
		return new IsrGaugeController();
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 *
	 * @return java.awt.Rectangle
	 */
	public Rectangle defaultMargin() {
		return new Rectangle(10, 10, 10, 10);
	}
	/**
	 * Answer a default model.
	 *
	 * @return sra.smalltalk.StModel
	 */
	protected StModel defaultModel() {
		return new IsrGaugeModel();
	}
	/**
	 * Display the border using the Graphics.
	 *
	 * @param graphics java.awt.Graphics
	 */
	public void displayBorderOn_(Graphics aGraphics) {
		if (!this.isShowing())
			return;
		Rectangle border = this.gaugeBorder();
		aGraphics.setColor(StColorValue.Brightness_(0.75));
		aGraphics.drawLine(border.x, border.y + border.height, border.x + border.width, border.y + border.height);
		aGraphics.setColor(StColorValue.Brightness_(0.75));
		aGraphics.drawLine(border.x + border.width, border.y, border.x + border.width, border.y + border.height);
		aGraphics.setColor(StColorValue.Brightness_(0.25));
		aGraphics.drawLine(border.x, border.y, border.x + border.width, border.y);
		aGraphics.setColor(StColorValue.Brightness_(0.25));
		aGraphics.drawLine(border.x, border.y, border.x, border.y + border.height);
	}
	/**
	 * paint this border rectangle.
	 *
	 * @param graphics java.awt.Graphics
	 */
	public void displayOn_(Graphics aGraphics) {
		this.displayBorderOn_(aGraphics);
		this.displayScalesOn_(aGraphics);
		this.displayValueOn_(aGraphics);
	}
	/**
	 * Display the scale using the Graphics.
	 *
	 * @param graphics java.awt.Graphics
	 */
	public void displayScalesOn_(Graphics aGraphics) {
		if (!this.isShowing())
			return;
		double location;
		int labelWidth, labelHeight, labelHeightFromBoxY;
		String label;
		Point point, stringCenterHeightPoint, lineFromPoint;
		StAssociation assoc;
		Rectangle bounds = new Rectangle(0, 0, this.getBounds().width, this.getBounds().height);
		Rectangle margin = this.defaultMargin();
		Rectangle box = new Rectangle(bounds.x + margin.x, bounds.y + margin.y, bounds.width - margin.width - margin.x, bounds.height - margin.height - margin.y);
		Point extent = this.gaugeScalesExtent();
		FontMetrics fontMetrics = SystemResourceSupport.getFontMetrics(SystemResourceSupport.getFont());
		Enumeration enum = this.gaugeScales().elements();
		while (enum.hasMoreElements()) {
			assoc = (StAssociation) enum.nextElement();
			label = assoc.key().toString();
			location = ((Double) assoc.value()).doubleValue();
			labelWidth = fontMetrics.stringWidth(label);
			labelHeight = fontMetrics.getAscent();
			labelHeightFromBoxY = box.height - (int) (box.height * location);
			point = new Point(box.x + (extent.x - labelWidth), labelHeightFromBoxY + box.y);
			stringCenterHeightPoint = new Point(point.x, point.y + (int) (labelHeight / 2));
			aGraphics.setColor(this._ForegroundColor);
			aGraphics.drawString(label, stringCenterHeightPoint.x, stringCenterHeightPoint.y);
			lineFromPoint = new Point(box.x + extent.x, labelHeightFromBoxY + box.y);
			aGraphics.setColor(this._ForegroundColor);
			aGraphics.drawLine(lineFromPoint.x + 3, lineFromPoint.y, lineFromPoint.x + 7, lineFromPoint.y);
		}
	}
	/**
	 * Display the value using the Graphics.
	 *
	 * @param graphics java.awt.Graphics
	 */
	public void displayValueOn_(Graphics aGraphics) {
		if (!this.isShowing())
			return;
		double value = (this.getValue() - minValue) / (maxValue - minValue);
		Rectangle border = this.gaugeBorder();
		border = new Rectangle(border.x + 1, border.y + 1, border.width - 1, border.height - 1);
		Rectangle back = new Rectangle(border.x, border.y, border.width, border.height - (int) (border.height * value));
		Rectangle fore = new Rectangle(back.x, back.y + back.height, border.width, border.height);
		aGraphics.setColor(this._SelectionForegroundColor);
		Rectangle intersection = back.intersection(border);
		aGraphics.fillRect(intersection.x, intersection.y, intersection.width, intersection.height);
		aGraphics.setColor(this._SelectionBackgroundColor);
		intersection = fore.intersection(border);
		aGraphics.fillRect(intersection.x, intersection.y, intersection.width, intersection.height);
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 *
	 * @return java.awt.Rectangle
	 */
	public Rectangle gaugeBorder() {
		Rectangle border = new Rectangle(0, 0, this.getBounds().width, this.getBounds().height);
		Rectangle margin = this.defaultMargin();
		Rectangle box = new Rectangle(border.x + margin.x, border.y + margin.y, border.width - margin.x - margin.width, border.height - margin.y - margin.height);
		int x = box.x + this.gaugeScalesExtent().x + 13;
		return new Rectangle(x, box.y, box.width - this.gaugeScalesExtent().x - 13, box.height);
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 *
	 * @return java.util.Vector
	 */
	public Vector gaugeScales() {
		return (Vector) this.scalesLayout().firstElement();
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 *
	 * @return java.awt.Point
	 */
	public Point gaugeScalesExtent() {
		return (Point) this.scalesLayout().lastElement();
	}
	/**
	 * Answer a Model.
	 *
	 * @return sra.isr.interfaces.gauge.IsrGaugeModel
	 */
	public IsrGaugeModel getModel() {
		return (IsrGaugeModel) this.model();
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 *
	 * @return double
	 */
	public double getValue() {
		return ((Double) this.model().perform_(getSelector.toString())).doubleValue();
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 *
	 * @param aModel sra.isr.interfaces.gauge.IsrGaugeModel
	 * @param aSymbol sra.smalltalk.StSymbol
	 * @param aSymbol sra.smalltalk.StSymbol
	 * @param anArray double[]
	 */
	public void on_get_put_valuesMinMaxDivideRound_(IsrGaugeModel aModel, StSymbol getSymbol, StSymbol putSymbol, double[] anArray) {
		double min = anArray[0];
		double max = anArray[1];
		double div = anArray[2];
		double rnd = anArray[3];
		this.model_(aModel);
		getSelector = getSymbol;
		putSelector = putSymbol;
		minValue = Math.min(min, max);
		maxValue = Math.max(max, min);
		divideValue = Math.max((int) Math.rint(div), 1);
		roundValue = Math.min(max - min, Math.max(rnd, 0));
		this.scalesLayout();
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 *
	 * @param aNumber double
	 */
	public void putValue_(double aNumber) {
		if (roundValue == 0) {
			this.getModel().value_(aNumber);
		} else {
			this.getModel().value_((Math.rint(aNumber / roundValue)) * roundValue);
		}
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 *
	 * @return Vector
	 */
	private Vector scalesLayout() {
		if (scalesLayout == null) {
			double value, location;
			Point point, extent;
			Vector labels = new Vector();
			labels.addElement(new StAssociation(new Double(minValue), new Double(0)));
			Font font = SystemResourceSupport.getFont();
			extent = SystemResourceSupport._getStringExtentFor_(Double.toString(minValue), font);
			for (int i = 1; i <= (divideValue - 1); i++) {
				value = (maxValue - minValue) * i / divideValue;
				location = 1.0 * i / divideValue;
				labels.addElement(new StAssociation(new Double(value), new Double(location)));
				point = SystemResourceSupport._getStringExtentFor_(Double.toString(value), font);
				extent = new Point(Math.max(extent.x, point.x), Math.max(extent.y, point.y));
			}
			labels.addElement(new StAssociation(new Double(maxValue), new Double(1.0)));
			point = SystemResourceSupport._getStringExtentFor_(Double.toString(maxValue), font);
			extent = new Point(Math.max(extent.x, point.x), Math.max(extent.y, point.y));
			scalesLayout = new Vector(2);
			scalesLayout.addElement(labels);
			scalesLayout.addElement(extent);
		}
		return scalesLayout;
	}
	/**
	 * model property accessing.
	 *
	 * @param aModel sra.isr.interfaces.gauge.IsrGaugeModel
	 */
	public void setModel(IsrGaugeModel aModel) {
		this.model_(aModel);
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 *
	 * @param cursorPoint Point
	 */
	public void setValue_(Point cursorPoint) {
		Rectangle box = this.gaugeBorder();
		Isr2dPoint point = new Isr2dPoint((double) (cursorPoint.x - box.x) / box.width, (double) (cursorPoint.y - box.y) / box.height);
		double value = 1.0 - point.y();
		value = value * (maxValue - minValue) + minValue;
		this.putValue_(value);
	}
	/**
	 * Update the receiver according to the change notification from the model.
	 *
	 * @param evt sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		if (!this.isShowing())
			return;
		if (evt.getAspect() == this.getSelector) {
			Graphics gc = this.getGraphics();
			try {
				this.displayValueOn_(gc);
			} finally {
				gc.dispose();
			}
		}
	}
}
