package sra.isr.interfaces.gauge;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import sra.smalltalk.*;

/**
 * IsrGaugeView class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       2000/02/17 (by Mitsuhiro Asada)
 * 	@updated:       2000/03/13 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrGaugeView.java,v 1.10 2000/04/07 04:24:19 m-asada Exp $
 */
public interface IsrGaugeView extends StView {
	/**
	 * Display the border using the Graphics.
	 *
	 * @param graphics java.awt.Graphics
	 */
	public void displayBorderOn_(Graphics aGraphics);
	/**
	 * Display the scale using the Graphics.
	 *
	 * @param graphics java.awt.Graphics
	 */
	public void displayScalesOn_(Graphics aGraphics);
	/**
	 * Display the value using the Graphics.
	 *
	 * @param graphics java.awt.Graphics
	 */
	public void displayValueOn_(Graphics aGraphics);
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 *
	 * @return java.awt.Rectangle
	 */
	public Rectangle gaugeBorder();
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 *
	 * @return java.util.Vector
	 */
	public Vector gaugeScales();
	/**
	 * Answer a Model.
	 *
	 * @return sra.isr.interfaces.gauge.IsrGaugeModel
	 */
	public IsrGaugeModel getModel();
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 *
	 * @return double
	 */
	public double getValue();
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 *
	 * @param aModel sra.isr.interfaces.gauge.IsrGaugeModel
	 * @param aSymbol sra.smalltalk.StSymbol
	 * @param aSymbol sra.smalltalk.StSymbol
	 * @param anArray double[]
	 */
	public void on_get_put_valuesMinMaxDivideRound_(IsrGaugeModel aModel, StSymbol getSymbol, StSymbol putSymbol, double[] anArray);
	/**
	 * model property accessing.
	 *
	 * @param aModel sra.isr.interfaces.gauge.IsrGaugeModel
	 */
	public void setModel(IsrGaugeModel aModel);
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 *
	 * @param cursorPoint Point
	 */
	public void setValue_(Point cursorPoint);
}
