package sra.isr.interfaces.gauge;

import java.io.*;
import java.awt.*;
import java.util.*;
import sra.smalltalk.*;
import sra.isr.system.support.*;

/**
 * IsrGaugeModel class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       1999/12/21 (by Mitsuhiro Asada)
 * 	@updated:       2000/02/17 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrGaugeModel.java,v 1.9 2000/04/07 04:24:19 m-asada Exp $
 */
public class IsrGaugeModel extends StApplicationModel {
	protected double gaugeValue;
	protected double[] gaugeRange;
	private boolean accepted = false;
	/**
	 * Construsctor
	 */
	public IsrGaugeModel() {
		super();
		initialize();
	}
	/**
	 * defines OK/Cancel dialog buttons.
	 *
	 * @return Panel
	 */
	public Panel _okCancelButtons(final Dialog target) {
		Panel panel = new Panel();
		final IsrGaugeModel this_ = this;
		panel.add("West", new Button("OK") {
			public boolean action(Event ev, Object what) {
				this_.accept();
				target.dispose();
				return true;
			}
		});
		panel.add("East", new Button("Cancel") {
			public boolean action(Event ev, Object what) {
				this_.cancel();
				target.dispose();
				return true;
			}
		});
		return panel;
	}
	/**
	 * accept button pressed action(in dialog mode)
	 */
	public void accept() {
		this.accepted = true;
	}
	/**
	 * accept button pressed action(in dialog mode). do nothing.
	 */
	public void cancel() {
	}
	/**
	 * Create a gauge view.
	 *
	 * @return sra.smalltalk.StView
	 */
	public StView createGaugeView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return IsrGaugeViewAwt.On_get_put_valuesMinMaxDivideRound_(this, StObject.$("value"), StObject.$("value_"), this.range());
		} else {
			IsrGaugeView view = (IsrGaugeView) this.CreateView("sra.isr.interfaces.gauge.IsrGaugeViewSwing");
			view.on_get_put_valuesMinMaxDivideRound_(this, StObject.$("value"), StObject.$("value_"), this.range());
			return view;
		}
	}
	/**
	 * Answer a default view.
	 *
	 * @return sra.smalltalk.StView
	 */
	public StView defaultView() {
		return this.createGaugeView();
	}
	/**
	 * Initialize this object.
	 */
	public IsrGaugeModel initialize() {
		return this;
	}
	/**
	 * Print my string representation on aWriter.
	 * 
	 * @param aWriter java.io.Writer
	 */
	public void printOn_(Writer aWriter) throws IOException {
		super.printOn_(aWriter);
		aWriter.write(" on: ");
		aWriter.write(Double.toString(this.value()));
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public double[] range() {
		if ((gaugeRange == null) || (gaugeRange == new double[] {0.0, 0.0, 0.0, 0.0})) {
			gaugeRange = new double[] {0.0, 100.0, 10.0, 1.0};
		}
		return gaugeRange;
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void range_(double[] anArray) {
		gaugeRange = anArray;
	}
	/**
	 * Create the Dialog for IsrGaugeModel with value.
	 *
	 * @return double
	 * @param aNumber double
	 */
	public static double Request_(double aNumber) {
		return Request_range_(aNumber, null);
	}
	/**
	 * Create the Dialog for IsrGaugeModel with value and range.
	 *
	 * @return double
	 * @param aNumber double
	 * @param anArray double[]
	 */
	public static double Request_range_(double aNumber, double[] anArray) {
		double result = 0;
		IsrGaugeModel gaugeModel = IsrGaugeModel.Value_range_(aNumber, anArray);
		Frame parent = new Frame();
		IsrGaugeView view = (IsrGaugeView) gaugeModel.createGaugeView();
		Dialog dialog = new Dialog(parent, "Gauge", true);
		dialog.setResizable(false);
		dialog.add("Center", (Component) view);
		dialog.add("South", gaugeModel._okCancelButtons(dialog));
		dialog.pack();
		try {
			Thread.sleep(0);
		} catch (Exception e) {
		}
		gaugeModel.changed();
		dialog.show();
		if (gaugeModel.accepted) {
			result = gaugeModel.value();
		}
		return result;
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public double value() {
		return gaugeValue;
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public static IsrGaugeModel Value_(double aNumber) {
		return Value_range_(aNumber, null);
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void value_(double aNumber) {
		gaugeValue = aNumber;
		this.changed_(StObject.$("value"));
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public static IsrGaugeModel Value_range_(double aNumber, double[] anArray) {
		IsrGaugeModel gaugeModel = new IsrGaugeModel();
		gaugeModel.value_(aNumber);
		gaugeModel.range_(anArray);
		return gaugeModel;
	}
	/**
	 * Answer a window title.
	 * @return java.lang.String
	 */
	protected String windowTitle() {
		return "Gauge";
	}
}
