package sra.isr.interfaces.gauge;

import java.awt.*;
import java.awt.event.*;
import sra.smalltalk.*;

/**
 * IsrGaugeController class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       1999/12/21 (by Mitsuhiro Asada)
 * 	@updated:       2000/02/17 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrGaugeController.java,v 1.8 2000/04/07 04:24:19 m-asada Exp $
 */
public class IsrGaugeController extends StController implements MouseListener, MouseMotionListener {
	/**
	 * add listeners.
	 * @param aView sra.mvctest.StView
	 */
	protected void buildListener(StView newView) {
		Component aView = (Component) newView;
		aView.addMouseListener(this);
		aView.addMouseMotionListener(this);
	}
	/**
	 * Answer this view.
	 *
	 * @return sra.isr.interfaces.gauge.IsrGaugeView interface
	 */
	protected IsrGaugeView getView() {
		return (IsrGaugeView) this.view();
	}
	/**
	 * The General dragging action.
	 *
	 * @param event java.awt.event.MouseEvent
	 */
	public void mouseDragged(MouseEvent event) {
		if (this.isMenuButtonPressed_(event)) {
			return;
		}
		this.mousePressed(event);
	}
	/**
	 * Invoked when a mouse button has been pressed. 
	 *
	 * @param event java.awt.event.MouseEvent
	 */
	public void mousePressed(MouseEvent event) {
		if (this.isMenuButtonPressed_(event)) {
			return;
		}
		Point point = event.getPoint();
		IsrGaugeView view = this.getView();
		if (view.gaugeBorder().contains(point)) {
			view.setValue_(point);
		}
	}
}
