package sra.isr.interfaces.freehand;

import java.awt.*;
import sra.smalltalk.*;
import sra.isr.system.support.*;

/**
 * IsrFreehandViewAwt class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       1999/12/21 (by Mitsuhiro Asada)
 * 	@updated:       2000/02/18 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrFreehandViewAwt.java,v 1.4 2000/04/07 04:24:19 m-asada Exp $
 */
public class IsrFreehandViewAwt extends StViewCanvas implements IsrFreehandView {
	protected IsrFreehandController controller;
	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		// controller
		controller = this.defaultController();
		controller.view_(this);
	}
	/**
	 * Answer a default controller.
	 *
	 * @return sra.isr.interfaces.freehand.IsrFreehandController
	 */
	protected IsrFreehandController defaultController() {
		return new IsrFreehandController();
	}
	/**
	 * Answer a default model.
	 *
	 * @return sra.smalltalk.StModel
	 */
	protected StModel defaultModel() {
		return new IsrFreehandModel();
	}
	/**
	 * paint this border rectangle.
	 *
	 * @param aGraphics java.awt.Graphics
	 */
	public void displayOn_(Graphics aGraphics) {
		this.displayPlateOn_(aGraphics);
	}
	/**
	 * Display the plate using the Graphics.
	 *
	 * @param aGraphics java.awt.Graphics
	 */
	public void displayPlateOn_(Graphics aGraphics) {
		if (!this.isShowing())
			return;
		Rectangle box = this.plateArea();
		aGraphics.clipRect(box.x - 1, box.y - 1, box.width + 2, box.height + 2);
		aGraphics.drawImage(this.plate(), box.x, box.y, this);
		aGraphics.setColor(Color.black);
		aGraphics.drawRect(box.x - 1, box.y - 1, box.width + 1, box.height + 1);
	}
	/**
	 * Answer a Model.
	 *
	 * @return sra.isr.interfaces.freehand.IsrFreehandModel
	 */
	public IsrFreehandModel getModel() {
		return (IsrFreehandModel) this.model();
	}
	/**
	 * get the plate image.
	 *
	 * @return java.awt.Image
	 */
	public Image plate() {
		return this.getModel().plate();
	}
	/**
	 * get the plate bounds.
	 *
	 * @return java.awt.Rectangle
	 */
	public Rectangle plateArea() {
		Rectangle imageRect = new Rectangle(0, 0, this.plate().getWidth(this), this.plate().getHeight(this));
		imageRect.translate(10, 10);
		return imageRect;
	}
	/**
	 * Cleanup this object.
	 */
	public void release() {
		this.getModel().release();
		this.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
	}
	/**
	 * model property accessing.
	 *
	 * @param aModel sra.isr.interfaces.freehand.IsrFreehandModel
	 */
	public void setModel(IsrFreehandModel aModel) {
		this.model_(aModel);
	}
	/**
	 * Update the receiver according to the change notification from the model.
	 *
	 * @param evt sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		if (!this.isShowing())
			return;
		if (evt.getAspect() == $("plate")) {
			Graphics gc = this.getGraphics();
			try {
				this.displayPlateOn_(gc);
			} finally {
				gc.dispose();
			}
		}
	}
}