package sra.isr.interfaces.freehand;

import java.awt.*;
import java.awt.event.*;
import sra.smalltalk.*;
import sra.isr.system.support.*;
import sra.isr.image.support.*;
import sra.isr.interfaces.colors.*;
import sra.isr.interfaces.button.*;
import sra.isr.interfaces.cursors.*;
import sra.isr.geometry.basic.*;

/**
 * IsrFreehandModel class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       1999/12/21 (by Mitsuhiro Asada)
 * 	@updated:       2000/03/07 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrFreehandModel.java,v 1.18 2000/04/07 04:24:19 m-asada Exp $
 */
public class IsrFreehandModel extends StApplicationModel {
	protected Image currentPixmap;
	protected int lineWidth = 4;
	protected IsrColorChoiceModel colorModel;
	protected IsrButtonModel colorButton;
	private boolean accepted = false;
	//
	protected PopupMenu brushMenu;
	/**
	 * Construsctor
	 */
	public IsrFreehandModel() {
		super();
	}
	/**
	 * Set line width with argument.
	 *
	 * @param number int 
	 */
	public void _lineWidth_(int number) {
		lineWidth= number;
	}
	/**
	 * Set line width 1.
	 */
	public void _lineWidth1() {
		this._lineWidth_(1);
	}
	/**
	 * Set line width 10.
	 */
	public void _lineWidth10() {
		this._lineWidth_(10);
	}
	/**
	 * Set line width 16.
	 */
	public void _lineWidth16() {
		this._lineWidth_(16);
	}
	/**
	 * Set line width 2.
	 */
	public void _lineWidth2() {
		this._lineWidth_(2);
	}
	/**
	 * Set line width 24.
	 */
	public void _lineWidth24() {
		this._lineWidth_(24);
	}
	/**
	 * Set line width 3.
	 */
	public void _lineWidth3() {
		this._lineWidth_(3);
	}
	/**
	 * Set line width 32.
	 */
	public void _lineWidth32() {
		this._lineWidth_(32);
	}
	/**
	 * Set line width 4.
	 */
	public void _lineWidth4() {
		this._lineWidth_(4);
	}
	/**
	 * Set line width 5.
	 */
	public void _lineWidth5() {
		this._lineWidth_(5);
	}
	/**
	 * Set line width 6.
	 */
	public void _lineWidth6() {
		this._lineWidth_(6);
	}
	/**
	 * Set line width 7.
	 */
	public void _lineWidth7() {
		this._lineWidth_(7);
	}
	/**
	 * Set line width 8.
	 */
	public void _lineWidth8() {
		this._lineWidth_(8);
	}
	/**
	 * Set line width 9.
	 */
	public void _lineWidth9() {
		this._lineWidth_(9);
	}
	/**
	 * defines OK/Cancel dialog buttons.
	 *
	 * @return Panel
	 */
	public Panel _okCancelButtons(final Dialog target) {
		Panel panel = new Panel();
		final IsrFreehandModel this_ = this;
		panel.add("West", new Button("OK") {
			public boolean action(Event ev, Object what) {
				this_.accept();
				target.dispose();
				return true;
			}
		});
		panel.add("East", new Button("Cancel") {
			public boolean action(Event ev, Object what) {
				this_.cancel();
				target.dispose();
				return true;
			}
		});
		return panel;
	}
	/**
	 * accept button pressed action(in dialog mode)
	 */
	public void accept() {
		this.accepted = true;
	}
	/**
	 * Answer my brush button.
	 * 
	 * @return sra.isr.interfaces.button.IsrButtonModel
	 */
	public IsrButtonModel brushButton() {
		final IsrFreehandModel self = this;
		StBlockClosure block = new StBlockClosure() {
			public Object value_value_(Object o1, Object o2) {
				IsrButtonModel model = (IsrButtonModel) o1;
				MouseEvent event = (MouseEvent) o2;
				self.brushButtonAction(event);
				return null;
			}
		};
		return IsrButtonModel.Value_visual_action_(false, IsrCursors.BrushCursor(), block);
	}
	/**
	 * Set the brush button action.
	 */
	public void brushButtonAction(MouseEvent event) {
		Point point = event.getPoint();
		Component component = event.getComponent();
		if (brushMenu == null) {
			brushMenu = this.brushMenu();
			component.add(brushMenu);
		}
		brushMenu.show(component, point.x, point.y);
	}
	/**
	 * Create a popup menu of brush button.
	 *
	 * @return java.awt.PopupMenu
	 */
	protected PopupMenu brushMenu() {
		StMenuModel rootMenu = new StMenuModel();
		//
		StMenu lineWidthMenu = new StMenu("LineWidthMenu");
		lineWidthMenu.add(this.createMenuItem("1", "_lineWidth1"));
		lineWidthMenu.add(this.createMenuItem("2", "_lineWidth2"));
		lineWidthMenu.add(this.createMenuItem("3", "_lineWidth3"));
		lineWidthMenu.add(this.createMenuItem("4", "_lineWidth4"));
		lineWidthMenu.add(this.createMenuItem("5", "_lineWidth5"));
		lineWidthMenu.add(this.createMenuItem("6", "_lineWidth6"));
		lineWidthMenu.add(this.createMenuItem("7", "_lineWidth7"));
		lineWidthMenu.add(this.createMenuItem("8", "_lineWidth8"));
		lineWidthMenu.add(this.createMenuItem("9", "_lineWidth9"));
		lineWidthMenu.add(this.createMenuItem("10", "_lineWidth10"));
		lineWidthMenu.add(this.createMenuItem("16", "_lineWidth16"));
		lineWidthMenu.add(this.createMenuItem("24", "_lineWidth24"));
		lineWidthMenu.add(this.createMenuItem("32", "_lineWidth32"));
		rootMenu.add(lineWidthMenu);
		//
		StMenu menu = (StMenu) rootMenu.getItem("LineWidthMenu");
		PopupMenu popupMenu = StMenuViewForAwt.CreatePopupMenu(menu);
		return popupMenu;
	}
	/**
	 * accept button pressed action(in dialog mode). do nothing.
	 */
	public void cancel() {
	}
	/**
	 * Clear plate.
	 */
	public void clear() {
		Graphics gc = this.currentPixmap.getGraphics();
		try {
			gc.setColor(Color.white);
			gc.fillRect(0, 0, this.defaultSize(), this.defaultSize());
			this.commit();
			this.changed_(StObject.$("plate"));
		} finally {
			gc.dispose();
		}
	}
	/**
	 * Answer my selection color.
	 * 
	 * @return java.awt.Color
	 */
	public Color color() {
		return this.colorModel().color();
	}
	/**
	 * Answer my color button.
	 * 
	 * @return sra.isr.interfaces.button.IsrButtonModel
	 */
	public IsrButtonModel colorButton() {
		if (this.colorButton == null) {
			final IsrFreehandModel self = this;
			StBlockClosure block = new StBlockClosure() {
				public Object value_(Object o) {
					self.colorButtonAction();
					return null;
				}
			};
			colorButton = IsrButtonModel.Value_visual_action_(false, this.colorImage(), block);
		}
		return colorButton;
	}
	/**
	 * Set the color button action.
	 */
	public void colorButtonAction() {
		IsrColorChoiceModel model = this.colorModel();
		Frame frames[] = new Frame[model.builder().frames().length];
		frames = model.builder().frames();
		for (int i = 0; i < frames.length; i++) {
			if (frames[i].isShowing()) {
				frames[i].toFront();
			} else {
				frames[i].show();
			}
		}
		if (frames.length == 0) {
			model.open();
		}
	}
	/**
	 * Answer default color image.
	 * 
	 * @return java.awt.Image
	 */
	public Image colorImage() {
		StImage image = new StImage(16, 16);
		Rectangle bounds = image.bounds();
		image = IsrImageProcessor.Fill_rectangle_color_(image, bounds, Color.white);
		bounds = new Rectangle(1, 1, bounds.width - 2, bounds.height - 2);
		image = IsrImageProcessor.Fill_rectangle_color_(image, bounds, this.color());
		return image.image();
	}
	/**
	 * Answer my color model.
	 * 
	 * @return sra.isr.interfaces.colors.IsrColorChoiceModel
	 */
	public IsrColorChoiceModel colorModel() {
		if (this.colorModel == null) {
			colorModel = new IsrColorChoiceSBH();
			colorModel.color_(Color.black);
			colorModel.addDependent_(this);
		}
		return colorModel;
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void commit() {
		// this.freehandImage = new StImage(this.currentPixmap());
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public Image currentPixmap() {
		if (currentPixmap == null) {
			currentPixmap = SystemResourceSupport.createImage(this.defaultSize(), this.defaultSize());
			this.clear();
		}
		return currentPixmap;
	}
	/**
	 * Answer brush cursor.
	 * 
	 * @return java.awt.Cursor
	 */
	public Cursor cursor() {
		// JDK1.2
		// return sra.isr.interfaces.cursors.IsrCursors2.BrushCursor();
		return Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR);
	}
	/**
	 * Answer default plate size.
	 * 
	 * @return int
	 */
	public int defaultSize() {
		return 150;
	}
	/**
	 * Answer a default view.
	 *
	 * @return sra.smalltalk.StView
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new IsrFreehandApplicationViewAwt();
		} else {
			return CreateView("sra.isr.interfaces.freehand.IsrFreehandApplicationViewSwing");
		}
	}
	/**
	 * Answer my eraser button.
	 * 
	 * @return sra.isr.interfaces.button.IsrButtonModel
	 */
	public IsrButtonModel eraserButton() {
		final IsrFreehandModel self = this;
		StBlockClosure block = new StBlockClosure() {
			public Object value_(Object o) {
				self.eraserButtonAction();
				return null;
			}
		};
		return IsrButtonModel.Value_visual_action_(false, IsrCursors.EraserCursor(), block);
	}
	/**
	 * Set the eraser button action.
	 */
	public void eraserButtonAction() {
		this.clear();
	}
	/**
	 * Answer freehand image.
	 * 
	 * @return sra.smalltalk.StImage
	 */
	public StImage getImage() {
		this.commit();
		return new StImage(this.currentPixmap());
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void gstate_(Graphics gc) {
		gc.setColor(this.color());
		gc.setPaintMode();
	}
	/**
	 * Answer line width.
	 * 
	 * @return int
	 */
	public int lineWidth() {
		if (lineWidth == 0) {
			lineWidth = 4;
		}
		return lineWidth;
	}
	/**
	 * the plate image.
	 *
	 * @return java.awt.Image
	 */
	public Image plate() {
		return this.currentPixmap();
	}
	/**
	 * Cleanup this object.
	 */
	public void release() {
		if (currentPixmap != null) {
			this.commit();
			currentPixmap.flush();
			currentPixmap = null;
		}
	}
	/**
	 * Create the Dialog for IsrFreehandModel with initial image.
	 *
	 * @return sra.smalltalk.StImage
	 */
	public static StImage Request() {
		return Request_(SystemResourceSupport.createImage(16, 16));
	}
	/**
	 * Create the Dialog for IsrFreehandModel with image.
	 *
	 * @return StImage
	 * @param anImage java.awt.Image
	 */
	public static StImage Request_(Image anImage) {
		StImage result = null;
		IsrFreehandModel freehandModel = new IsrFreehandModel();
		if (anImage == null) {
			freehandModel.setImage(SystemResourceSupport.createImage(16, 16));
		} else {
			freehandModel.setImage(anImage);
		}
		Frame parent = new Frame();
		IsrFreehandApplicationView view = (IsrFreehandApplicationView) freehandModel.defaultView();
		view.setModel(freehandModel);
		Dialog dialog = new Dialog(parent, "Gauge", true);
		dialog.setResizable(false);
		dialog.add("Center", (Component) view);
		dialog.add("South", freehandModel._okCancelButtons(dialog));
		dialog.pack();
		try {
			Thread.sleep(0);
		} catch (Exception e) {
		}
		freehandModel.changed();
		dialog.show();
		if (freehandModel.accepted) {
			result = (StImage) freehandModel.getImage().copy();
		}
		return result;
	}
	/**
	 * Answer my scissors button.
	 * 
	 * @return sra.isr.interfaces.button.JunButtonModel
	 */
	public IsrButtonModel scissorsButton() {
		final IsrFreehandModel self = this;
		StBlockClosure block = new StBlockClosure() {
			public Object value_(Object o) {
				self.scissorsButtonAction();
				return null;
			}
		};
		int[] pixcels = new int[23 * 23];
		for (int i = 0; i < pixcels.length; i++) {
			pixcels[i] = 0x00000000;
		}
		StImage anImage = new StImage(23, 23, pixcels);
		anImage.copy_from_in_rule_(new Rectangle(4, 4, 16, 16), new Point(0, 0), new StImage(IsrCursors.ScissorsCursor()), StImage.Over);
		int black = Color.black.getRGB();
		int color = (new Color((float) 0.7, (float) 0.7, (float) 0.7)).getRGB();
		for (int i = 0; i < anImage.bits().length; i++) {
			if (anImage.bits()[i] == black) {
				anImage.bits()[i] = color;
			}
		}
		return IsrButtonModel.Value_visual_action_(false, anImage.image(), block);
	}
	/**
	 * Set the scissors button action.
	 */
	public void scissorsButtonAction() {
		StDialog.Warn_("ShouldNotImpliment");
	}
	/**
	 * Set freehand image.
	 * 
	 * @param java.awt.Image
	 */
	public void setImage(Image anImage) {
		this.currentPixmap = anImage;
		this.commit();
		this.changed_(StObject.$("plate"));
	}
	/**
	 * Answer my spuit button.
	 * 
	 * @return sra.isr.interfaces.button.JunButtonModel
	 */
	public IsrButtonModel spuitButton() {
		final IsrFreehandModel self = this;
		StBlockClosure block = new StBlockClosure() {
			public Object value_(Object o) {
				self.spuitButtonAction();
				return null;
			}
		};
		int[] pixcels = new int[23 * 23];
		for (int i = 0; i < pixcels.length; i++) {
			pixcels[i] = 0x00000000;
		}
		StImage anImage = new StImage(23, 23, pixcels);
		anImage.copy_from_in_rule_(new Rectangle(4, 4, 16, 16), new Point(0, 0), new StImage(IsrCursors.SpuitCursor()), StImage.Over);
		int black = Color.black.getRGB();
		int color = (new Color((float) 0.7, (float) 0.7, (float) 0.7)).getRGB();
		for (int i = 0; i < anImage.bits().length; i++) {
			if (anImage.bits()[i] == black) {
				anImage.bits()[i] = color;
			}
		}
		return IsrButtonModel.Value_visual_action_(false, anImage.image(), block);
	}
	/**
	 * Set the spuit button action.
	 */
	public void spuitButtonAction() {
		StDialog.Warn_("ShouldNotImpliment");
	}
	/**
	 * Update the receiver according to the change notification from color button.
	 *
	 * @param evt sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		StSymbol aSymbol = evt.getAspect();
		if ((aSymbol == $("xy")) || (aSymbol == $("z")) || (aSymbol == $("color"))) {
			this.colorButton().visual_(this.colorImage());
		}
	}
	/**
	 * Answer a window title.
	 * @return java.lang.String
	 */
	protected String windowTitle() {
		return "Freehand";
	}
}