package sra.isr.interfaces.freehand;

import java.awt.*;
import java.awt.event.*;
import sra.smalltalk.*;

/**
 * IsrFreehandController class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       1999/12/21 (by Mitsuhiro Asada)
 * 	@updated:       2000/02/18 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrFreehandController.java,v 1.12 2000/04/07 04:24:19 m-asada Exp $
 */
public class IsrFreehandController extends StController implements MouseListener, MouseMotionListener {
	protected Point previousPoint = new Point(0, 0);
	protected Point currentPoint = new Point(0, 0);
	/**
	 * add listeners.
	 * @param aView sra.mvctest.StView
	 */
	protected void buildListener(StView newView) {
		Component aView = (Component) newView;
		aView.addMouseListener(this);
		aView.addMouseMotionListener(this);
	}
	/**
	 * Answer a model.
	 *
	 * @return sra.isr.interfaces.freehand.IsrFreehandModel
	 */
	protected final IsrFreehandModel getModel() {
		return (IsrFreehandModel) this.model();
	}
	/**
	 * Answer this view.
	 *
	 * @return sra.isr.interfaces.freehand.IsrFreehandView interface
	 */
	protected IsrFreehandView getView() {
		return (IsrFreehandView) this.view();
	}
	/**
	 * The General dragging action.
	 *
	 * @param event java.awt.event.MouseEvent
	 */
	public void mouseDragged(MouseEvent event) {
		if (this.isMenuButtonPressed_(event)) {
			return;
		}
		IsrFreehandView view = this.getView();
		IsrFreehandModel model = this.getModel();
		Rectangle box = view.plateArea();
		currentPoint = event.getPoint();
		currentPoint.translate(0 - box.x, 0 - box.y);
		Graphics gc = model.currentPixmap().getGraphics();
		model.gstate_(gc);
		int lineWidth = model.lineWidth();
		if (previousPoint != null) {
			for (int width = - (lineWidth / 2); width < (- (lineWidth / 2) + lineWidth); width++) {
				gc.drawLine(previousPoint.x + width, previousPoint.y, currentPoint.x + width, currentPoint.y);
				gc.drawLine(previousPoint.x, previousPoint.y + width, currentPoint.x, currentPoint.y + width);
			}
		}
		if (box.contains(event.getPoint())) {
			gc.fillOval(currentPoint.x - (lineWidth / 2), currentPoint.y - (lineWidth / 2), lineWidth, lineWidth);
		}
		model.setImage(model.currentPixmap());
		previousPoint = currentPoint;
		gc.dispose();
	}
	/**
	 * Invoked when the mouse button has been moved on a component
	 *
	 * @param event java.awt.event.MouseEvent
	 */
	public void mouseMoved(MouseEvent event) {
		IsrFreehandView view = this.getView();
		if (view.plateArea().contains(event.getPoint())) {
			((Component) view).setCursor(this.getModel().cursor());
		} else {
			((Component) view).setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
		}
	}
	/**
	 * Invoked when a mouse button has been pressed. 
	 *
	 * @param event java.awt.event.MouseEvent
	 */
	public void mousePressed(MouseEvent event) {
		if (this.isMenuButtonPressed_(event)) {
			return;
		}
		IsrFreehandView view = this.getView();
		IsrFreehandModel model = this.getModel();
		Rectangle box = view.plateArea();
		if (box.contains(event.getPoint())) {
			currentPoint = event.getPoint();
			currentPoint.translate(0 - box.x, 0 - box.y);
			Graphics gc = model.currentPixmap().getGraphics();
			model.gstate_(gc);
			int lineWidth = model.lineWidth();
			gc.fillOval(currentPoint.x - (lineWidth / 2), currentPoint.y - (lineWidth / 2), lineWidth, lineWidth);
			previousPoint = currentPoint;
			model.setImage(model.currentPixmap());
			gc.dispose();
		} else {
			previousPoint = null;
		}
	}
}
