package sra.isr.interfaces.freehand;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import sra.smalltalk.*;
import sra.isr.system.support.*;
import sra.isr.interfaces.button.*;
import sra.isr.interfaces.cursors.*;

/**
 * IsrFreehandApplicationViewSwing class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       2000/03/13 (by Mitsuhiro Asada)
 * 	@updated:       N/A
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrFreehandApplicationViewSwing.java,v 1.4 2000/04/07 04:28:51 m-asada Exp $
 */
public class IsrFreehandApplicationViewSwing extends StViewJPanel implements IsrFreehandApplicationView {
	//protected IsrButtonViewSwing scissorsButtonView;
	protected JButton scissorsButtonView;
	protected IsrButtonViewSwing brushButtonView;
	protected IsrButtonViewSwing colorButtonView;
	//protected IsrButtonViewSwing spuitButtonView;
	protected JButton spuitButtonView;
	protected IsrButtonViewSwing eraserButtonView;
	protected IsrFreehandViewSwing freehandView;
	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		this.setLayout(new BorderLayout());

		//leftTopPanel
		JPanel leftTopPanel = new JPanel(new GridLayout(5, 1));
		//
		//scissorsButtonView = new IsrButtonViewSwing();
		scissorsButtonView = new JButton(new ImageIcon(IsrCursors.ScissorsCursor()));
		scissorsButtonView.setPreferredSize(new Dimension(23, 23));
		scissorsButtonView.setEnabled(false);
		leftTopPanel.add(scissorsButtonView);
		//
		brushButtonView = new IsrButtonViewSwing() {
			protected IsrButtonController defaultController() {
				return new IsrButtonController() {
					public void mousePressed(MouseEvent e) {
						IsrButtonViewSwing view = (IsrButtonViewSwing) this.getView();
						IsrButtonModel model = this.getModel();
						Rectangle box = new Rectangle(0, 0, view.getBounds().width, view.getBounds().height);
						if (!box.contains(e.getPoint())) {
							return;
						}
						StBlockClosure action = model.action();
						if (action != null) {
							switch (action.numArgs()) {
								case 0 :
									action.value();
									break;
								case 1 :
									action.value_(model);
									break;
								case 2 :
									action.value_value_(model, e);
									break;
							}
						}
						e.consume();
					}
					public void mouseReleased(MouseEvent e) {
					}
					public void mouseEntered(MouseEvent e) {
					}
					public void mouseExited(MouseEvent e) {
					}
				};
			}
		};
		brushButtonView.setPreferredSize(new Dimension(23, 23));
		leftTopPanel.add(brushButtonView);
		//
		colorButtonView = new IsrButtonViewSwing();
		colorButtonView.setPreferredSize(new Dimension(23, 23));
		leftTopPanel.add(colorButtonView);
		//
		//spuitButtonView = new IsrButtonViewSwing();
		spuitButtonView = new JButton(new ImageIcon(IsrCursors.SpuitCursor()));
		spuitButtonView.setPreferredSize(new Dimension(23, 23));
		spuitButtonView.setEnabled(false);
		leftTopPanel.add(spuitButtonView);
		//
		eraserButtonView = new IsrButtonViewSwing();
		eraserButtonView.setPreferredSize(new Dimension(23, 23));
		leftTopPanel.add(eraserButtonView);

		//leftPanel
		JPanel leftPanel = new JPanel(new BorderLayout());
		//
		leftPanel.add(leftTopPanel, "North");

		//centerPanel
		Panel centerPanel = StApplicationModel._PanelWithBorder();
		centerPanel.setLayout(new BorderLayout());
		//
		freehandView = new IsrFreehandViewSwing();
		freehandView.setPreferredSize(new Dimension(this.getModel().defaultSize() + 20, this.getModel().defaultSize() + 20));
		freehandView.model_(this.getModel());
		centerPanel.add(freehandView, "Center");
		this.add(leftPanel, "West");
		this.add(centerPanel, "Center");
	}
	/**
	 * Answer a default model.
	 *
	 * @return sra.smalltalk.StModel
	 */
	protected StModel defaultModel() {
		return new IsrFreehandModel();
	}
	/**
	 * Answer a Model.
	 *
	 * @return sra.isr.interfaces.freehand.IsrFreehandModel
	 */
	public IsrFreehandModel getModel() {
		return (IsrFreehandModel) this.model();
	}
	/**
	 * Rebuild this component.
	 * @param oldModel sra.smalltalk.StModel
	 * @param newModel sra.smalltalk.StModel
	 */
	protected void rebuildComponent(StModel oldModel, StModel newModel) {
		IsrFreehandModel model = (IsrFreehandModel) this.model();
		freehandView.model_(model);
		//
		//scissorsButtonView.model_(model.scissorsButton());
		brushButtonView.model_(model.brushButton());
		colorButtonView.model_(model.colorButton());
		//spuitButtonView.model_(model.spuitButton());
		eraserButtonView.model_(model.eraserButton());
	}
	/**
	 * model property accessing.
	 *
	 * @param aModel sra.isr.interfaces.freehand.IsrFreehandModel
	 */
	public void setModel(IsrFreehandModel aModel) {
		this.model_(aModel);
	}
}