package sra.isr.interfaces.freehand;

import java.awt.*;
import java.awt.event.*;
import sra.smalltalk.*;
import sra.isr.system.support.*;
import sra.isr.interfaces.button.*;

/**
 * IsrFreehandApplicationViewAwt class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       1999/12/21 (by Mitsuhiro Asada)
 * 	@updated:       2000/03/07 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrFreehandApplicationViewAwt.java,v 1.9 2000/04/07 04:24:19 m-asada Exp $
 */
public class IsrFreehandApplicationViewAwt extends StViewPanel implements IsrFreehandApplicationView {
	protected IsrButtonViewAwt scissorsButtonView;
	protected IsrButtonViewAwt brushButtonView;
	protected IsrButtonViewAwt colorButtonView;
	protected IsrButtonViewAwt spuitButtonView;
	protected IsrButtonViewAwt eraserButtonView;
	protected IsrFreehandViewAwt freehandView;
	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		Panel leftPanel, leftTopPanel, centerPanel;
		this.setLayout(new BorderLayout());

		//leftTopPanel
		leftTopPanel = new Panel(new GridLayout(5, 1));
		//
		scissorsButtonView = new IsrButtonViewAwt();
		scissorsButtonView.setSize(23, 23);
		scissorsButtonView.setEnabled(false);
		leftTopPanel.add(scissorsButtonView);
		//
		brushButtonView = new IsrButtonViewAwt() {
			protected IsrButtonController defaultController() {
				return new IsrButtonController() {
					public void mousePressed(MouseEvent e) {
						IsrButtonViewAwt view = (IsrButtonViewAwt) this.getView();
						IsrButtonModel model = this.getModel();
						Rectangle box = new Rectangle(0, 0, view.getBounds().width, view.getBounds().height);
						if (!box.contains(e.getPoint())) {
							return;
						}
						StBlockClosure action = model.action();
						if (action != null) {
							switch (action.numArgs()) {
								case 0 :
									action.value();
									break;
								case 1 :
									action.value_(model);
									break;
								case 2 :
									action.value_value_(model, e);
									break;
							}
						}
						e.consume();
					}
					public void mouseReleased(MouseEvent e) {
					}
					public void mouseEntered(MouseEvent e) {
					}
					public void mouseExited(MouseEvent e) {
					}
				};
			}
		};
		brushButtonView.setSize(23, 23);
		leftTopPanel.add(brushButtonView);
		//
		colorButtonView = new IsrButtonViewAwt();
		colorButtonView.setSize(23, 23);
		leftTopPanel.add(colorButtonView);
		//
		spuitButtonView = new IsrButtonViewAwt();
		spuitButtonView.setSize(23, 23);
		spuitButtonView.setEnabled(false);
		leftTopPanel.add(spuitButtonView);
		//
		eraserButtonView = new IsrButtonViewAwt();
		eraserButtonView.setSize(23, 23);
		leftTopPanel.add(eraserButtonView);

		//leftPanel
		leftPanel = new Panel(new BorderLayout());
		//
		leftPanel.add(leftTopPanel, "North");

		//centerPanel
		centerPanel = StApplicationModel._PanelWithBorder();
		centerPanel.setLayout(new BorderLayout());
		//
		freehandView = new IsrFreehandViewAwt();
		freehandView.setSize(this.getModel().defaultSize() + 20, this.getModel().defaultSize() + 20);
		freehandView.model_(this.getModel());
		centerPanel.add(freehandView, "Center");
		this.add(leftPanel, "West");
		this.add(centerPanel, "Center");
	}
	/**
	 * Answer a default model.
	 *
	 * @return sra.smalltalk.StModel
	 */
	protected StModel defaultModel() {
		return new IsrFreehandModel();
	}
	/**
	 * Answer a Model.
	 *
	 * @return sra.isr.interfaces.freehand.IsrFreehandModel
	 */
	public IsrFreehandModel getModel() {
		return (IsrFreehandModel) this.model();
	}
	/**
	 * Rebuild this component.
	 * @param oldModel sra.smalltalk.StModel
	 * @param newModel sra.smalltalk.StModel
	 */
	protected void rebuildComponent(StModel oldModel, StModel newModel) {
		IsrFreehandModel model = (IsrFreehandModel) this.model();
		freehandView.model_(model);
		//
		scissorsButtonView.model_(model.scissorsButton());
		brushButtonView.model_(model.brushButton());
		colorButtonView.model_(model.colorButton());
		spuitButtonView.model_(model.spuitButton());
		eraserButtonView.model_(model.eraserButton());
	}
	/**
	 * model property accessing.
	 *
	 * @param aModel sra.isr.interfaces.freehand.IsrFreehandModel
	 */
	public void setModel(IsrFreehandModel aModel) {
		this.model_(aModel);
	}
}
