package sra.isr.interfaces.display;

import java.awt.*;
import sra.smalltalk.*;

/**
 * IsrDisplayViewSwing class
 * 
 * 	@author:        nisinaka
 * 	@created:       1998/11/16 (by nisinaka)
 * 	@updated:       1999/11/11 (by MATSUDA Ryouichi)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrDisplayViewSwing.java,v 1.2 2000/04/07 04:28:51 m-asada Exp $
 */
public class IsrDisplayViewSwing extends StViewJPanel implements IsrDisplayView {
	protected boolean resizable;
	/**
	 * Answer the preferred size of the object.
	 *
	 * @return java.awt.Dimension
	 * @param anObject java.lang.Object
	 */
	protected Dimension _getPreferredSizeOf(Object anObject) {
		if (anObject instanceof Image) {
			Image anImage = (Image) anObject;
			return new Dimension(anImage.getWidth(null), anImage.getHeight(null));
		} else {
			String aString;
			if (anObject instanceof String) {
				aString = (String) anObject;
			} else {
				aString = anObject.toString();
			}
			Point extent = SystemResourceSupport._getStringExtentFor_(aString, null);
			return new Dimension(extent.x, extent.y);
		}
	}
	/**
	 * Adjust size.
	 */
	public void adjustSize() {
		Dimension size = this._getPreferredSizeOf(getModel().visual());
		this.setPreferredSize(size);
		this.setSize(size);
	}
	/**
	 * Answer a default model.
	 * @return sra.smalltalk.StModel
	 */
	protected StModel defaultModel() {
		return new IsrDisplayModel();
	}
	/**
	 * Display the receiver on aGraphics.
	 * @param aGraphics java.awt.Graphics
	 */
	public void displayOn_(Graphics aGraphics) {
		Object displayObject = this.getModel().visual();
		if (displayObject instanceof Image) {
			Image anImage = (Image) displayObject;
			if (this.isResizable()) {
				aGraphics.drawImage(anImage, 0, 0, this.getSize().width, this.getSize().height, null);
			} else {
				int x = (this.getSize().width - anImage.getWidth(null)) / 2;
				int y = (this.getSize().height - anImage.getHeight(null)) / 2;
				aGraphics.drawImage(anImage, x, y, null);
			}
		} else {
			String aString;
			if (displayObject instanceof String) {
				aString = (String) displayObject;
			} else {
				aString = displayObject.toString();
			}
			FontMetrics fontMetrics = aGraphics.getFontMetrics();
			int x = (this.getSize().width - fontMetrics.stringWidth(aString)) / 2;
			int y = (this.getSize().height + fontMetrics.getAscent()) / 2;
			aGraphics.setColor(Color.black);
			aGraphics.drawString(aString, x, y);
		}
	}
	/**
	 * model property.
	 * @return sra.isr.interfaces.display.IsrDisplayModel
	 */
	public IsrDisplayModel getModel() {
		return (IsrDisplayModel) this.model();
	}
	/**
	 * visual property.
	 * @return java.lang.Object
	 */
	public Object getVisual() {
		return this.getModel().visual();
	}
	/**
	 * resizable property.
	 * @return boolean
	 */
	public boolean isResizable() {
		return resizable;
	}
	/**
	 * model property.
	 * @return sra.isr.interfaces.display.IsrDisplayModel
	 */
	public void setModel(IsrDisplayModel aModel) {
		this.model_(aModel);
	}
	/**
	 * resizable property.
	 * @param newValue boolean
	 */
	public void setResizable(boolean newValue) {
		boolean oldValue = resizable;
		resizable = newValue;
		this.repaint();
		this.firePropertyChange("resizable", new Boolean(oldValue), new Boolean(newValue));
	}
	/**
	 * visual property.
	 * @param anObject java.lang.Object
	 */
	public void setVisual(Object anObject) {
		this.getModel().visual_(anObject);
	}
	/*
	 * Update
	 * @param evt sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		if (evt.getAspect() == $("visual")) {
			this.repaint();
			this.firePropertyChange("visual", null, getVisual());
		} else {
			super.update_(evt);
		}
	}
}
