package sra.isr.interfaces.display;

import java.awt.*;
import java.awt.image.*;
import sra.smalltalk.*;
import sra.isr.system.support.*;

/**
 * IsrDisplayModelTestExamples class
 * 
 * 	@author:        Hirotsugu Kondo
 * 	@created:       1998/11/16 (by Hirotsugu Kondo)
 * 	@updated:       N/A
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrDisplayModelTestExamples.java,v 1.5 2000/04/07 04:24:18 m-asada Exp $
 */
public class IsrDisplayModelTestExamples extends IsrTestExamples {
	/**
	 * Example: 
	 */
	public static boolean Example1() {
		IsrDisplayModel model = new IsrDisplayModel();
		model.visual_("Visual");
		model.open();
		return true;
	}
	/**
	 * Example: 
	 */
	public static boolean Example2() {
		IsrDisplayModel model = new IsrDisplayModel();
		model.visual_(Image1());
		model.open();
		return true;
	}
	/**
	 * 
	 * @return java.awt.Image
	 */
	protected static Image Image1() {
		int w = 100;
		int h = 100;
		int[] pixels = new int[w * h];
		int index = 0;
		for (int y = 0; y < h; y++) {
			int red = (y * 255) / (h - 1);
			for (int x = 0; x < w; x++) {
				int blue = (x * 255) / (w - 1);
				pixels[index++] = (255 << 24) | (red << 16) | blue;
			}
		}
		return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(w, h, pixels, 0, w));
	}
	/**
	 * Execute all examples.
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		new IsrDisplayModelTestExamples();
	}
}