package sra.isr.interfaces.display;

import java.awt.*;
import sra.smalltalk.*;

/**
 * IsrDisplayModel class
 * 
 * 	@author:        nisinaka
 * 	@created:       1998/11/16 (by nisinaka)
 * 	@updated:       1999/11/11 (by MATSUDA Ryouichi)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrDisplayModel.java,v 1.5 2000/04/07 04:24:18 m-asada Exp $
 */
public class IsrDisplayModel extends StApplicationModel {
	private Object displayObject;
	/**
	 * Answer a default view.
	 * @return sra.smalltalk.StView
	 */
	public StView defaultView() {
		IsrDisplayView aView;
		if (GetDefaultViewMode() == VIEW_AWT) {
			aView = new IsrDisplayViewAwt();
		} else {
			aView = (IsrDisplayView) CreateView("sra.isr.interfaces.display.IsrDisplayViewSwing");
		}
		aView.model_(this);
		aView.adjustSize();
		return aView;
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return sra.isr.interfaces.display.IsrDisplayModel
	 * @param anObject java.lang.Object
	 * @param aString java.lang.String
	 */
	public static IsrDisplayModel OpenVisual_label_(Object anObject, String aString) {
		IsrDisplayModel model = new IsrDisplayModel();
		model.visual_(anObject);
		Frame window = model.open();
		window.setTitle(aString);
		return model;
	}
	/**
	 * Answer the visual.
	 * @return java.lang.Object
	 */
	public Object visual() {
		if (displayObject == null) {
			displayObject = "";
		}
		return displayObject;
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return sra.jun.goodies.display.JunDisplayModel
	 * @param anObject java.lang.Object
	 */
	public static IsrDisplayModel Visual_(Object anObject) {
		IsrDisplayModel model = new IsrDisplayModel();
		model.visual_(anObject);
		return model;
	}
	/**
	 * Set the visual.
	 * @param java.lang.Object
	 */
	public void visual_(Object anObject) {
		if (displayObject != anObject) {
			displayObject = anObject;
			changed_($("visual"));
		}
	}
}