package sra.isr.interfaces.cursors;

import java.awt.*;
import java.awt.image.*;

/**
 * IsrCursors class
 * 
 * 	@author:        MATSUDA Ryouichi
 * 	@created:       1998/11/24 (by MATSUDA Ryouichi)
 * 	@updated:       1999/08/04 (by nisinaka)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrCursors.java,v 1.4 2000/04/07 04:24:18 m-asada Exp $
 */
public class IsrCursors extends Object {
	static Image ArrowCursor;
	static Image BetweenCursor;
	static Image BrushCursor;
	static Image BullCursor;
	static Image CameraCursor;
	static Image ClockCursor;
	static Image CrossCursor;
	static Image DollyCursor;
	static Image EpilogueCursor;
	static Image EraserCursor;
	static Image FilmCursor;
	static Image FrameCursor;
	static Image GaugeCursor;
	static Image GlassCursor;
	static Image GoCursor;
	static Image HandCursor;
	static Image JuiceCursor;
	static Image LassoCursor;
	static Image NextCursor;
	static Image NormalCursor;
	static Image PaintCursor;
	static Image PauseCursor;
	static Image PencilCursor;
	static Image PlayCursor;
	static Image PreviousCursor;
	static Image PrologueCursor;
	static Image QuartersCursor;
	static Image ReadCursor;
	static Image RepeatCursor;
	static Image RoundtripCursor;
	static Image ScissorsCursor;
	static Image SpeakerCursor;
	static Image SpuitCursor;
	static Image StopCursor;

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return java.awt.Image
	 * @param imageString java.lang.String
	 * @param maskString java.lang.String
	 */
	private static Image _DecodeImageString_maskString(String imageString, String maskString) {
		int[] imagePixels = new int[256];
		int imagePixel, maskPixel, pixel;
		
		for (int i = 0; i < 256; i++) {
			imagePixel = Integer.parseInt(imageString.substring(i, i + 1), 2);
			maskPixel = Integer.parseInt(maskString.substring(i, i + 1), 2);
			if (imagePixel != 0) {
				pixel = Color.black.getRGB();
			} else if (maskPixel != 0) {
				pixel = Color.white.getRGB();
			} else {
				pixel = 0x000000;
			}
			imagePixels[i] = pixel;
		};
		return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, imagePixels, 0, 16));
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image ArrowCursor() {
		if (ArrowCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000010000"+
				"0000000000011000"+
				"0011111111111100"+
				"0000000000011000"+
				"0000000000010000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000";
			String maskString =
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000010000"+
				"0000000000111000"+
				"0011111111111100"+
				"0111111111111110"+
				"0011111111111100"+
				"0000000000111000"+
				"0000000000010000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000";
			ArrowCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return ArrowCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image BetweenCursor() {
		if (BetweenCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000100000010000"+
				"0001100000011000"+
				"0011111111111100"+
				"0001100000011000"+
				"0000100000010000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000";
			String maskString =
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000100000010000"+
				"0001110000111000"+
				"0011111111111100"+
				"0111111111111110"+
				"0011111111111100"+
				"0001110000111000"+
				"0000100000010000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000";
			BetweenCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return BetweenCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image BrushCursor() {
		if (BrushCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000001001000"+
				"0000000001001000"+
				"0000000010010000"+
				"0000000010010000"+
				"0000000100100000"+
				"0000000100100000"+
				"0000001111000000"+
				"0000010011000000"+
				"0000100011000000"+
				"0000100111000000"+
				"0001001110000000"+
				"0001011100000000"+
				"0010111000000000"+
				"0111100000000000"+
				"0000000000000000";
			String maskString =
				"0000000001001000"+
				"0000000011111100"+
				"0000000011111100"+
				"0000000111111000"+
				"0000000111111000"+
				"0000001111110000"+
				"0000001111110000"+
				"0000011111100000"+
				"0000111111100000"+
				"0001111111100000"+
				"0001111111100000"+
				"0011111111000000"+
				"0011111110000000"+
				"0111111100000000"+
				"1111111000000000"+
				"0111100000000000";
			BrushCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return BrushCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image BullCursor() {
		if (BullCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000011111000000"+
				"0001100100110000"+
				"0010000100001000"+
				"0100000100000100"+
				"0100000100000100"+
				"1000000100000010"+
				"1000000100000010"+
				"1111111111111110"+
				"1000000100000010"+
				"1000000100000010"+
				"0100000100000100"+
				"0100000100000100"+
				"0010000100001000"+
				"0001100100110000"+
				"0000011111000000";
			String maskString =
				"0000000000000000"+
				"0000111111100000"+
				"0011111111111000"+
				"0111001110011100"+
				"1110001110001110"+
				"1110001110001110"+
				"1100001110000110"+
				"1111111111111110"+
				"1111111111111110"+
				"1111111111111110"+
				"1100001110000110"+
				"1110001110001110"+
				"1110001110001110"+
				"0111001110011100"+
				"0011111111111000"+
				"0000111111100000";
			BullCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return BullCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image CameraCursor() {
		if (CameraCursor == null) {
			String imageString =
				"0000000000000000"+
				"0011100000000000"+
				"0010100000111100"+
				"0111111111111110"+
				"0100000000000010"+
				"0100001111000010"+
				"0100011001100010"+
				"0100110000110010"+
				"0100100000010010"+
				"0100100001010010"+
				"0100110010110010"+
				"0100011001100010"+
				"0100001111000010"+
				"0100000000000010"+
				"0111111111111110"+
				"0000000000000000";
			String maskString =
				"0011100000000000"+
				"0111110000111100"+
				"0111111111111110"+
				"1111111111111111"+
				"1111111111111111"+
				"1111111111111111"+
				"1111111111111111"+
				"1111111111111111"+
				"1111111111111111"+
				"1111111111111111"+
				"1111111111111111"+
				"1111111111111111"+
				"1111111111111111"+
				"1111111111111111"+
				"1111111111111111"+
				"0111111111111110";
			CameraCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return CameraCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image ClockCursor() {
		if (ClockCursor == null) {
			String imageString =
				"0011111100000000"+
				"0011111100000000"+
				"0011111100000000"+
				"0011111100000000"+
				"0100000010000000"+
				"1000010001000000"+
				"1000010001000000"+
				"1000010001100000"+
				"1001110001100000"+
				"1000000001000000"+
				"1000000001000000"+
				"0100000010000000"+
				"0011111100000000"+
				"0011111100000000"+
				"0011111100000000"+
				"0011111100000000";
			String maskString =
				"0011111100000000"+
				"0011111100000000"+
				"0011111100000000"+
				"0011111100000000"+
				"0111111110000000"+
				"1111111111000000"+
				"1111111111000000"+
				"1111111111100000"+
				"1111111111100000"+
				"1111111111000000"+
				"1111111111000000"+
				"0111111110000000"+
				"0011111100000000"+
				"0011111100000000"+
				"0011111100000000"+
				"0011111100000000";
			ClockCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return ClockCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image CrossCursor() {
		if (CrossCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000100000000"+
				"0000000100000000"+
				"0000000100000000"+
				"0000000100000000"+
				"0000000100000000"+
				"0000000000000000"+
				"0111110001111110"+
				"0000000000000000"+
				"0000000100000000"+
				"0000000100000000"+
				"0000000100000000"+
				"0000000100000000"+
				"0000000100000000"+
				"0000000000000000"+
				"0000000000000000";
			String maskString =
				"0000000100000000"+
				"0000001110000000"+
				"0000001110000000"+
				"0000001110000000"+
				"0000001110000000"+
				"0000001110000000"+
				"0111111011111110"+
				"1111110001111111"+
				"0111111011111110"+
				"0000001110000000"+
				"0000001110000000"+
				"0000001110000000"+
				"0000001110000000"+
				"0000001110000000"+
				"0000000100000000"+
				"0000000000000000";
			CrossCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return CrossCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image DollyCursor() {
		if (DollyCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000011000000"+
				"0000000001000000"+
				"0000000001000000"+
				"0000001101000000"+
				"0000010011000000"+
				"0000010001000000"+
				"0000010001000000"+
				"0000010001000000"+
				"0000001111100000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000";
			String maskString =
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000011000000"+
				"0000000111100000"+
				"0000000011100000"+
				"0000001111100000"+
				"0000011111100000"+
				"0000111111100000"+
				"0000111011100000"+
				"0000111011100000"+
				"0000111111100000"+
				"0000011111110000"+
				"0000001111100000"+
				"0000000000000000"+
				"0000000000000000";
			DollyCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return DollyCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image DollyCursor2() {
		if (DollyCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000011110000"+
				"0000000000110000"+
				"0000000000110000"+
				"0000111100110000"+
				"0011000011110000"+
				"0011000000110000"+
				"0011000000110000"+
				"0011000000110000"+
				"0000111111111100"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000";
			String maskString =
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000011110000"+
				"0000001111111100"+
				"0000000011111100"+
				"0000111111111100"+
				"0011111111111100"+
				"1111111111111100"+
				"1111110011111100"+
				"1111110011111100"+
				"1111111111111100"+
				"0011111111111111"+
				"0000111111111100"+
				"0000000000000000"+
				"0000000000000000";
			DollyCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return DollyCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image EpilogueCursor() {
		if (EpilogueCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000000000000"+
				"0001100000011000"+
				"0001110000011000"+
				"0001111000011000"+
				"0001101100011000"+
				"0001100110011000"+
				"0001100011011000"+
				"0001100011011000"+
				"0001100110011000"+
				"0001101100011000"+
				"0001111000011000"+
				"0001110000011000"+
				"0001100000011000"+
				"0000000000000000"+
				"0000000000000000";
			String maskString =
				"0000000000000000"+
				"0001100000011000"+
				"0011110000111100"+
				"0011111000111100"+
				"0011111100111100"+
				"0011111110111100"+
				"0011111111111100"+
				"0011110111111100"+
				"0011110111111100"+
				"0011111111111100"+
				"0011111110111100"+
				"0011111100111100"+
				"0011111000111100"+
				"0011110000111100"+
				"0001100000011000"+
				"0000000000000000";
			EpilogueCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return EpilogueCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image EraserCursor() {
		if (EraserCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000111111110"+
				"0000001000000110"+
				"0000010000001010"+
				"0000100000010010"+
				"0001000000100100"+
				"0010000001001000"+
				"0111111110010000"+
				"0100000010100000"+
				"0100000011000000"+
				"0111111110000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000";
			String maskString =
				"0000000000000000"+
				"0000000000000000"+
				"0000000111111110"+
				"0000001111111111"+
				"0000011111111111"+
				"0000111111111111"+
				"0001111111111111"+
				"0011111111111110"+
				"0111111111111100"+
				"1111111111111000"+
				"1111111111110000"+
				"1111111111100000"+
				"1111111111000000"+
				"0111111110000000"+
				"0000000000000000"+
				"0000000000000000";
			EraserCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return EraserCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image FilmCursor() {
		if (FilmCursor == null) {
			String imageString =
				"0000000000000000"+
				"0111000000001110"+
				"0111000000001110"+
				"0101111111111010"+
				"0111000000001110"+
				"0111000000001110"+
				"0101000000001010"+
				"0111000000001110"+
				"0111000000001110"+
				"0101000000001010"+
				"0111000000001110"+
				"0111000000001110"+
				"0101111111111010"+
				"0111000000001110"+
				"0111000000001110"+
				"0000000000000000";
			String maskString =
				"0111000000001110"+
				"1111100000011111"+
				"1111111111111111"+
				"1111111111111111"+
				"1111111111111111"+
				"1111111111111111"+
				"1111111111111111"+
				"1111111111111111"+
				"1111111111111111"+
				"1111111111111111"+
				"1111111111111111"+
				"1111111111111111"+
				"1111111111111111"+
				"1111111111111111"+
				"1111100000011111"+
				"0111000000001110";
			FilmCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return FilmCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image FrameCursor() {
		if (FrameCursor == null) {
			String imageString =
				"0000000000000000"+
				"0111100111001110"+
				"0100000000000010"+
				"0100000000000010"+
				"0000000000000010"+
				"0000000000000000"+
				"0100000000000000"+
				"0100000000000010"+
				"0100000000000010"+
				"0000000000000010"+
				"0000000000000000"+
				"0100000000000000"+
				"0100000000000010"+
				"0100000000000010"+
				"0111001110011110"+
				"0000000000000000";
			String maskString =
				"0111100111001110"+
				"1111111111111111"+
				"1111100111001111"+
				"1110000000000111"+
				"0100000000000111"+
				"0100000000000010"+
				"1110000000000010"+
				"1110000000000111"+
				"1110000000000111"+
				"0100000000000111"+
				"0100000000000010"+
				"1110000000000010"+
				"1110000000000111"+
				"1111001110011111"+
				"1111111111111111"+
				"0111001110011110";
			FrameCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return FrameCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image GaugeCursor() {
		if (GaugeCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000000000000"+
				"0001111011111000"+
				"0000000010001000"+
				"0000011010001000"+
				"0000000010001000"+
				"0000011010001000"+
				"0000000010001000"+
				"0000111010001000"+
				"0000000010001000"+
				"0000011011111000"+
				"0000000011111000"+
				"0000011011111000"+
				"0000000011111000"+
				"0001111011111000"+
				"0000000000000000";
			String maskString =
				"0000000000000000"+
				"0001111011111000"+
				"0011111111111100"+
				"0001111111111100"+
				"0000111111111100"+
				"0000011111111100"+
				"0000111111111100"+
				"0000111111111100"+
				"0001111111111100"+
				"0000111111111100"+
				"0000111111111100"+
				"0000011111111100"+
				"0000111111111100"+
				"0001111111111100"+
				"0011111111111100"+
				"0001111011111000";
			GaugeCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return GaugeCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image GlassCursor() {
		if (GlassCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000111100000000"+
				"0011000011000000"+
				"0010000001000000"+
				"0100000000100000"+
				"0100000000100000"+
				"0100000000100000"+
				"0100000000100000"+
				"0010000001000000"+
				"0011000011100000"+
				"0000111101110000"+
				"0000000000111000"+
				"0000000000011100"+
				"0000000000001110"+
				"0000000000000110"+
				"0000000000000000";
			String maskString =
				"0000111100000000"+
				"0011111111000000"+
				"0111111111100000"+
				"0111000011100000"+
				"1110000001110000"+
				"1110000001110000"+
				"1110000001110000"+
				"1110000001110000"+
				"0111000011100000"+
				"0111111111110000"+
				"0011111111111000"+
				"0000111101111100"+
				"0000000000111110"+
				"0000000000011111"+
				"0000000000001111"+
				"0000000000000110";
			GlassCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return GlassCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image GoCursor() {
		if (GoCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0001110000111000"+
				"0010001001000100"+
				"0010000001000100"+
				"0010000001000100"+
				"0010011101000100"+
				"0010001001000100"+
				"0010001001000100"+
				"0001110000111000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000";
			String maskString =
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0001110000111000"+
				"0011111001111100"+
				"0111111111111110"+
				"0111001011101110"+
				"0111011111101110"+
				"0111111111101110"+
				"0111011111101110"+
				"0111111111111110"+
				"0011111001111100"+
				"0001110000111000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000";
			GoCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return GoCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image HandCursor() {
		if (HandCursor == null) {
			String imageString =
				"0000000110000000"+
				"0001101001110000"+
				"0010011001001000"+
				"0010011001001010"+
				"0001001001001101"+
				"0001001001001001"+
				"0110100000001001"+
				"1001100000000001"+
				"1000100000000010"+
				"0100000000000010"+
				"0010000000000010"+
				"0010000000000100"+
				"0001000000000100"+
				"0000100000001000"+
				"0000010000001000"+
				"0000010000001000";
			String maskString =
				"0000000110000000"+
				"0001101111110000"+
				"0011111111111000"+
				"0011111111111010"+
				"0001111111111111"+
				"0001111111111111"+
				"0110111111111111"+
				"1111111111111111"+
				"1111111111111110"+
				"0111111111111110"+
				"0011111111111110"+
				"0011111111111100"+
				"0001111111111100"+
				"0000111111111000"+
				"0000011111111000"+
				"0000011111111000";
			HandCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return HandCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image JuiceCursor() {
		if (JuiceCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000100000000"+
				"0000000100000000"+
				"0000001010000000"+
				"0000001010000000"+
				"0000010001000000"+
				"0000100000100000"+
				"0000100000100000"+
				"0001000000010000"+
				"0001000000010000"+
				"0001000000010000"+
				"0001000000010000"+
				"0000100000100000"+
				"0000010001000000"+
				"0000001110000000"+
				"0000000000000000";
			String maskString =
				"0000000100000000"+
				"0000001110000000"+
				"0000001110000000"+
				"0000011111000000"+
				"0000011111000000"+
				"0000111011100000"+
				"0001110001110000"+
				"0001110001110000"+
				"0011100000111000"+
				"0011100000111000"+
				"0011100000111000"+
				"0011100000111000"+
				"0001110001110000"+
				"0000111111100000"+
				"0000011111000000"+
				"0000001110000000";
			JuiceCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return JuiceCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image LassoCursor() {
		if (LassoCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000111110000"+
				"0000111000001100"+
				"0001000000000010"+
				"0010000000000010"+
				"0100000000000010"+
				"0100000000001100"+
				"0100000000110000"+
				"0011100011000000"+
				"0110011100000000"+
				"0101010000000000"+
				"0011100000000000"+
				"0000100000000000"+
				"0000100000000000"+
				"0001000000000000"+
				"0000000000000000";
			String maskString =
				"0000000111110000"+
				"0000111111111100"+
				"0001111111111110"+
				"0011111000001111"+
				"0111000000000111"+
				"1110000000001111"+
				"1110000000111110"+
				"1111100011111100"+
				"0111111111110000"+
				"1111111111000000"+
				"1111111100000000"+
				"0111110000000000"+
				"0011110000000000"+
				"0001110000000000"+
				"0011100000000000"+
				"0001000000000000";
			LassoCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return LassoCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image NextCursor() {
		if (NextCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000000000000"+
				"0001001100000000"+
				"0001001110000000"+
				"0001001111000000"+
				"0001001101100000"+
				"0001001100110000"+
				"0001001100011000"+
				"0001001100011000"+
				"0001001100110000"+
				"0001001101100000"+
				"0001001111000000"+
				"0001001110000000"+
				"0001001100000000"+
				"0000000000000000"+
				"0000000000000000";
			String maskString =
				"0000000000000000"+
				"0001001100000000"+
				"0011111110000000"+
				"0011111111000000"+
				"0011111111100000"+
				"0011111111110000"+
				"0011111111111000"+
				"0011111110111100"+
				"0011111110111100"+
				"0011111111111000"+
				"0011111111110000"+
				"0011111111100000"+
				"0011111111000000"+
				"0011111110000000"+
				"0001001100000000"+
				"0000000000000000";
			NextCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return NextCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image NormalCursor() {
		if (NormalCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000010000000000"+
				"0000011000000000"+
				"0000011100000000"+
				"0000011110000000"+
				"0000011111000000"+
				"0000011111100000"+
				"0000011111110000"+
				"0000011111000000"+
				"0000011111000000"+
				"0000010011000000"+
				"0000000001100000"+
				"0000000001100000"+
				"0000000000110000"+
				"0000000000110000"+
				"0000000000000000)";
			String maskString =
				"0000110000000000"+
				"0000111000000000"+
				"0000111100000000"+
				"0000111110000000"+
				"0000111111000000"+
				"0000111111100000"+
				"0000111111110000"+
				"0000111111111000"+
				"0000111111100000"+
				"0000111111100000"+
				"0000111111100000"+
				"0000100011110000"+
				"0000000011110000"+
				"0000000001111000"+
				"0000000001111000"+
				"0000000000110000";
			NormalCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return NormalCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image PaintCursor() {
		if (PaintCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000011100000000"+
				"0000100110000000"+
				"0000101011000000"+
				"0000110010110000"+
				"0000100010011100"+
				"0001000010001110"+
				"0010000101000110"+
				"0100000010000110"+
				"0100000000001110"+
				"0010000000010110"+
				"0001000000100110"+
				"0000100001000110"+
				"0000010010000110"+
				"0000001100000100"+
				"0000000000000000";
			String maskString =
				"0000011100000000"+
				"0000111110000000"+
				"0001111111000000"+
				"0001111111110000"+
				"0001111111111100"+
				"0001111111111110"+
				"0011111111111111"+
				"0111111111111111"+
				"1111111111111111"+
				"1111111111111111"+
				"0111111111111111"+
				"0011111111111111"+
				"0001111111101111"+
				"0000111111001111"+
				"0000011110001110"+
				"0000001100000100";
			PaintCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return PaintCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image PauseCursor() {
		if (PauseCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000110000110000"+
				"0000110000110000"+
				"0000110000110000"+
				"0000110000110000"+
				"0000110000110000"+
				"0000110000110000"+
				"0000110000110000"+
				"0000110000110000"+
				"0000110000110000"+
				"0000110000110000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000";
			String maskString =
				"0000000000000000"+
				"0000000000000000"+
				"0000110000110000"+
				"0001111001111000"+
				"0001111001111000"+
				"0001111001111000"+
				"0001111001111000"+
				"0001111001111000"+
				"0001111001111000"+
				"0001111001111000"+
				"0001111001111000"+
				"0001111001111000"+
				"0001111001111000"+
				"0000110000110000"+
				"0000000000000000"+
				"0000000000000000";
			PauseCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return PauseCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image PencilCursor() {
		if (PencilCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000111100000"+
				"0000000100010000"+
				"0000001000010000"+
				"0000011100100000"+
				"0000010011100000"+
				"0000100001000000"+
				"0000100010000000"+
				"0001000010000000"+
				"0001000100000000"+
				"0001100100000000"+
				"0001111000000000"+
				"0001110000000000"+
				"0001100000000000"+
				"0001000000000000"+
				"0000000000000000";
			String maskString =
				"0000000111100000"+
				"0000001111110000"+
				"0000001111111000"+
				"0000011111111000"+
				"0000111111110000"+
				"0000111111110000"+
				"0001111111100000"+
				"0001111111000000"+
				"0011111111000000"+
				"0011111110000000"+
				"0011111110000000"+
				"0011111100000000"+
				"0011111000000000"+
				"0011110000000000"+
				"0011100000000000"+
				"0001000000000000";
			PencilCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return PencilCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image PlayCursor() {
		if (PlayCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000000000000"+
				"0000011000000000"+
				"0000011100000000"+
				"0000011110000000"+
				"0000011011000000"+
				"0000011001100000"+
				"0000011000110000"+
				"0000011000110000"+
				"0000011001100000"+
				"0000011011000000"+
				"0000011110000000"+
				"0000011100000000"+
				"0000011000000000"+
				"0000000000000000"+
				"0000000000000000";
			String maskString =
				"0000000000000000"+
				"0000011000000000"+
				"0000111100000000"+
				"0000111110000000"+
				"0000111111000000"+
				"0000111111100000"+
				"0000111111110000"+
				"0000111101111000"+
				"0000111101111000"+
				"0000111111110000"+
				"0000111111100000"+
				"0000111111000000"+
				"0000111110000000"+
				"0000111100000000"+
				"0000011000000000"+
				"0000000000000000";
			PlayCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return PlayCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image PreviousCursor() {
		if (PreviousCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000000000000"+
				"0000000011001000"+
				"0000000111001000"+
				"0000001111001000"+
				"0000011011001000"+
				"0000110011001000"+
				"0001100011001000"+
				"0001100011001000"+
				"0000110011001000"+
				"0000011011001000"+
				"0000001111001000"+
				"0000000111001000"+
				"0000000011001000"+
				"0000000000000000"+
				"0000000000000000";
			String maskString =
				"0000000000000000"+
				"0000000011001000"+
				"0000000111111100"+
				"0000001111111100"+
				"0000011111111100"+
				"0000111111111100"+
				"0001111111111100"+
				"0011110111111100"+
				"0011110111111100"+
				"0001111111111100"+
				"0000111111111100"+
				"0000011111111100"+
				"0000001111111100"+
				"0000000111111100"+
				"0000000011001000"+
				"0000000000000000";
			PreviousCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return PreviousCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image PrologueCursor() {
		if (PrologueCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000000000000"+
				"0001100000011000"+
				"0001100000111000"+
				"0001100001111000"+
				"0001100011011000"+
				"0001100110011000"+
				"0001101100011000"+
				"0001101100011000"+
				"0001100110011000"+
				"0001100011011000"+
				"0001100001111000"+
				"0001100000111000"+
				"0001100000011000"+
				"0000000000000000"+
				"0000000000000000";
			String maskString =
				"0000000000000000"+
				"0001100000011000"+
				"0011110000111100"+
				"0011110001111100"+
				"0011110011111100"+
				"0011110111111100"+
				"0011111111111100"+
				"0011111110111100"+
				"0011111110111100"+
				"0011111111111100"+
				"0011110111111100"+
				"0011110011111100"+
				"0011110001111100"+
				"0011110000111100"+
				"0001100000011000"+
				"0000000000000000";
			PrologueCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return PrologueCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image QuartersCursor() {
		if (QuartersCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000100000000"+
				"0000001110000000"+
				"0000000100000000"+
				"0000000100000000"+
				"0000000100000000"+
				"0010000000000100"+
				"0111110001111110"+
				"0010000000000100"+
				"0000000100000000"+
				"0000000100000000"+
				"0000000100000000"+
				"0000001110000000"+
				"0000000100000000"+
				"0000000000000000"+
				"0000000000000000";
			String maskString =
				"0000000100000000"+
				"0000001110000000"+
				"0000011111000000"+
				"0000001110000000"+
				"0000001110000000"+
				"0010001110000100"+
				"0111111011111110"+
				"1111110001111111"+
				"0111111011111110"+
				"0010001110000100"+
				"0000001110000000"+
				"0000001110000000"+
				"0000011111000000"+
				"0000001110000000"+
				"0000000100000000"+
				"0000000000000000";
			QuartersCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return QuartersCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image ReadCursor() {
		if (ReadCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000110000000110"+
				"0001001000001001"+
				"0001001000001001"+
				"0010000000010000"+
				"0100000000100000"+
				"1111101111100000"+
				"1000010000100000"+
				"1000010000100000"+
				"1011010110100000"+
				"0111101111000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000";
			String maskString =
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0001000000001000"+
				"0010010000010010"+
				"0010010000010010"+
				"0100000000100000"+
				"1000000001000000"+
				"0000000000000000"+
				"0111101111000000"+
				"0111101111000000"+
				"0100101001000000"+
				"0000010000000000"+
				"0111101111000000"+
				"0000000000000000"+
				"0000000000000000";
			ReadCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return ReadCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image RepeatCursor() {
		if (RepeatCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000100000000"+
				"0000000110000000"+
				"0001111111111000"+
				"0011000110001100"+
				"0010000100000100"+
				"0010000000000100"+
				"0011000000001100"+
				"0001111111111000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000";
			String maskString =
				"0000000000000000"+
				"0000000000000000"+
				"0000000100000000"+
				"0000001110000000"+
				"0001111111111000"+
				"0011111111111100"+
				"0111111111111110"+
				"0111001110001110"+
				"0111000100001110"+
				"0111111111111110"+
				"0011111111111100"+
				"0001111111111000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000";
			RepeatCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return RepeatCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image RoundtripCursor() {
		if (RoundtripCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000010000"+
				"0000000000011000"+
				"0011111111111100"+
				"0000000000011000"+
				"0000000000010000"+
				"0000100000000000"+
				"0001100000000000"+
				"0011111111111100"+
				"0001100000000000"+
				"0000100000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000";
			String maskString =
				"0000000000000000"+
				"0000000000000000"+
				"0000000000010000"+
				"0000000000111000"+
				"0011111111111100"+
				"0111111111111110"+
				"0011111111111100"+
				"0000100000111000"+
				"0001110000010000"+
				"0011111111111100"+
				"0111111111111110"+
				"0011111111111100"+
				"0001110000000000"+
				"0000100000000000"+
				"0000000000000000"+
				"0000000000000000";
			RoundtripCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return RoundtripCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image ScissorsCursor() {
		if (ScissorsCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000001010000000"+
				"0000011011000000"+
				"0000011011000000"+
				"0000011011000000"+
				"0000011011000000"+
				"0000001010000000"+
				"0000001110000000"+
				"0000001010000000"+
				"0000001110000000"+
				"0000011011000000"+
				"0000101010100000"+
				"0001001010010000"+
				"0001001010010000"+
				"0000111011100000"+
				"0000000000000000";
			String maskString =
				"0000001010000000"+
				"0000011111000000"+
				"0000111111100000"+
				"0000111111100000"+
				"0000111111100000"+
				"0000111111100000"+
				"0000011111000000"+
				"0000011111000000"+
				"0000011111000000"+
				"0000011111000000"+
				"0000111111100000"+
				"0001111111110000"+
				"0011111111111000"+
				"0011111111111000"+
				"0001111111110000"+
				"0000111011100000";
			ScissorsCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return ScissorsCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image SpeakerCursor() {
		if (SpeakerCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000100000000"+
				"0000001100010000"+
				"0000010100001000"+
				"0000100100000100"+
				"0001000100100100"+
				"0110000100100100"+
				"0100000100010010"+
				"0100000100010010"+
				"0110000100100100"+
				"0001000100100100"+
				"0000100100000100"+
				"0000010100001000"+
				"0000001100010000"+
				"0000000100000000"+
				"0000000000000000";
			String maskString =
				"0000000100000000"+
				"0000001110010000"+
				"0000011110111000"+
				"0000111110011100"+
				"0001111110101110"+
				"0111111111111110"+
				"1111111111111110"+
				"1111111110111111"+
				"1111111110111111"+
				"1111111111111110"+
				"0111111111111110"+
				"0001111110101110"+
				"0000111110011100"+
				"0000011110111000"+
				"0000001110010000"+
				"0000000100000000";
			SpeakerCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return SpeakerCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image SpuitCursor() {
		if (SpuitCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000000011100"+
				"0000000000111110"+
				"0000000000111110"+
				"0000000111111110"+
				"0000000011111100"+
				"0000000101110000"+
				"0000001000110000"+
				"0000010001010000"+
				"0000100010000000"+
				"0001000100000000"+
				"0010001000000000"+
				"0010010000000000"+
				"0101100000000000"+
				"0010000000000000"+
				"0000000000000000";
			String maskString =
				"0000000000011100"+
				"0000000000111110"+
				"0000000001111111"+
				"0000011111111111"+
				"0000001111111111"+
				"0000000111111110"+
				"0000001111111100"+
				"0000011111111000"+
				"0000111111111000"+
				"0001111111011000"+
				"0011111110001000"+
				"0111111100000000"+
				"0111111000000000"+
				"1101110000000000"+
				"0111100000000000"+
				"0010000000000000";
			SpuitCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return SpuitCursor;
	}
	/**
	 * 
	 * StImage generated from Smalltalk monochrome image.
	 * @return java.awt.Image
	 */
	public final static Image StopCursor() {
		if (StopCursor == null) {
			String imageString =
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000111111110000"+
				"0000111111110000"+
				"0000110000110000"+
				"0000110000110000"+
				"0000110000110000"+
				"0000110000110000"+
				"0000110000110000"+
				"0000110000110000"+
				"0000111111110000"+
				"0000111111110000"+
				"0000000000000000"+
				"0000000000000000"+
				"0000000000000000";
			String maskString =
				"0000000000000000"+
				"0000000000000000"+
				"0000111111110000"+
				"0001111111111000"+
				"0001111111111000"+
				"0001111111111000"+
				"0001111001111000"+
				"0001111001111000"+
				"0001111001111000"+
				"0001111001111000"+
				"0001111111111000"+
				"0001111111111000"+
				"0001111111111000"+
				"0000111111110000"+
				"0000000000000000"+
				"0000000000000000";
			StopCursor = _DecodeImageString_maskString(imageString, maskString);
		}
		return StopCursor;
	}
}
