package sra.isr.interfaces.colors;

import java.awt.*;
import java.awt.image.*;
import sra.smalltalk.*;
import sra.isr.geometry.basic.*;

/**
 * IsrColorChoiceViewAwt class
 * 
 * 	@author:        Hirotsugu Kondo
 * 	@created:       1998/11/05 (by Hirotsugu Kondo)
 * 	@updated:       1999/08/31 (by m-asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrColorChoiceViewAwt.java,v 1.6 2000/04/07 04:24:18 m-asada Exp $
 */
public class IsrColorChoiceViewAwt extends StViewCanvas implements IsrColorChoiceView {
	protected IsrColorChoiceController controller;
	//
	protected final static Color _VeryLightGrayColor = new Color(212, 212, 212);
	/**
	 * @return java.awt.Rectangle
	 */
	public Rectangle barArea() {
		int originX = this.plateArea().x + this.plateArea().width + 16;
		int originY = this.plateArea().y;
		Rectangle area = ((IsrColorChoiceModel) this.model())._barArea();
		Rectangle box = new Rectangle(originX,originY,area.width,area.height);
		return box;
	}
	/**
	 * return model's brightness(but rounded).
	 * @return double
	 */
	private double brightness() {
		int roundedValue = ((int) (((IsrColorChoiceModel) this.model()).brightness() / this.round()));
		return roundedValue * this.round();
	}
	/**
	 * @return java.awt.Rectangle
	 */
	public Rectangle brightnessArea() {
		int originX = this.saturationArea().x;
		int originY = this.saturationArea().y + this.saturationArea().height + 3;
		Rectangle box = new Rectangle(originX, originY, 56, 18);
		return box;
	}
	/**
	 * @return string
	 */
	public String brightnessString() {
		double value = this.brightness();
		String string = "" + value;
		if (string.length() < 4) {
			for (int i = string.length(); i < 4; i++) {
				string = string.concat("0");
			}
			return string;
		} else {
			return string.substring(0, 4);
		}
	}
	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		this.setSize(230, 125);
		//
		controller = this.defaultController();
		controller.view_(this);
	}
	/**
	 * @return java.awt.Rectangle
	 */
	private Rectangle colorArea() {
		int originX = this.barArea().x + this.barArea().width + 16;
		int originY = this.barArea().y;
		Rectangle box = new Rectangle(originX, originY, 56, 30);
		return box;
	}
	/**
	 * Answer a default controller.
	 *
	 * @return sra.smalltalk.StController
	 */
	protected IsrColorChoiceController defaultController() {
		return new IsrColorChoiceController();
	}
	/**
	 * Answer a default model.
	 *
	 * @return sra.smalltalk.StModel
	 */
	protected StModel defaultModel() {
		return new IsrColorChoiceHSB();
	}
	/**
	 * @param graphics java.awt.Graphics
	 */
	private void displayBarOn_(Graphics aGraphics) {
		Graphics graphics = aGraphics.create();
		Rectangle box = this.barArea();
		this.getModel().bar().displayOn_at_(graphics,box.getLocation());
		graphics.setColor(Color.black);
		graphics.drawRect(box.x, box.y, box.width, box.height);
	}
	/**
	 * @param graphics java.awt.Graphics
	 */
	private void displayBrightnessOn_(Graphics aGraphics) {
		Graphics graphics = aGraphics.create();
		Rectangle box = this.brightnessArea();
		String text = "B:".concat(this.brightnessString());
		FontMetrics fontMetrics = graphics.getFontMetrics();
		int width = fontMetrics.stringWidth(text);
		int height = fontMetrics.getHeight();
		Point stringOrigin = new Point((box.width - width) / 2 + box.x, (box.height - height / 2 + box.y));
		graphics.clipRect(box.x, box.y, box.width + 1, box.height + 1);
		graphics.setColor(_VeryLightGrayColor);
		graphics.fillRect(box.x, box.y, box.width, box.height);
		graphics.setColor(Color.black);
		graphics.drawString(text, stringOrigin.x, stringOrigin.y);
		graphics.drawRect(box.x, box.y, box.width, box.height);
	}
	/**
	 * @param graphics java.awt.Graphics
	 */
	private void displayColorOn_(Graphics aGraphics) {
		Graphics graphics = aGraphics.create();
		Rectangle box = this.colorArea();
		graphics.setColor(this.getModel().color());
		graphics.fillRect(box.x, box.y, box.width, box.height);
		graphics.setColor(Color.black);
		graphics.drawRect(box.x, box.y, box.width, box.height);
	}
	/**
	 * @param graphics java.awt.Graphics
	 */
	private void displayHueOn_(Graphics aGraphics) {
		Graphics graphics = aGraphics.create();
		Rectangle box = this.hueArea();
		String text = "H:".concat(this.hueString());
		FontMetrics fontMetrics = graphics.getFontMetrics();
		int width = fontMetrics.stringWidth(text);
		int height = fontMetrics.getHeight();
		Point stringOrigin = new Point((box.width - width) / 2 + box.x, (box.height - height / 2 + box.y));
		graphics.clipRect(box.x, box.y, box.width + 1, box.height + 1);
		graphics.setColor(_VeryLightGrayColor);
		graphics.fillRect(box.x, box.y, box.width, box.height);
		graphics.setColor(Color.black);
		graphics.drawString(text, stringOrigin.x, stringOrigin.y);
		graphics.drawRect(box.x, box.y, box.width, box.height);
	}
	/**
	 * Update the view.
	 *
	 * @param aGraphics java.awt.Graphics
	 */
	public void displayOn_(Graphics aGraphics) {
		if (!this.isShowing()) {
			return;
		};
		this.displayPlateOn_(aGraphics);
		this.displayXYOn_(aGraphics);
		this.displayBarOn_(aGraphics);
		this.displayZOn_(aGraphics);
		this.displayColorOn_(aGraphics);
		this.displayHueOn_(aGraphics);
		this.displaySaturationOn_(aGraphics);
		this.displayBrightnessOn_(aGraphics);
	}
	/**
	 * @param graphics java.awt.Graphics
	 */
	private void displayPlateOn_(Graphics aGraphics) {
		Graphics graphics = aGraphics.create();
		Rectangle box = this.plateArea();
		this.getModel().plate().displayOn_at_(graphics,box.getLocation());
		graphics.setColor(Color.black);
		graphics.drawRect(box.x, box.y, box.width, box.height);
	}
	/**
	 * @param graphics java.awt.Graphics
	 */
	private void displaySaturationOn_(Graphics aGraphics) {
		Graphics graphics = aGraphics.create();
		Rectangle box = this.saturationArea();
		String text = "S:".concat(this.saturationString());
		FontMetrics fontMetrics = graphics.getFontMetrics();
		int width = fontMetrics.stringWidth(text);
		int height = fontMetrics.getHeight();
		Point stringOrigin = new Point((box.width - width) / 2 + box.x, (box.height - height / 2 + box.y));
		graphics.clipRect(box.x, box.y, box.width + 1, box.height + 1);
		graphics.setColor(_VeryLightGrayColor);
		graphics.fillRect(box.x, box.y, box.width, box.height);
		graphics.setColor(Color.black);
		graphics.drawString(text, stringOrigin.x, stringOrigin.y);
		graphics.drawRect(box.x, box.y, box.width, box.height);
	}
	/**
	 * @param graphics java.awt.Graphics
	 */
	private void displayXYOn_(Graphics aGraphics) {
		Graphics graphics = aGraphics.create();
		Rectangle box = this.plateArea();
		graphics.clipRect(box.x, box.y, box.width, box.height);
		int x = ((int) (this.getModel().xy().x() * (box.width - 1) + box.x));
		int y = ((int) (this.getModel().xy().y() * (box.height - 1) + box.y));
		Color white = Color.white;
		Color black = Color.black;
		graphics.setColor(white);
		for (int angle = 0; angle < 360; angle = angle + 15) {
			graphics.drawArc(x - 4, y - 4, 8, 8, angle, 15);
			if (black.equals(graphics.getColor())) {
				graphics.setColor(white);
			} else {
				graphics.setColor(black);
			};
		}
	}
	/**
	 * @param graphics java.awt.Graphics
	 */
	private void displayZOn_(Graphics aGraphics) {
		Graphics graphics = aGraphics.create();
		Rectangle box = this.barArea();
		Rectangle boxL = new Rectangle(box.x - 4, box.y - 3, 4, box.height + 7);
		Rectangle boxR = new Rectangle(box.x + box.width + 1, box.y - 3, 4, box.height + 7);
		graphics.setColor(this.getBackground());
		graphics.fillRect(boxL.x, boxL.y, boxL.width, boxL.height);
		graphics.fillRect(boxR.x, boxR.y, boxR.width, boxR.height);
		Point[] points = new Point[4];
		points[0] = new Point(0, 0);
		points[1] = new Point(3, -3);
		points[2] = new Point(3, 3);
		points[3] = new Point(0, 0);
		int height = ((int) (this.getModel().z() * (box.height - 1)));
		Point offsetR = new Point(box.x + box.width + 1, height + box.y);
		Point offsetL = new Point(box.x - 1, height + box.y);
		int[] xLs = new int[4];
		int[] yLs = new int[4];
		int[] xRs = new int[4];
		int[] yRs = new int[4];
		for (int i = 0; i < 4; i++) {
			xRs[i] = offsetR.x + points[i].x;
			yRs[i] = offsetR.y + points[i].y;
			xLs[i] = offsetL.x - points[i].x;
			yLs[i] = offsetL.y + points[i].y;
		};
		graphics.setColor(Color.black);
		graphics.drawPolyline(xRs, yRs, 4);
		graphics.drawPolyline(xLs, yLs, 4);
	}
	/**
	 * model property accessing.
	 *
	 * @return sra.isr.interfaces.colors.IsrColorChoiceModel
	 */
	public IsrColorChoiceModel getModel() {
		return (IsrColorChoiceModel) this.model();
	}
	/**
	 * return model's hue(but rounded).
	 * @return double
	 */
	private double hue() {
		int roundedValue = ((int) (((IsrColorChoiceModel) this.model()).hue() / this.round()));
		return roundedValue * this.round();
	}
	/**
	 * @return java.awt.Rectangle
	 */
	public Rectangle hueArea() {
		int originX = this.colorArea().x;
		int originY = this.colorArea().y + this.colorArea().height + 10;
		Rectangle box = new Rectangle(originX, originY, 56, 18);
		return box;
	}
	/**
	 * @return string
	 */
	public String hueString() {
		double value = this.hue();
		String string = "" + value;
		if (string.length() < 4) {
			for (int i = string.length(); i < 4; i++) {
				string = string.concat("0");
			}
			return string;
		} else {
			return string.substring(0, 4);
		}
	}
	/**
	 * @return java.awt.Rectangle
	 */
	public Rectangle plateArea() {
		Rectangle area = ((IsrColorChoiceModel) this.model())._plateArea();
		Rectangle box = new Rectangle(10, 10, area.width, area.height);
		return box;
	}
	/**
	 * return display round unit.
	 * @return double
	 */
	private double round() {
		return 0.01;
	}
	/**
	 * return model's saturation(but rounded).
	 * @return double
	 */
	private double saturation() {
		int roundedValue = ((int) (((IsrColorChoiceModel) this.model()).saturation() / this.round()));
		return roundedValue * this.round();
	}
	/**
	 * @return java.awt.Rectangle
	 */
	public Rectangle saturationArea() {
		int originX = this.hueArea().x;
		int originY = this.hueArea().y + this.hueArea().height + 3;
		Rectangle box = new Rectangle(originX, originY, 56, 18);
		return box;
	}
	/**
	 * @return string
	 */
	public String saturationString() {
		double value = this.saturation();
		String string = "" + value;
		if (string.length() < 4) {
			for (int i = string.length(); i < 4; i++) {
				string = string.concat("0");
			}
			return string;
		} else {
			return string.substring(0, 4);
		}
	}
	/**
	 * model property accessing.
	 *
	 * @param aModel sra.isr.interfaces.colors.IsrColorChoiceModel
	 */
	public void setModel(IsrColorChoiceModel aModel) {
		this.model_(aModel);
	}
	/**
	 * Action for the update notification.
	 *
	 * @param evt sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		if (!this.isShowing()) {
			return;
		}
		if (evt.getAspect() == $("xy")) {
			Graphics gc = this.getGraphics();
			this.displayPlateOn_(gc);
			this.displayXYOn_(gc);
			this.displayBarOn_(gc);
			this.displayColorOn_(gc);
			this.displayHueOn_(gc);
			this.displaySaturationOn_(gc);
			this.displayBrightnessOn_(gc);
			gc.dispose();
		}
		if (evt.getAspect() == $("z")) {
			Graphics gc = this.getGraphics();
			this.displayPlateOn_(gc);
			this.displayXYOn_(gc);
			this.displayBarOn_(gc);
			this.displayZOn_(gc);
			this.displayColorOn_(gc);
			this.displayHueOn_(gc);
			this.displaySaturationOn_(gc);
			this.displayBrightnessOn_(gc);
			gc.dispose();
		}
		if (evt.getAspect() == $("color")) {
			Graphics gc = this.getGraphics();
			this.displayOn_(gc);
			gc.dispose();
		}
	}
}