package sra.isr.interfaces.colors;

import java.awt.*;
import sra.smalltalk.*;
import sra.isr.system.support.*;

/**
 * IsrColorChoiceTestExamples class
 * 
 * 	@author:        Hirotsugu Kondo
 * 	@created:       1998/11/05 (by Hirotsugu Kondo)
 * 	@updated:       1999/08/31 (by m-asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrColorChoiceTestExamples.java,v 1.5 2000/04/07 04:24:18 m-asada Exp $
 */
public class IsrColorChoiceTestExamples extends IsrTestExamples {
	/**
	 * Example: open HBS color model window
	 */
	public static boolean Example1() {
		IsrColorChoiceHBS colorChoice;
		colorChoice = new IsrColorChoiceHBS();
		colorChoice.open();
		return true;
	}
	/**
	 * Example: open HSB color model window
	 */
	public static boolean Example2() {
		IsrColorChoiceHSB colorChoice;
		colorChoice = new IsrColorChoiceHSB();
		colorChoice.open();
		return true;
	}
	/**
	 * Example: open SBH color model window
	 */
	public static boolean Example3() {
		IsrColorChoiceSBH colorChoice;
		colorChoice = new IsrColorChoiceSBH();
		colorChoice.open();
		return true;
	}
	/**
	 * Example: open HBS color modal dialog
	 */
	public static boolean Example4() {
		Color result = IsrColorChoiceHBS.Request_(Color.green);
		System.out.println(result);
		return true;
	}
	/**
	 * Example: open HSB color modal dialog
	 */
	public static boolean Example5() {
		Color result = IsrColorChoiceHSB.Request_(Color.green);
		System.out.println(result);
		return true;
	}
	/**
	 * Example: open SBH color modal dialog
	 */
	public static boolean Example6() {
		Color result = IsrColorChoiceSBH.Request_(Color.green);
		System.out.println(result);
		return true;
	}
	/**
	 * Execute all examples.
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		new IsrColorChoiceTestExamples();
	}
}
