package sra.isr.interfaces.colors;

import java.awt.*;
import java.util.*;
import sra.smalltalk.*;
import sra.isr.geometry.basic.*;

/**
 * IsrColorChoiceModel class
 * 
 * 	@author:        Hirotsugu Kondo
 * 	@created:       1998/11/5 (by Hirotsugu Kondo)
 * 	@updated:       N/A
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrColorChoiceModel.java,v 1.8 2000/04/07 04:24:18 m-asada Exp $
 */
public abstract class IsrColorChoiceModel extends StApplicationModel {
	private Isr2dPoint xy = new Isr2dPoint(0,0);
	private double z = 0;
	private boolean accepted = false;
	/**
	 * Constructor.
	 */
	public IsrColorChoiceModel() {
		super();
		this.color_(Color.white);
	}
	/**
	 * @return Rectangle
	 */
	public static Rectangle _barArea() {
		int width = 16;
		int height = _Intervals();
		return new Rectangle(0, 0, width, height);
	}
	/**
	 * gap is a color grid size.
	 * @return int
	 */
	protected static int _Gap() {
		return 2;
	}
	/**
	 * intervals is a color plate width and height.
	 * @return int
	 */
	protected static int _Intervals() {
		return 100;
	}
	/**
	 * defines OK/Cancel dialog buttons.
	 * @return Panel
	 */
	public Panel _okCancelButtons(final Dialog target) {
		Panel panel = new Panel();
		final IsrColorChoiceModel this_ = this;
		panel.add("West", new Button("OK") {
			public boolean action(Event ev, Object what) {
				this_.accept();
				target.dispose();
				return true;
			}
		});
		panel.add("East", new Button("Cancel") {
			public boolean action(Event ev, Object what) {
				this_.cancel();
				target.dispose();
				return true;
			}
		});
		return panel;
	}
	/**
	 * @return Rectangle
	 */
	public static Rectangle _plateArea() {
		int width = _Intervals();
		int height = _Intervals();
		return new Rectangle(0, 0, width, height);
	}
	/**
	 * Create the Dialog for IsrColorChoiceModel with initial value.
	 * @return java.awt.Color or null
	 */
	public static Color _Request_(Color colorValue, IsrColorChoiceModel model) {
		Dialog dialog;
		Frame parent = new Frame();
		IsrColorChoiceView view = (IsrColorChoiceView) model.defaultView();
		view.setModel(model);
		model.color_(colorValue);
		Color result = null;
		dialog = new Dialog(parent, "Color Choice", true);
		dialog.setResizable(false);
		((Component)view).setBounds(0, 0, 230, 125);
		dialog.add("Center", (Component) view);
		dialog.add("South", model._okCancelButtons(dialog));
		dialog.pack();
		try {
			Thread.sleep(0);
		} catch (Exception e) {
		}
		dialog.pack();
		model.changed();
		dialog.show();
		if (model.accepted) {
			result = model.color();
		}
		return result;
	}
	/**
	 * accept button pressed action(in dialog mode)
	 */
	public void accept() {
		this.accepted = true;
	}
	/**
	 * return current selected bar.
	 * @return sra.smalltalk.StImage
	 */
	public StImage bar() {
		StImage[] thisBars = this.bars();
		int index = ((int) (this.xy.x() * (thisBars.length - 1)));
		StImage value = thisBars[index];
		return value; 
	}
	/**
	 * @return sra.smalltalk.StColorValue[]
	 */
	protected abstract StImage[] bars();
	/**
	 * @return double
	 */
	public abstract double brightness();
	/**
	 * @param double
	 */
	public abstract void brightness_(double value);
	/**
	 * accept button pressed action(in dialog mode). do nothing.
	 */
	public void cancel() {
	}
	/**
	 * @return java.awt.Color
	 */
	public Color color() {
		Color color = Color.getHSBColor((float) this.hue(), (float) this.saturation(), (float) this.brightness());
		return color;
	}
	/**
	 * receives Color and mapping this.
	 * @param color java.awt.Color
	 */
	public abstract void color_(Color color);
	/**
	 * Answer a BlockValue that computes aBlock with the receiver's value 
	 * as the argument. aBlock will become a dependent of the receiver,
	 * and will be sent the message value: when the receiver is sent the
	 * message value:.
	 * 
	 * @return sra.smalltalk.StBlockValue
	 * @param aBlock sra.smalltalk.StBlockClosure
	 */
	public StBlockValue compute_(StBlockClosure aBlock) {
		StObject[] aArray = {this};
		return StBlockValue.Block_arguments_(aBlock, aArray);
	}
	/**
	 * Return the names of all the constant color
	 *
	 * @return java.util.Vector
	 */
	public static Vector ConstantNames() {
		Vector colorNames = new Vector();
		colorNames.addElement($("black"));
		colorNames.addElement($("blue"));
		colorNames.addElement($("brown"));
		colorNames.addElement($("chartreuse"));
		colorNames.addElement($("cyan"));
		colorNames.addElement($("darkCyan"));
		colorNames.addElement($("darkGray"));
		colorNames.addElement($("darkGreen"));
		colorNames.addElement($("darkMagenta"));
		colorNames.addElement($("darkRed"));
		colorNames.addElement($("olive"));
		colorNames.addElement($("gray"));
		colorNames.addElement($("green"));
		colorNames.addElement($("lightYellow"));
		colorNames.addElement($("lightGray"));
		colorNames.addElement($("magenta"));
		colorNames.addElement($("navy"));
		colorNames.addElement($("orange"));
		colorNames.addElement($("orchid"));
		colorNames.addElement($("paleGreen"));
		colorNames.addElement($("pink"));
		colorNames.addElement($("purple"));
		colorNames.addElement($("red"));
		colorNames.addElement($("royalBlue"));
		colorNames.addElement($("salmon"));
		colorNames.addElement($("lightCyan"));
		colorNames.addElement($("springGreen"));
		colorNames.addElement($("veryDarkGray"));
		colorNames.addElement($("veryLightGray"));
		colorNames.addElement($("white"));
		colorNames.addElement($("yellow"));
		return colorNames;
	}
	/**
	 * Answer a default view.
	 * @return sra.smalltalk.StView
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new IsrColorChoiceViewAwt();
		} else {
			return this.CreateView("sra.isr.interfaces.colors.IsrColorChoiceViewSwing");
		}
	}
	/**
	 * @return double
	 */
	public abstract double hue();
	/**
	 * @param double
	 */
	public abstract void hue_(double value);
	/**
	 * return current selected plate.
	 * @return sra.smalltalk.StImage[]
	 */
	public StImage plate() {
		StImage[] thisPlates = this.plates();
		int index = ((int) ((this.z * (thisPlates.length - 1))));
		StImage value = thisPlates[index];
		return value;
	}
	/**
	 * @return sra.smalltalk.StImage[]
	 */
	public abstract StImage[] plates();
	/**
	 * @return double
	 */
	public abstract double saturation();
	/**
	 * @param double
	 */
	public abstract void saturation_(double value);
	/**
	 * @return Isr2dPoint
	 */
	public Isr2dPoint xy() {
		return xy;
	}
	/**
	 * @param aPoint Isr2dPoint
	 */
	public void xy_(Isr2dPoint aPoint) {
		xy = aPoint;
		this.changed_($("xy"));
	}
	/**
	 * @return double
	 */
	public double z() {
		return z;
	}
	/**
	 * @param aDouble double
	 */
	public void z_(double aDouble) {
		z = aDouble;
		this.changed_($("z"));
	}
}
