package sra.isr.interfaces.colors;

import java.awt.*;
import sra.smalltalk.*;
import sra.isr.geometry.basic.*;

/**
 * IsrColorChoiceHBS class
 * 
 * 	@author:        Hirotsugu Kondo
 * 	@created:       1998/11/05 (by Hirotsugu Kondo)
 * 	@updated:       1999/08/31 (by m-asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrColorChoiceHBS.java,v 1.4 2000/04/07 04:24:18 m-asada Exp $
 */
public class IsrColorChoiceHBS extends IsrColorChoiceModel {
	private static StImage[] plates;
	private static StImage[] bars;
	
	static {
		plates = _InitializePlates();
		bars = _InitializeBars();
	}
	/**
	 * @return java.lang.reflect.Array of StImage
	 */
	static StImage[] _InitializeBars() {
		int gap = _Gap();
		int interval = _Intervals();
		int ySize = interval / gap;
		int zSize = interval / gap;
		int width = _barArea().width;
		StImage[] images = new StImage[zSize];
		for (int z = 0; z < zSize; z++) {
			int[] pixels = new int[interval * width];
			for (int y = 0; y < ySize; y++) {
				double hue = z * 1.0 / zSize;
				double saturation = 1 - (y * 1.0 / ySize);
				double brightness = 1.0;
				Color color = Color.getHSBColor((float) hue, (float) saturation, (float) brightness);
				for (int dy = 0; dy < gap; dy++) {
					for (int dx = 0; dx < width; dx++) {
						pixels[ (y * gap + dy) * width + dx] = color.getRGB();
					}
				}
			}
			images[z] = new StImage(width, interval, pixels);
		}
		return images;
	}
	/**
	 * @return java.lang.reflect.Array of StImage
	 */
	static StImage[] _InitializePlates() {
		int gap = _Gap();
		int interval = _Intervals();
		int xSize = interval / gap;
		int ySize = interval / gap;
		int zSize = interval / gap;
		StImage[] images = new StImage[zSize];
		for (int z = 0; z < zSize; z++) {
			int[] pixels = new int[interval * interval];
			for (int y = 0; y < ySize; y++) {
				for (int x = 0; x < xSize; x++) {
					double hue = x * 1.0 / xSize;
					double saturation = 1 - (z * 1.0 / zSize);
					double brightness = 1 - (y * 1.0 / ySize);
					Color color = Color.getHSBColor((float) hue, (float) saturation, (float) brightness);
					for (int dy = 0; dy < gap; dy++) {
						for (int dx = 0; dx < gap; dx++) {
							pixels[ (y * gap + dy) * interval + x * gap + dx] = color.getRGB();
						}
					}
				}
			}
			images[z] = new StImage(interval, interval, pixels);
		}
		return images;
	}
	/**
	 * @return sra.smalltalk.StImage[]
	 */
	public StImage[] bars() {
		StImage[] images = this.bars;
		return images;
	}
	/**
	 * @return double
	 */
	public double brightness() {
		double value = 1 -  this.xy().y();
		return value;
	}
	/**
	 * @param double
	 */
	public void brightness_(double value) {
		this.xy_(new Isr2dPoint(this.xy().x(), (1 - value)));
	}
	/**
	 * receives Color and mapping this.
	 * @param color java.awt.Color
	 */
	public void color_(Color color) {
		this.z_(1 - (StColorValue._GetSaturation(color)));
		this.xy_(new Isr2dPoint(StColorValue._GetHue(color), (1 - (StColorValue._GetBrightness(color)))));
		this.changed_($("color"));
	}
	/**
	 * @return double
	 */
	public double hue() {
		double value = this.xy().x();
		return value;
	}
	/**
	 * @param double
	 */
	public void hue_(double value) {
		this.xy_(new Isr2dPoint(value,this.xy().y()));
	}
	/**
	 * @return sra.smalltalk.StImage[]
	 */
	public StImage[] plates() {
		StImage[] images = this.plates;
		return images;
	}
	/**
	 * Create the Dialog for JunColorChoiceModel.
	 * @return java.awt.Color or null
	 */
	public static Color Request() {
		return Request_(Color.white);
	}
	/**
	 * Create the Dialog for JunColorChoiceModel with initial value.
	 * @return java.awt.Color or null
	 */
	public static Color Request_(Color colorValue) {
		return _Request_(colorValue, new IsrColorChoiceHBS());
	}
	/**
	 * @return double
	 */
	public double saturation() {
		double value = 1 - this.z();
		return value;
	}
	/**
	 * @param double
	 */
	public void saturation_(double value) {
		this.z_(1 - value);
	}
}