package sra.isr.interfaces.colors;

import java.awt.*;
import java.awt.event.*;
import sra.smalltalk.*;
import sra.isr.geometry.basic.*;

/**
 * IsrColorChoiceController class
 * 
 * 	@author:        Hirotsugu Kondo
 * 	@created:       1998/11/05 (by Hirotsugu Kondo)
 * 	@updated:       1999/08/31 (by m-asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrColorChoiceController.java,v 1.6 2000/04/07 04:24:18 m-asada Exp $
 */
public class IsrColorChoiceController extends StController implements MouseListener, MouseMotionListener {
	/**
	 * add listeners.
	 * @param aView sra.mvctest.StView
	 */
	protected void buildListener(StView newView) {
		Component aView = (Component) newView;
		aView.addMouseListener(this);
		aView.addMouseMotionListener(this);
	}
	/**
	 * Invoked when the mouse button has been moved.
	 * @param e java.awt.event.MouseEvent 
	 */
	public void mouseDragged(MouseEvent event) {
		Point point = event.getPoint();
		IsrColorChoiceView view = ((IsrColorChoiceView) this.view());
		if ((view.plateArea().contains(point)) || (view.barArea().contains(point))) {
			this.mousePressed(event);
		}
	}
	/**
	 * Tempolary cursor set method. Not called now.
	 */
	public void mouseMoved(MouseEvent event) {
		Point point = event.getPoint();
		IsrColorChoiceView view = ((IsrColorChoiceView) this.view());
		if ((view.plateArea().contains(point)) || (view.barArea().contains(point)) || (view.hueArea().contains(point)) || (view.saturationArea().contains(point)) || (view.brightnessArea().contains(point))) {
			((Component) view).setCursor(Cursor.getPredefinedCursor(Cursor.CROSSHAIR_CURSOR));
		} else {
			((Component) view).setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
		}
	}
	/**
	 * Invoked when a mouse button has been pressed. 
	 * press button to set color.
	 * @param event java.awt.event.MouseEvent
	 */
	public void mousePressed(MouseEvent event) {
		if (this.isMenuButtonPressed_(event)) {
			return;
		}
		Point point = event.getPoint();
		IsrColorChoiceView view = ((IsrColorChoiceView) this.view());
		Point globalOrigin = event.getComponent().getParent().getLocation();
		if (view.plateArea().contains(point)) {
			double x = ((double) (point.x - view.plateArea().getLocation().x)) / (view.plateArea().width - 1.0);
			double y = ((double) (point.y - view.plateArea().getLocation().y)) / (view.plateArea().height - 1.0);
			Isr2dPoint jPoint = new Isr2dPoint(x, y);
			((IsrColorChoiceModel) this.model()).xy_(jPoint);
		}
		if (view.barArea().contains(point)) {
			double z = ((double) (point.y - view.barArea().getLocation().y)) / (view.barArea().height - 1.0);
			((IsrColorChoiceModel) this.model()).z_(z);
		}
		if (view.hueArea().contains(point)) {
			String result = StDialog.Request_("hue?", view.hueString(), new Point(globalOrigin.x + point.x, globalOrigin.y + point.y));
			if (result != null) {
				double resultValue = new Double(result).doubleValue();
				if ((resultValue >= 0.0) && (resultValue <= 1.0)) {
					((IsrColorChoiceModel) this.model()).hue_(resultValue);
				}
			}
		}
		if (view.saturationArea().contains(point)) {
			String result = StDialog.Request_("saturation?", view.saturationString(), new Point(globalOrigin.x + point.x, globalOrigin.y + point.y));
			if (result != null) {
				double resultValue = new Double(result).doubleValue();
				if ((resultValue >= 0.0) && (resultValue <= 1.0)) {
					((IsrColorChoiceModel) this.model()).saturation_(resultValue);
				}
			}
		}
		if (view.brightnessArea().contains(point)) {
			String result = StDialog.Request_("brightness?", view.brightnessString(), new Point(globalOrigin.x + point.x, globalOrigin.y + point.y));
			if (result != null) {
				double resultValue = new Double(result).doubleValue();
				if ((resultValue >= 0.0) && (resultValue <= 1.0)) {
					((IsrColorChoiceModel) this.model()).brightness_(resultValue);
				}
			}
		}
		return;
	}
}