package sra.isr.interfaces.button;

import java.awt.*;
import java.awt.event.*;
import sra.smalltalk.*;

/**
 * IsrButtonViewAwt class
 * 
 * 	@author:        He Weijie
 * 	@created:       1998/08/27 (by He Weijie)
 * 	@updated:       1999/11/12 (by MATSUDA Ryouichi)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrButtonViewAwt.java,v 1.5 2000/04/07 04:24:18 m-asada Exp $
 */
public class IsrButtonViewAwt extends StViewCanvas implements IsrButtonView {
	protected IsrButtonController controller;
	/**
	 * Display a string on a graphics at a center.
	 *
	 * @param aString java.lang.String
	 * @param aGraphics java.awt.Graphics
	 */
	protected void _displayObject_on_(Object anObject, Graphics aGraphics) {
		if (anObject instanceof Image) {
			Image anImage = (Image) anObject;
			int width = anImage.getWidth(null);
			int height = anImage.getHeight(null);
			int x = (this.getSize().width - width) / 2;
			int y = (this.getSize().height - height) / 2;
			aGraphics.drawImage(anImage, x, y, null);
		} else {
			String aString;
			if (anObject instanceof String) {
				aString = (String) anObject;
			} else {
				aString = anObject.toString();
			}
			FontMetrics fontMetrics = aGraphics.getFontMetrics();
			int width = fontMetrics.stringWidth(aString);
			int height = fontMetrics.getAscent();
			int x = (this.getSize().width - width) / 2;
			int y = (this.getSize().height + height) / 2;
			aGraphics.setColor(Color.black);
			aGraphics.drawString(aString, x, y);
		}
	}
	/**
	 * Answer the preferred size of the object.
	 *
	 * @return java.awt.Dimension
	 * @param anObject java.lang.Object
	 */
	protected Dimension _getPreferredSizeOf(Object anObject) {
		if (anObject instanceof Image) {
			Image anImage = (Image) anObject;
			return new Dimension(anImage.getWidth(null), anImage.getHeight(null));
		} else {
			String aString;
			if (anObject instanceof String) {
				aString = (String) anObject;
			} else {
				aString = anObject.toString();
			}
			Point extent = SystemResourceSupport._getStringExtentFor_(aString, null);
			return new Dimension(extent.x, extent.y);
		}
	}
	/**
	 * Adjust size.
	 */
	public void adjustSize() {
		this.setSize(this._getPreferredSizeOf(getModel().visual()));
	}
	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		// controller
		controller = this.defaultController();
		controller.view_(this);
	}
	/**
	 * Answer a default model.
	 *
	 * @return sra.smalltalk.StModel
	 */
	protected IsrButtonController defaultController() {
		return new IsrButtonController();
	}
	/**
	 * Answer a default model.
	 *
	 * @return sra.smalltalk.StModel
	 */
	protected StModel defaultModel() {
		IsrButtonModel aModel = new IsrButtonModel();
		aModel.visual_("IsrButtonModel");
		return aModel;
	}
	/**
	 * Update the view when the value of the model is false.
	 *
	 * @param aGraphics java.awt.Graphics
	 */
	public void displayFalseOn_(Graphics aGraphics) {
		Rectangle box = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
		aGraphics.clipRect(box.x, box.y, box.width, box.height);
		aGraphics.setColor(new Color((float) 0.7, (float) 0.7, (float) 0.7));
		aGraphics.fillRect(box.x, box.y, box.width, box.height);
		Object displayObject = this.getModel().visual();
		this._displayObject_on_(displayObject, aGraphics);
		aGraphics.setColor(new Color((float) 0.8, (float) 0.8, (float) 0.8));
		aGraphics.drawLine(box.x, box.y, box.x + box.width - 1, box.y);
		aGraphics.drawLine(box.x, box.y, box.x, box.y + box.height - 1);
		aGraphics.setColor(new Color((float) 0.2, (float) 0.2, (float) 0.2));
		aGraphics.drawLine(box.x, box.y + box.height - 1, box.x + box.width - 1, box.y + box.height - 1);
		aGraphics.drawLine(box.x + box.width - 1, box.y, box.x + box.width - 1, box.y + box.height - 1);
	}
	/**
	 * paint. 
	 *
	 * @param aGraphics java.awt.Graphics
	 */
	public void displayOn_(Graphics aGraphics) {
		if (this.getModel().value() == true) {
			this.displayTrueOn_(aGraphics);
		} else {
			this.displayFalseOn_(aGraphics);
		}
	}
	/**
	 * Update the view when the value of the model is true.
	 *
	 * @param aGraphics java.awt.Graphics
	 */
	public void displayTrueOn_(Graphics aGraphics) {
		Rectangle box = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
		aGraphics.clipRect(box.x, box.y, box.width, box.height);
		aGraphics.setColor(new Color((float) 0.3, (float) 0.3, (float) 0.3));
		aGraphics.fillRect(box.x, box.y, box.width, box.height);
		Object displayObject = this.getModel().visual();
		this._displayObject_on_(displayObject, aGraphics);
		aGraphics.setColor(new Color((float) 0.2, (float) 0.2, (float) 0.2));
		aGraphics.drawLine(box.x, box.y, box.x + box.width - 1, box.y);
		aGraphics.drawLine(box.x, box.y, box.x, box.y + box.height - 1);
		aGraphics.setColor(new Color((float) 0.8, (float) 0.8, (float) 0.8));
		aGraphics.drawLine(box.x, box.y + box.height - 1, box.x + box.width - 1, box.y + box.height - 1);
		aGraphics.drawLine(box.x + box.width - 1, box.y, box.x + box.width - 1, box.y + box.height - 1);
	}
	/**
	 * model property accessing.
	 *
	 * @return sra.isr.interfaces.button.IsrButtonModel
	 */
	public IsrButtonModel getModel() {
		return (IsrButtonModel) this.model();
	}
	/**
	 * value property accessing.
	 *
	 * @return boolean
	 */
	public boolean getValue() {
		return this.getModel().value();
	}
	/**
	 * visual property accessing.
	 *
	 * @return java.lang.Object
	 */
	public Object getVisual() {
		return this.getModel().visual();
	}
	/**
	 * model property accessing.
	 *
	 * @param aModel sra.isr.interfeces.button.IsrButtonModel
	 */
	public void setModel(IsrButtonModel aModel) {
		model_(aModel);
	}
	/**
	 * value property accessing.
	 *
	 * @param aValue boolean
	 */
	public void setValue(boolean aValue) {
		this.getModel().value_(aValue);
	}
	/**
	 * visual property accessing.
	 *
	 * @param anObject java.lang.Object
	 */
	public void setVisual(Object anObject) {
		this.getModel().visual_(anObject);
	}
	/*
	 * Update
	 * @param evt sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		if (evt.getAspect() == $("value")) {
			this.repaint();
			this.firePropertyChange("value", null, new Boolean(this.getValue()));
		} else if (evt.getAspect() == $("visual")) {
			this.repaint();
			this.firePropertyChange("visual", null, this.getVisual());
		} else {
			super.update_(evt);
		}
	}
}