package sra.isr.interfaces.button;

import java.awt.*;
import java.awt.image.*;
import sra.smalltalk.*;
import sra.isr.system.support.*;

/**
 * IsrButtonModelTestExamples class
 * 
 * 	@author:        nisinaka
 * 	@created:       1998/10/xx (by nisinaka)
 * 	@updated:       N/A
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrButtonModelTestExamples.java,v 1.6 2000/04/07 04:24:18 m-asada Exp $
 */
public class IsrButtonModelTestExamples extends IsrTestExamples {
	/**
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		IsrButtonModel buttonModel;
		StBlockClosure action = new StBlockClosure() {
			public Object value_(Object o) {
				IsrButtonModel model = (IsrButtonModel) o;
				model.value_(!model.value());
				return model;
			}
		};
		Object displayObject = "Test";
		buttonModel = new IsrButtonModel();
		buttonModel.value_(false);
		buttonModel.visual_(displayObject);
		buttonModel.action_(action);
		buttonModel.open();
		return true;
	}
	/**
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		IsrButtonModel buttonModel;
		StBlockClosure action = new StBlockClosure() {
			public Object value_(Object o) {
				IsrButtonModel model = (IsrButtonModel) o;
				model.value_(!model.value());
				return model;
			}
		};
		buttonModel = new IsrButtonModel();
		buttonModel.value_(false);
		buttonModel.visual_(Image1());
		buttonModel.action_(action);
		buttonModel.open();
		return true;
	}
	/**
	 * 
	 * @return java.awt.Image
	 */
	protected static Image Image1() {
		int w = 100;
		int h = 100;
		int[] pixels = new int[w * h];
		int index = 0;
		for (int y = 0; y < h; y++) {
			int red = (y * 255) / (h - 1);
			for (int x = 0; x < w; x++) {
				int blue = (x * 255) / (w - 1);
				pixels[index++] = (255 << 24) | (red << 16) | blue;
			}
		}
		return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(w, h, pixels, 0, w));
	}
	/**
	 * Execute all examples.
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		new IsrButtonModelTestExamples();
	}
}