package sra.isr.interfaces.button;

import java.awt.*;
import sra.smalltalk.*;

/**
 * IsrButtonModel class
 * 
 * 	@author:        He Weijie
 * 	@created:       1998/08/13 (by He Weijie)
 * 	@updated:       1999/11/12 (by MATSUDA Ryouichi)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrButtonModel.java,v 1.5 2000/04/07 04:24:18 m-asada Exp $
 */
public class IsrButtonModel extends StApplicationModel {
	/**
	 * A boolean value as a button model.
	 */
	protected boolean buttonValue;

	/**
	 * An object which will be displayed on an associated view.
	 */
	protected Object displayObject;

	/**
	 * An action which will be evaluated when a button is pressed.
	 */
	protected StBlockClosure buttonAction;

	/**
	 * A flag to allow a repeat action or not.
	 */
	protected boolean repeatAction;

	/**
	 * A boolean value as a check button.
	 */
	protected boolean checkButton;
	/**
	 * Return the current button action.
	 * If not assigned, create a fake action and return it.
	 *
	 * @return sra.smalltalk.StBlockClosure
	 */
	public StBlockClosure action() {
		return buttonAction;
	}
	/**
	 * Set the action.
	 * @param aBlock sra.smalltalk.StBlockClosure
	 */
	public void action_(StBlockClosure aBlock) {
		buttonAction = aBlock;
	}
	/**
	 * Answer a default view.
	 * @return sra.smalltalk.StView
	 */
	public StView defaultView() {
		IsrButtonView aView;
		if (GetDefaultViewMode() == VIEW_AWT) {
			aView = new IsrButtonViewAwt();
		} else {
			aView = (IsrButtonView) CreateView("sra.isr.interfaces.button.IsrButtonViewSwing");
		}
		aView.model_(this);
		aView.adjustSize();
		return aView;
	}
	/**
	 * Just return the repeatAction.
	 * @return boolean
	 */
	public boolean repeatAction() {
		return repeatAction;
	}
	/**
	 * Set the repeatAction.
	 * @param aBoolean boolean
	 */
	public void repeatAction_(boolean aBoolean) {
		repeatAction = aBoolean;
	}
	/**
	 * Just return the current button value.
	 * @return boolean
	 */
	public boolean value() {
		return buttonValue;
	}
	/**
	 * Set the new button value.
	 * If the value is changed, announce it.
	 *
	 * @param aBoolean boolean
	 */
	public void value_(boolean aBoolean) {
		if (aBoolean != buttonValue) {
			buttonValue = aBoolean;
			this.changed_($("value"));
		}
	}
	/**
	 * Create a new instance of JunButtonModel.
	 *
	 * @return sra.jun.goodies.button.JunButtonModel
	 * @param aClass java.lang.Class
	 * @param aBoolean boolean
	 * @param anImage java.awt.Image
	 * @param aBlock sra.smalltalk.StBlockClosure
	 */
	public static IsrButtonModel Value_visual_action_(Class aClass, boolean aBoolean, Image anImage, StBlockClosure aBlock) {
		IsrButtonModel buttonModel = (IsrButtonModel) _New(aClass);
		buttonModel.value_(aBoolean);
		buttonModel.visual_(anImage);
		buttonModel.action_(aBlock);
		return buttonModel;
	}
	/**
	 * Create a new instance of JunButtonModel.
	 *
	 * @return sra.jun.goodies.button.JunButtonModel
	 * @param aClass java.lang.Class
	 * @param aBoolean boolean
	 * @param anObject java.lang.Object
	 * @param aBlock sra.smalltalk.StBlockClosure
	 */
	public static IsrButtonModel Value_visual_action_(Class aClass, boolean aBoolean, Object anObject, StBlockClosure aBlock) {
		IsrButtonModel buttonModel = (IsrButtonModel) _New(aClass);
		buttonModel.value_(aBoolean);
		buttonModel.visual_(anObject);
		buttonModel.action_(aBlock);
		return buttonModel;
	}
	/**
	 * Create a new instance of JunButtonModel.
	 *
	 * @return sra.jun.goodies.button.JunButtonModel
	 * @param aBoolean boolean
	 * @param anImage java.awt.Image
	 * @param aBlock sra.smalltalk.StBlockClosure
	 */
	public final static IsrButtonModel Value_visual_action_(boolean aBoolean, Image anImage, StBlockClosure aBlock) {
		return Value_visual_action_(IsrButtonModel.class, aBoolean, anImage, aBlock);
	}
	/**
	 * Create a new instance of JunButtonModel.
	 *
	 * @return sra.jun.goodies.button.JunButtonModel
	 * @param aBoolean boolean
	 * @param anObject java.lang.Object
	 * @param aBlock sra.smalltalk.StBlockClosure
	 */
	public final static IsrButtonModel Value_visual_action_(boolean aBoolean, Object anObject, StBlockClosure aBlock) {
		return Value_visual_action_(IsrButtonModel.class, aBoolean, anObject, aBlock);
	}
	/**
	 * Return the current display object. If not assigned yet, set a
	 * null string as a fake display object and return it.
	 *
	 * @return java.lang.Object
	 */
	public Object visual() {
		if (displayObject == null) {
			this.visual_(new String());
		}
		return displayObject;
	}
	/**
	 * Set a string coverted from an object as a visual object.
	 * If the visual object is changed, announce it.
	 *
	 * @param anObject java.lang.Object
	 */
	public void visual_(Object anObject) {
		if (anObject != displayObject) {
			displayObject = anObject;
			this.changed_($("visual"));
		}
	}
}