package sra.isr.interfaces.button;

import java.awt.*;
import java.awt.event.*;
import sra.smalltalk.*;

/**
 * IsrButtonController class
 * 
 * 	@author:        He Weijie
 * 	@created:       1998/08/27 (by He Weijie)
 * 	@updated:       1999/11/12 (by MATSUDA Ryouichi)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrButtonController.java,v 1.5 2000/04/07 04:24:17 m-asada Exp $
 */
public class IsrButtonController extends StController implements MouseListener, Runnable {
	transient protected boolean mousePress;
	transient protected boolean mouseEnter;
	transient protected Thread repeatThread;
	/**
	 * add listeners.
	 * @param aView sra.mvctest.StView
	 */
	protected void buildListener(StView newView) {
		final Component aView = (Component) newView;
		aView.addMouseListener(this);
	}
	/**
	 * Answer this model.
	 * @return IsrButtonModel
	 */
	protected IsrButtonModel getModel() {
		return (IsrButtonModel) this.model();
	}
	/**
	 * Answer this view.
	 * @return IsrButtonView interface
	 */
	protected IsrButtonView getView() {
		return (IsrButtonView) this.view();
	}
	/**
	 * Invoked when the mouse enters.
	 *
	 * @param e java.awt.event.MouseEvent 
	 */
	public void mouseEntered(MouseEvent e) {
		final IsrButtonView view = this.getView();
		mouseEnter = true;
		if (mousePress) {
			Graphics gc = ((Component) view).getGraphics();
			view.displayTrueOn_(gc);
			gc.setColor(Color.black);
			Dimension size = ((Component) view).getSize();
			gc.drawRect(0, 0, size.width - 1, size.height - 1);
			gc.dispose();
		}
	}
	/**
	 * Invoked when the mouse exits.
	 *
	 * @param e java.awt.event.MouseEvent 
	 */
	public void mouseExited(MouseEvent e) {
		final IsrButtonView view = this.getView();
		mouseEnter = false;
		if (mousePress) {
			Graphics gc = ((Component) view).getGraphics();
			if (this.getModel().value()) {
				view.displayTrueOn_(gc);
			} else {
				view.displayFalseOn_(gc);
			}
			gc.dispose();
		}
	}
	/**
	 * Invoked when a mouse button has been pressed on a component.
	 *
	 * @param e java.awt.event.MouseEvent 
	 */
	public void mousePressed(MouseEvent e) {
		final IsrButtonView view = this.getView();
		mousePress = true;
		mouseEnter = true;
		Graphics gc = ((Component) view).getGraphics();
		view.displayTrueOn_(gc);
		gc.setColor(Color.black);
		Dimension size = ((Component) view).getSize();
		gc.drawRect(0, 0, size.width - 1, size.height - 1);
		gc.dispose();
		if (this.getModel().repeatAction()) {
			repeatThread = new Thread(this);
			repeatThread.start();
		}
	}
	/**
	 * Invoked when a mouse button has been released on a component.
	 *
	 * @param e java.awt.event.MouseEvent 
	 */
	public void mouseReleased(MouseEvent e) {
		final IsrButtonView view = this.getView();
		final IsrButtonModel model = this.getModel();
		if (mousePress) {
			Graphics gc = ((Component) view).getGraphics();
			if (model.value()) {
				view.displayTrueOn_(gc);
			} else {
				view.displayFalseOn_(gc);
			}
			gc.dispose();
			mousePress = false;
		}
		if (repeatThread != null) {
			repeatThread = null;
		}
		if (mouseEnter) {
			StBlockClosure action = model.action();
			if (action != null) {
				switch (action.numArgs()) {
					case 0:
						action.value();
						break;
					case 1:
						action.value_(model);
						break;
					case 2:
						action.value_value_(model, e);
						break;
				}
			}
			mouseEnter = false;
		}
	}
	/**
	 * Start the repeat thread.
	 */
	public void run() {
		final IsrButtonModel model = this.getModel();
		try {
			Thread.sleep(500);
		} catch (InterruptedException e) {
		};
		StBlockClosure action = model.action();
		while (mousePress) {
				switch (action.numArgs()) {
					case 0:
						action.value();
						break;
					case 1:
						action.value_(model);
						break;
					case 2:
						action.value_value_(model, null);
						break;
				}
			Thread.yield();
		}
	}
}