package sra.isr.interfaces.area;

import java.awt.*;
import java.awt.event.*;
import sra.smalltalk.*;

/**
 * IsrAreaView class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       2000/02/16 (by Mitsuhiro Asada)
 * 	@updated:       2000/03/13 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrAreaView.java,v 1.11 2000/04/07 04:24:17 m-asada Exp $
 */
public interface IsrAreaView extends StView {
	/**
	 * Display the plate using the Graphics.
	 *
	 * @param aGraphics java.awt.Graphics
	 */
	public void displayPlateOn_(Graphics aGraphics);
	/**
	 * Display the point using the Graphics.
	 *
	 * @param graphics java.awt.Graphics
	 */
	public void displayXYOn_(Graphics aGraphics);
	/**
	 * Answer a Model.
	 *
	 * @return sra.isr.interfaces.area.IsrAreaModel
	 */
	public IsrAreaModel getModel();
	/**
	 * get the plate bounds.
	 *
	 * @return java.awt.Rectangle
	 */
	public Rectangle plateArea();
	/**
	 * model property accessing.
	 *
	 * @param aModel sra.isr.interfaces.area.IsrAreaModel
	 */
	public void setModel(IsrAreaModel aModel);
}
