package sra.isr.interfaces.area;

import java.io.*;
import java.awt.*;
import sra.smalltalk.*;
import sra.isr.system.support.*;
import sra.isr.geometry.basic.*;

/**
 * IsrAreaModel class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       1999/12/21 (by Mitsuhiro Asada)
 * 	@updated:       2000/02/16 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrAreaModel.java,v 1.12 2000/04/07 04:24:17 m-asada Exp $
 */
public class IsrAreaModel extends StApplicationModel {
	protected Isr2dPoint xy;
	protected static StImage Plate = null;
	private boolean accepted = false;
	/**
	 * Construsctor
	 */
	public IsrAreaModel() {
		super();
		initialize();
	}
	/**
	 * defines OK/Cancel dialog buttons.
	 *
	 * @return Panel
	 */
	public Panel _okCancelButtons(final Dialog target) {
		Panel panel = new Panel();
		final IsrAreaModel this_ = this;
		panel.add("West", new Button("OK") {
			public boolean action(Event ev, Object what) {
				this_.accept();
				target.dispose();
				return true;
			}
		});
		panel.add("East", new Button("Cancel") {
			public boolean action(Event ev, Object what) {
				this_.cancel();
				target.dispose();
				return true;
			}
		});
		return panel;
	}
	/**
	 * accept button pressed action(in dialog mode)
	 */
	public void accept() {
		this.accepted = true;
	}
	/**
	 * Answer a view.
	 *
	 * @return sra.sMMa.interfaces.area.IsrAreaViewAwt
	 */
	public IsrAreaViewAwt areaView() {
		IsrAreaViewAwt view = new IsrAreaViewAwt();
		view.model_(this);
		return view;
	}
	/**
	 * accept button pressed action(in dialog mode). do nothing.
	 */
	public void cancel() {
	}
	/**
	 * Answer a default view.
	 *
	 * @return sra.smalltalk.StView
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new IsrAreaViewAwt();
		} else {
			return this.CreateView("sra.isr.interfaces.area.IsrAreaViewSwing");
		}
	}
	/**
	 * Initialize this object.
	 */
	public IsrAreaModel initialize() {
		this.xy();
		return this;
	}
	/**
	 * the plate image.
	 *
	 * @return sra.smalltalk.StImage
	 */
	public StImage plate() {
		return this.Plate();
	}
	/**
	 * the plate image.
	 *
	 * @return sra.smalltalk.StImage
	 */
	static StImage Plate() {
		if (Plate == null) {
			int x, y;
			Color color;
			int interval = 101;
			int width, height;
			StImage image = new StImage(interval, interval);
			width = image.width();
			height = image.height();
			color = Color.getHSBColor((float) 0.0, (float) 0.0, (float) 0.82);
			for (y = 0; y < height; y++) {
				for (x = 0; x < width; x++) {
					image.atX_y_put_(x, y, color.getRGB());
				}
			}
			color = Color.black;
			for (y = 0; y < height; y++) {
				for (x = 0; x < width; x++) {
					if ((x % 10 == 0) && (y % 10 == 0)) {
						image.atX_y_put_(x, y, color.getRGB());
						if ((x == ((width - 1) / 2)) && (y == ((height - 1) / 2))) {
							Point[] array = {new Point(-1, 0), new Point(0, 1), new Point(1, 0), new Point(0, -1)};
							for (int i = 0; i < array.length; i++) {
								image.atX_y_put_(x + array[i].x, y + array[i].y, color.getRGB());
							}
						}
					}
				}
			}
			Plate = image;
		}
		return Plate;
	}
	/**
	 * Print my string representation on aWriter.
	 * 
	 * @param aWriter java.io.Writer
	 */
	public void printOn_(Writer aWriter) throws IOException {
		super.printOn_(aWriter);
		aWriter.write(" on: ");
		aWriter.write(this.xy().toString());
	}
	/**
	 * Create the Dialog for IsrAreaModel with initial value.
	 * 
	 * @return sra.isr.geometry.basic.Isr2dPoint or null
	 */
	public static Isr2dPoint Request_() {
		return Request_(new Isr2dPoint(0.0, 0.0));
	}
	/**
	 * Create the Dialog for IsrAreaModel with value.
	 *
	 * @return sra.isr.geometry.basic.Isr2dPoint or null
	 * @param aPoint sra.isr.geometry.basic.Isr2dPoint
	 */
	public static Isr2dPoint Request_(Isr2dPoint aPoint) {
		IsrAreaModel areaModel = new IsrAreaModel();
		if (aPoint == null) {
			areaModel.xy_(new Isr2dPoint(0.0, 0.0));
		} else {
			areaModel.xy_(aPoint);
		}
		Isr2dPoint result = null;
		Frame parent = new Frame();
		IsrAreaView view = (IsrAreaView) areaModel.defaultView();
		view.setModel(areaModel);
		Dialog dialog = new Dialog(parent, "Area", true);
		dialog.setResizable(false);
		dialog.add("Center", (Component) view);
		dialog.add("South", areaModel._okCancelButtons(dialog));
		dialog.pack();
		try {
			Thread.sleep(0);
		} catch (Exception e) {
		}
		areaModel.changed();
		dialog.show();
		if (areaModel.accepted) {
			result = areaModel.xy();
		}
		return result;
	}
	/**
	 * Answer a window title.
	 * @return java.lang.String
	 */
	protected String windowTitle() {
		return "Area";
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public Isr2dPoint xy() {
		if (xy == null) {
			xy = new Isr2dPoint(0, 0);
		}
		return xy;
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public static IsrAreaModel Xy_(Isr2dPoint aPoint) {
		IsrAreaModel model = new IsrAreaModel();
		model.xy_(aPoint);
		return model;
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void xy_(Isr2dPoint aPoint) {
		if (xy != aPoint) {
			xy = aPoint;
			this.changed_(StObject.$("xy"));
		}
	}
}
