package sra.isr.interfaces.area;

import java.awt.*;
import java.awt.event.*;
import sra.smalltalk.*;
import sra.isr.geometry.basic.*;

/**
 * IsrAreaController class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       1999/12/21 (by Mitsuhiro Asada)
 * 	@updated:       2000/02/16 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrAreaController.java,v 1.11 2000/04/07 04:24:17 m-asada Exp $
 */
public class IsrAreaController extends StController implements MouseListener, MouseMotionListener {
	/**
	 * add listeners.
	 * @param aView sra.mvctest.StView
	 */
	protected void buildListener(StView newView) {
		Component aView = (Component) newView;
		aView.addMouseListener(this);
		aView.addMouseMotionListener(this);
	}
	/**
	 * Answer this model.
	 *
	 * @return sra.isr.interfaces.area.IsrAreaModel
	 */
	protected IsrAreaModel getModel() {
		return (IsrAreaModel) this.model();
	}
	/**
	 * Answer this view.
	 * 
	 * @return sra.isr.interfaces.area.IsrSpotView interface
	 */
	protected IsrAreaView getView() {
		return (IsrAreaView) this.view();
	}
	/**
	 * The General dragging action.
	 *
	 * @param event java.awt.event.MouseEvent
	 */
	public void mouseDragged(MouseEvent event) {
		if (this.isMenuButtonPressed_(event))
			return;
		IsrAreaView view = this.getView();
		if (view.plateArea().contains(event.getPoint())) {
			this.mousePressed(event);
		}
	}
	/**
	 * Invoked when the mouse button has been moved on a component
	 *
	 * @param event java.awt.event.MouseEvent
	 */
	public void mouseMoved(MouseEvent event) {
		IsrAreaView view = this.getView();
		if (view.plateArea().contains(event.getPoint())) {
			((Component) view).setCursor(Cursor.getPredefinedCursor(Cursor.CROSSHAIR_CURSOR));
		} else {
			((Component) view).setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
		}
	}
	/**
	 * Invoked when a mouse button has been pressed. 
	 *
	 * @param event java.awt.event.MouseEvent
	 */
	public void mousePressed(MouseEvent event) {
		if (this.isMenuButtonPressed_(event))
			return;
		Point point = event.getPoint();
		IsrAreaView view = this.getView();
		if (view.plateArea().contains(point)) {
			double x = ((double) (point.x - view.plateArea().getLocation().x)) / (view.plateArea().width - 1.0);
			double y = ((double) (point.y - view.plateArea().getLocation().y)) / (view.plateArea().height - 1.0);
			Isr2dPoint pointXy = new Isr2dPoint(x, y);
			((IsrAreaModel) this.model()).xy_(pointXy);
		}
	}
}
