package sra.isr.interfaces.nineColors;

import java.awt.*;
import java.util.*;
import sra.smalltalk.*;
import sra.isr.system.support.*;

/**
 * Isr9ColorsViewAwt class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       1999/12/21 (by Mitsuhiro Asada)
 * 	@updated:       2000/02/17 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: Isr9ColorsViewAwt.java,v 1.5 2000/04/07 04:24:19 m-asada Exp $
 */
public class Isr9ColorsViewAwt extends StViewCanvas implements Isr9ColorsView {
	protected Isr9ColorsController controller;
	//
	protected PopupMenu popupMenu;
	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		this.setSize(this.plateArea().width + 22, this.plateArea().height + 22);
		// controller
		controller = this.defaultController();
		controller.view_(this);
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 *
	 * @return java.awt.Color[]
	 */
	public Color[] colors() {
		return this.getModel().colors();
	}
	/**
	 * Answer a default controller.
	 *
	 * @return sra.smalltalk.StModel
	 */
	protected Isr9ColorsController defaultController() {
		return new Isr9ColorsController();
	}
	/**
	 * Answer a default model.
	 *
	 * @return sra.smalltalk.StModel
	 */
	protected StModel defaultModel() {
		return new Isr9ColorsModel();
	}
	/**
	 * paint this border rectangle.
	 *
	 * @param graphics java.awt.Graphics
	 */
	public void displayOn_(Graphics aGraphics) {
		this.displayPlateOn_(aGraphics);
	}
	/**
	 * Display the plate using the Graphics.
	 *
	 * @param aGraphics java.awt.Graphics
	 */
	public void displayPlateOn_(Graphics aGraphics) {
		if (!this.isShowing())
			return;
		Rectangle box = this.plateArea();
		aGraphics.clipRect(box.x - 1, box.y - 1, box.width + 2, box.height + 2);
		this.plate().displayOn_at_(aGraphics, box.getLocation());
		aGraphics.setColor(Color.black);
		aGraphics.drawRect(box.x - 1, box.y - 1, box.width + 1, box.height + 1);
	}
	/**
	 * Answer a Model.
	 *
	 * @return sra.isr.interfaces.nineColors.Isr9ColorsModel
	 */
	public Isr9ColorsModel getModel() {
		return (Isr9ColorsModel) this.model();
	}
	/**
	 * get the plate image.
	 *
	 * @return sra.smalltalk.StImage
	 */
	public StImage plate() {
		return this.getModel().plate();
	}
	/**
	 * get the plate bounds.
	 *
	 * @return java.awt.Rectangle
	 */
	public Rectangle plateArea() {
		Rectangle imageRect = this.plate().bounds();
		imageRect.translate(10, 10);
		return imageRect;
	}
	/**
	 * Rebuild this component.
	 * @param oldModel sra.smalltalk.StModel
	 * @param newModel sra.smalltalk.StModel
	 */
	protected void rebuildComponent(StModel oldModel, StModel newModel) {
		if (popupMenu != null) {
			this.remove(popupMenu);
		}
		StMenuModel menuModel = ((Isr9ColorsModel) newModel).defaultMenu();
		if (menuModel != null) {
			StMenu editMenu = (StMenu) menuModel.getItem("NineColorsMenu");
			popupMenu = StMenuViewForAwt.CreatePopupMenu(editMenu);
			this.add(popupMenu);
		}
	}
	/**
	 * model property accessing.
	 *
	 * @param aModel sra.isr.interfaces.nineColors.Isr9ColorsModel
	 */
	public void setModel(Isr9ColorsModel aModel) {
		this.model_(aModel);
	}
	/**
	 * Open the menu at the specified point.
	 *
	 * @param aPoint Point
	 */
	public void showPopupMenu(Point aPoint) {
		if (popupMenu != null) {
			popupMenu.show(this, aPoint.x, aPoint.y);
		}
	}
	/**
	 * Update the receiver according to the change notification from the model.
	 *
	 * @param evt sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		if (!this.isShowing())
			return;
		if (evt.getAspect() == $("colors")) {
			Graphics gc = this.getGraphics();
			try {
				this.displayPlateOn_(gc);
			} finally {
				gc.dispose();
			}
		}
	}
}
