package sra.isr.interfaces.nineColors;

import java.awt.*;
import java.awt.event.*;
import sra.smalltalk.*;

/**
 * Isr9ColorsView class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       2000/02/17 (by Mitsuhiro Asada)
 * 	@updated:       2000/03/13 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: Isr9ColorsView.java,v 1.10 2000/04/07 04:24:19 m-asada Exp $
 */
public interface Isr9ColorsView extends StView {
	/**
	 * Display the plate using the Graphics.
	 *
	 * @param aGraphics java.awt.Graphics
	 */
	public void displayPlateOn_(Graphics aGraphics);
	/**
	 * Answer a Model.
	 *
	 * @return sra.isr.interfaces.nineColors.Isr9ColorsModel
	 */
	public Isr9ColorsModel getModel();
	/**
	 * get the plate bounds.
	 *
	 * @return java.awt.Rectangle
	 */
	public Rectangle plateArea();
	/**
	 * model property accessing.
	 *
	 * @param aModel sra.isr.interfaces.nineColors.Isr9ColorsModel
	 */
	public void setModel(Isr9ColorsModel aModel);
	/**
	 * Open the menu at the specified point.
	 *
	 * @param aPoint Point
	 */
	public void showPopupMenu(Point aPoint);
}
