package sra.isr.interfaces.nineColors;

import java.awt.*;
import java.util.*;
import java.io.*;
import sra.smalltalk.*;
import sra.isr.system.support.*;
import sra.isr.image.support.*;
import sra.isr.geometry.basic.*;

/**
 * Isr9ColorsModel class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       1999/12/21 (by Mitsuhiro Asada)
 * 	@updated:       2000/02/17 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: Isr9ColorsModel.java,v 1.14 2000/04/07 04:24:19 m-asada Exp $
 */
public class Isr9ColorsModel extends StApplicationModel {
	protected Color[] colors;
	protected StImage plate;
	private boolean accepted = false;
	/**
	 * Construsctor
	 */
	public Isr9ColorsModel() {
		super();
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 *
	 * @return java.awt.Rectangle[]
	 * @param bounds java.awt.Rectangle
	 */
	private Rectangle[] _nineAreas_(Rectangle bounds) {
		Point size = new Point((int) (bounds.width / 3), (int) (bounds.height / 3));
		Point[] array = new Point[4];
		array[0] = new Point(size.x * 0, size.y * 0);
		array[1] = new Point(size.x * 1, size.y * 1);
		array[2] = new Point(size.x * 2, size.y * 2);
		array[3] = new Point(size.x * 3, size.y * 3);
		for (int index = 0; index < 4; index++) {
			array[index] = new Point(Math.min(array[index].x, bounds.width), Math.min(array[index].y, bounds.height));
		}
		Rectangle[] collection = new Rectangle[9];
		for (int j = 0; j < array.length - 1; j++) {
			for (int i = 0; i < array.length - 1; i++) {
				Point origin = new Point(array[i].x, array[j].y);
				Point corner = new Point(array[i + 1].x, array[j + 1].y);
				Rectangle box = new Rectangle(origin.x, origin.y, corner.x - origin.x, corner.y - origin.y);
				box.translate(bounds.x, bounds.y);
				collection[j * 3 + i] = box;
			}
		}
		return collection;
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 *
	 * @return java.awt.Color[]
	 * @param anImage sra.smalltalk.StImage
	 */
	private Color[] _nineColors_(StImage anImage) {
		Color[] collection = new Color[9];
		Rectangle[] areas = this._nineAreas_(anImage.bounds());
		for (int index = 0; index < areas.length; index++) {
			Rectangle area = areas[index];
			StImage image = new StImage(area.width, area.height);
			image = image.copy_from_in_rule_(image.bounds(), area.getLocation(), anImage, StImage.Over);
			Object[] histogram = IsrImageProcessor.ColorHistogram_(image);
			double max = 0.0;
			Color color = null;
			for (int i = 0; i < histogram.length; i++) {
				StAssociation assoc = (StAssociation) histogram[i];
				Color key = (Color) assoc.key();
				boolean isGray = ((key.getRed() == key.getGreen()) && (key.getGreen() == key.getBlue()));
				if ((((Double) assoc.value()).doubleValue() > max) && (!isGray)) {
					color = key;
					max = ((Double) assoc.value()).doubleValue();
				}
			}
			if (color == null) {
				max = 0.0;
				color = null;
				for (int i = 0; i < histogram.length; i++) {
					StAssociation assoc = (StAssociation) histogram[i];
					if (((Double) assoc.value()).doubleValue() > max) {
						color = (Color) assoc.key();
						max = ((Double) assoc.value()).doubleValue();
					}
				}
			}
			if (color == null) {
				color = Color.white;
			}
			collection[index] = color;
		}
		return collection;
	}
	/**
	 * defines OK/Cancel dialog buttons.
	 *
	 * @return Panel
	 */
	public Panel _okCancelButtons(final Dialog target) {
		Panel panel = new Panel();
		final Isr9ColorsModel this_ = this;
		panel.add("West", new Button("OK") {
			public boolean action(Event ev, Object what) {
				this_.accept();
				target.dispose();
				return true;
			}
		});
		panel.add("East", new Button("Cancel") {
			public boolean action(Event ev, Object what) {
				this_.cancel();
				target.dispose();
				return true;
			}
		});
		return panel;
	}
	/**
	 * accept button pressed action(in dialog mode)
	 */
	public void accept() {
		this.accepted = true;
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public Rectangle areaAt_(int index) {
		if (index == 0) {
			return new Rectangle(0, 0, 33, 33);
		}
		if (index == 1) {
			return new Rectangle(34, 0, 33, 33);
		}
		if (index == 2) {
			return new Rectangle(68, 0, 33, 33);
		}
		if (index == 3) {
			return new Rectangle(0, 34, 33, 33);
		}
		if (index == 4) {
			return new Rectangle(34, 34, 33, 33);
		}
		if (index == 5) {
			return new Rectangle(68, 34, 33, 33);
		}
		if (index == 6) {
			return new Rectangle(0, 68, 33, 33);
		}
		if (index == 7) {
			return new Rectangle(34, 68, 33, 33);
		}
		if (index == 8) {
			return new Rectangle(68, 68, 33, 33);
		}
		return null;
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public Color at_(int index) {
		return this.colors()[index];
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void at_put_(int index, Color color) {
		this.colors()[index] = color;
		this.plate = null;
		this.changed_(StObject.$("colors"));
	}
	/**
	 * accept button pressed action(in dialog mode). do nothing.
	 */
	public void cancel() {
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public Color[] colors() {
		if (this.colors == null) {
			this.colors = new Color[9];
		}
		return this.colors;
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public static Isr9ColorsModel Colors_(Color[] colorValues) {
		Color[] colors = new Color[9];
		for (int index = 0; index <= 8; index++) {
			colors[index] = colorValues[index];
		}
		Isr9ColorsModel model = new Isr9ColorsModel();
		model.colors_(colors);
		return model;
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void colors_(Color[] anArray) {
		this.colors = anArray;
		this.plate = null;
		this.changed_(StObject.$("colors"));
	}
	/**
	 * Answer a view.
	 *
	 * @return sra.smalltalk.StView
	 */
	public StView colorsView() {
		StView view = this.defaultView();
		view.model_(this);
		return view;
	}
	/**
	 * Create a default popup menu of the Isr9ColorsModel.
	 *
	 * @return sra.smalltalk.StMenuModel
	 */
	protected StMenuModel defaultMenu() {
		StMenuModel rootMenu = new StMenuModel();
		//
		StMenu editMenu = new StMenu("NineColorsMenu");
		editMenu.add(this.createMenuItem("clear", "doClear"));
		//editMenu.add(this.createMenuItem("scissors", "doScissors"));
		editMenu.addSeparator();
		editMenu.add(this.createMenuItem("colors", "doColors"));
		rootMenu.add(editMenu);
		//
		return rootMenu;
	}
	/**
	 * Answer a default view.
	 * @return sra.smalltalk.StView
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new Isr9ColorsViewAwt();
		} else {
			return this.CreateView("sra.isr.interfaces.nineColors.Isr9ColorsViewSwing");
		}
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void doClear() {
		this.colors_(new Color[9]);
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void doColors() {
		Color color;
		String colorString;
		for (int index = 0; index <= 8; index++) {
			color = this.colors()[index];
			if (color == null) {
				colorString = "null";
			} else {
				colorString = color.toString();
			}
			System.out.println(Integer.toString(index) + ": " + colorString);
		}
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void doScissors() {
		/* StImage image = StImage.FromUser() */
		StDialog.Warn_("ShouldNotImpliment");
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public int indexAt_(Isr2dPoint normalizedPoint) {
		Point point = new Point((int) (normalizedPoint.x() * (this.plate().width() - 1)), (int) (normalizedPoint.y() * (this.plate().height() - 1)));
		for (int index = 0; index <= 8; index++) {
			Rectangle area = this.areaAt_(index);
			if (area.contains(point)) {
				return index;
			}
		}
		return -1;
	}
	/**
	 * the plate image.
	 *
	 * @return sra.smalltalk.StImage
	 */
	public StImage plate() {
		if (this.plate != null)
			return plate;
		StImage image;
		StImage plate = IsrImageProcessor.Fill_color_(new StImage(101, 101), Color.black);
		for (int index = 0; index <= 8; index++) {
			Color color = this.at_(index);
			if (color == null) {
				image = this.Tile();
			} else {
				image = new StImage(1, 1);
				int value = color.getRGB();
				image.atX_y_put_(0, 0, value);
			}
			plate = plate.tile_from_in_rule_(this.areaAt_(index), new Point(0, 0), image, StImage.Over);
		}
		return plate;
	}
	/**
	 * Print my string representation on aWriter.
	 * 
	 * @param aWriter java.io.Writer
	 */
	public void printOn_(Writer aWriter) throws IOException {
		super.printOn_(aWriter);
		aWriter.write(" on: ");
		aWriter.write(this.colors().toString());
	}
	/**
	 * Create the Dialog for Isr9ColorsModel with initial value.
	 * 
	 * @return java.awt.Color[] or null
	 */
	public static Color[] Request_(Color[] anArray) {
		Isr9ColorsModel colorsModel = new Isr9ColorsModel();
		colorsModel.colors_(anArray);
		Color[] selection = null;
		Frame parent = new Frame();
		Isr9ColorsView view = (Isr9ColorsView) colorsModel.colorsView();
		Dialog dialog = new Dialog(parent, "9 Colors", true);
		dialog.setResizable(false);
		dialog.add("Center", (Component) view);
		dialog.add("South", colorsModel._okCancelButtons(dialog));
		dialog.pack();
		try {
			Thread.sleep(0);
		} catch (Exception e) {
		}
		colorsModel.changed();
		dialog.show();
		if (colorsModel.accepted) {
			selection = colorsModel.colors();
		}
		return selection;
	}
	/**
	 * the tile image.
	 *
	 * @return sra.smalltalk.StImage
	 */
	public static StImage Tile() {
		StImage image = new StImage(4, 4);
		int iw = StColorValue.Brightness_(0.9).getRGB();
		int ib = StColorValue.Brightness_(0.45).getRGB();
		image.atX_y_put_(0, 0, iw);
		image.atX_y_put_(1, 0, iw);
		image.atX_y_put_(2, 0, ib);
		image.atX_y_put_(3, 0, ib);
		image.atX_y_put_(0, 1, iw);
		image.atX_y_put_(1, 1, iw);
		image.atX_y_put_(2, 1, ib);
		image.atX_y_put_(3, 1, ib);
		image.atX_y_put_(0, 2, ib);
		image.atX_y_put_(1, 2, ib);
		image.atX_y_put_(2, 2, iw);
		image.atX_y_put_(3, 2, iw);
		image.atX_y_put_(0, 3, ib);
		image.atX_y_put_(1, 3, ib);
		image.atX_y_put_(2, 3, iw);
		image.atX_y_put_(3, 3, iw);
		return image;
	}
	/**
	 * Answer a window title.
	 * @return java.lang.String
	 */
	protected String windowTitle() {
		return "9 Colors";
	}
}
