package sra.isr.interfaces.nineColors;

import java.awt.*;
import java.awt.event.*;
import sra.smalltalk.*;
import sra.isr.interfaces.colors.*;
import sra.isr.geometry.basic.*;

/**
 * Isr9ColorsController class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       1999/12/21 (by Mitsuhiro Asada)
 * 	@updated:       2000/02/17 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: Isr9ColorsController.java,v 1.11 2000/04/07 04:24:19 m-asada Exp $
 */
public class Isr9ColorsController extends StController implements MouseListener, MouseMotionListener {
	/**
	 * add listeners.
	 * @param aView sra.mvctest.StView
	 */
	protected void buildListener(StView newView) {
		Component aView = (Component) newView;
		aView.addMouseListener(this);
		aView.addMouseMotionListener(this);
	}
	/**
	 * Answer this model.
	 *
	 * @return sra.isr.interfaces.nineColors.Isr9ColorsModel
	 */
	protected Isr9ColorsModel getModel() {
		return (Isr9ColorsModel) this.model();
	}
	/**
	 * Answer this view.
	 *
	 * @return sra.isr.interfaces.nineColors.Isr9ColorsView interface
	 */
	protected Isr9ColorsView getView() {
		return (Isr9ColorsView) this.view();
	}
	/**
	 * Invoked when the mouse button has been moved on a component
	 *
	 * @param event java.awt.event.MouseEvent
	 */
	public void mouseMoved(MouseEvent event) {
		Isr9ColorsView view = this.getView();
		if (view.plateArea().contains(event.getPoint())) {
			((Component) view).setCursor(Cursor.getPredefinedCursor(Cursor.CROSSHAIR_CURSOR));
		} else {
			((Component) view).setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
		}
	}
	/**
	 * Invoked when a mouse button has been pressed. 
	 *
	 * @param event java.awt.event.MouseEvent
	 */
	public void mousePressed(MouseEvent event) {
		Isr9ColorsView view = this.getView();
		Point point = event.getPoint();
		// popup menu
		if (event.isMetaDown()) {
			view.showPopupMenu(point);
			return;
		}
		Isr9ColorsModel colorsModel = this.getModel();
		if (view.plateArea().contains(point)) {
			double x = ((double) (point.x - view.plateArea().getLocation().x)) / (view.plateArea().width - 1.0);
			double y = ((double) (point.y - view.plateArea().getLocation().y)) / (view.plateArea().height - 1.0);
			Isr2dPoint pointXy = new Isr2dPoint(x, y);
			int index = colorsModel.indexAt_(pointXy);
			if (index == -1)
				return;
			Color color = null;
			if (event.isShiftDown()) {
				color = IsrColorChoiceSBH.Request();
				if (color == null)
					return;
			} else {
				/* color = IsrColorSpuit.Request(); */
				color = colorsModel.at_(index);
				if (color == null) {
					color = IsrColorChoiceSBH.Request();
				} else {
					color = IsrColorChoiceSBH.Request_(color);
				}
				if (color == null)
					return;
			}
			colorsModel.at_put_(index, color);
			event.consume();
		}
	}
}
