/*
 * Decompiled with CFR 0.152.
 */
package sra.smalltalk;

import java.util.Vector;
import sra.smalltalk.SmalltalkException;
import sra.smalltalk.StBlockClosure;
import sra.smalltalk.StObject;

public class StSortedCollection
extends StObject {
    protected StBlockClosure sortBlock = null;
    protected Vector _elements = new Vector();

    private StSortedCollection() {
    }

    public StSortedCollection(StBlockClosure aBlock) {
        this.sortBlock_(aBlock);
    }

    public StSortedCollection(StBlockClosure aBlock, Object[] anArray) {
        this(aBlock);
        int i = 0;
        while (i < anArray.length) {
            this.add_(anArray[i]);
            ++i;
        }
    }

    public StSortedCollection(StBlockClosure aBlock, Vector aCollection) {
        this(aBlock);
        Object[] anArray = new Object[aCollection.size()];
        aCollection.copyInto(anArray);
        int i = 0;
        while (i < anArray.length) {
            this.add_(anArray[i]);
            ++i;
        }
    }

    public Object[] _asArray() {
        Object[] newArray = new Object[this._elements.size()];
        this._elements.copyInto(newArray);
        return newArray;
    }

    public Object add_(Object newObject) {
        if (this._elements.isEmpty()) {
            this._elements.addElement(newObject);
        } else {
            int nextIndex = this.indexForInserting_(newObject);
            this._elements.insertElementAt(newObject, nextIndex);
        }
        return newObject;
    }

    private boolean compareElement_to_(Object e1, Object e2) {
        if (this.sortBlock == null) {
            throw new SmalltalkException("No sort block.");
        }
        return (Boolean)this.sortBlock.value_value_(e1, e2);
    }

    private int indexForInserting_(Object newObject) {
        int low = 0;
        int high = this._elements.size() - 1;
        int index = (high + low) / 2;
        while (low <= high) {
            if (this.compareElement_to_(this._elements.elementAt(index), newObject)) {
                low = index + 1;
            } else {
                high = index - 1;
            }
            index = (high + low) / 2;
        }
        return low;
    }

    public int size() {
        return this._elements.size();
    }

    public void sortBlock_(StBlockClosure aBlock) {
        this.sortBlock = aBlock;
    }
}

